/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop;

import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;
import org.janusgraph.core.attribute.Geo;
import org.janusgraph.core.attribute.Text;
import org.janusgraph.graphdb.tinkerpop.io.JanusGraphP;

public class JanusGraphPSerializer
extends Serializer<JanusGraphP> {
    public void write(Kryo kryo, Output output, JanusGraphP p) {
        output.writeString(p.getBiPredicate().toString());
        kryo.writeClassAndObject(output, p.getValue());
    }

    public JanusGraphP read(Kryo kryo, Input input, Class<JanusGraphP> aClass) {
        String predicate = input.readString();
        Object value = kryo.readClassAndObject(input);
        return JanusGraphPSerializer.createPredicateWithValue(predicate, value);
    }

    public static boolean checkForJanusGraphPredicate(String predicateName) {
        switch (predicateName) {
            case "geoIntersect": 
            case "geoDisjoint": 
            case "geoWithin": 
            case "geoContains": 
            case "textContains": 
            case "textNotContains": 
            case "textContainsFuzzy": 
            case "textNotContainsFuzzy": 
            case "textContainsPrefix": 
            case "textNotContainsPrefix": 
            case "textContainsRegex": 
            case "textNotContainsRegex": 
            case "textContainsPhrase": 
            case "textNotContainsPhrase": 
            case "textFuzzy": 
            case "textNotFuzzy": 
            case "textPrefix": 
            case "textNotPrefix": 
            case "textRegex": 
            case "textNotRegex": {
                return true;
            }
        }
        return false;
    }

    public static JanusGraphP createPredicateWithValue(String predicateName, Object value) {
        switch (predicateName) {
            case "geoIntersect": {
                return Geo.geoIntersect(value);
            }
            case "geoDisjoint": {
                return Geo.geoDisjoint(value);
            }
            case "geoWithin": {
                return Geo.geoWithin(value);
            }
            case "geoContains": {
                return Geo.geoContains(value);
            }
            case "textContains": {
                return Text.textContains(value);
            }
            case "textNotContains": {
                return Text.textNotContains(value);
            }
            case "textContainsFuzzy": {
                return Text.textContainsFuzzy(value);
            }
            case "textNotContainsFuzzy": {
                return Text.textNotContainsFuzzy(value);
            }
            case "textContainsPrefix": {
                return Text.textContainsPrefix(value);
            }
            case "textNotContainsPrefix": {
                return Text.textNotContainsPrefix(value);
            }
            case "textContainsRegex": {
                return Text.textContainsRegex(value);
            }
            case "textNotContainsRegex": {
                return Text.textNotContainsRegex(value);
            }
            case "textContainsPhrase": {
                return Text.textContainsPhrase(value);
            }
            case "textNotContainsPhrase": {
                return Text.textNotContainsPhrase(value);
            }
            case "textFuzzy": {
                return Text.textFuzzy(value);
            }
            case "textNotFuzzy": {
                return Text.textNotFuzzy(value);
            }
            case "textPrefix": {
                return Text.textPrefix(value);
            }
            case "textNotPrefix": {
                return Text.textNotPrefix(value);
            }
            case "textRegex": {
                return Text.textRegex(value);
            }
            case "textNotRegex": {
                return Text.textNotRegex(value);
            }
        }
        throw new UnsupportedOperationException("Matched predicate {" + predicateName + "} is not support by JanusGraphPSerializer");
    }
}

