/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.jsr223;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Translator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.CardinalityValueTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Tree;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.TraversalStrategyProxy;
import org.apache.tinkerpop.gremlin.process.traversal.util.BytecodeHelper;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class JavaTranslator<S extends TraversalSource, T extends Traversal.Admin<?, ?>>
implements Translator.StepTranslator<S, T> {
    private final S traversalSource;
    private final Class<?> anonymousTraversal;
    private static final Map<Class<?>, Map<String, List<ReflectedMethod>>> GLOBAL_METHOD_CACHE = new ConcurrentHashMap();
    private final Map<Class<?>, Map<String, Method>> localMethodCache = new ConcurrentHashMap();
    private final Method anonymousTraversalStart;

    private JavaTranslator(S traversalSource) {
        this.traversalSource = traversalSource;
        this.anonymousTraversal = traversalSource.getAnonymousTraversalClass().orElse(null);
        this.anonymousTraversalStart = this.getStartMethodFromAnonymousTraversal();
    }

    public static <S extends TraversalSource, T extends Traversal.Admin<?, ?>> JavaTranslator<S, T> of(S traversalSource) {
        return new JavaTranslator<S, T>(traversalSource);
    }

    @Override
    public S getTraversalSource() {
        return this.traversalSource;
    }

    @Override
    public T translate(Bytecode bytecode) {
        if (BytecodeHelper.isGraphOperation(bytecode)) {
            throw new IllegalArgumentException("JavaTranslator cannot translate traversal operations");
        }
        Object dynamicSource = this.traversalSource;
        Traversal.Admin traversal = null;
        for (Bytecode.Instruction instruction : bytecode.getSourceInstructions()) {
            dynamicSource = (TraversalSource)this.invokeMethod(dynamicSource, TraversalSource.class, instruction.getOperator(), instruction.getArguments());
        }
        boolean spawned = false;
        for (Bytecode.Instruction instruction : bytecode.getStepInstructions()) {
            if (!spawned) {
                traversal = (Traversal.Admin)this.invokeMethod(dynamicSource, Traversal.class, instruction.getOperator(), instruction.getArguments());
                spawned = true;
                continue;
            }
            this.invokeMethod(traversal, Traversal.class, instruction.getOperator(), instruction.getArguments());
        }
        return (T)traversal;
    }

    @Override
    public String getTargetLanguage() {
        return "gremlin-java";
    }

    public String toString() {
        return StringFactory.translatorString(this);
    }

    private Object translateObject(Object object) {
        if (object instanceof Bytecode.Binding) {
            return this.translateObject(((Bytecode.Binding)object).value());
        }
        if (object instanceof Bytecode) {
            Bytecode bc = (Bytecode)object;
            if (!bc.getSourceInstructions().isEmpty()) {
                if (bc.getSourceInstructions().size() != 1) {
                    throw new IllegalStateException("More than one source instruction defined in bytecode");
                }
                Bytecode.Instruction inst = bc.getSourceInstructions().get(0);
                if (inst.getOperator().equals(CardinalityValueTraversal.class.getSimpleName())) {
                    return CardinalityValueTraversal.from(inst);
                }
                throw new IllegalStateException(String.format("Unknown source instruction for %s", inst.getOperator()));
            }
            try {
                Traversal.Admin traversal = (Traversal.Admin)this.anonymousTraversalStart.invoke(null, new Object[0]);
                for (Bytecode.Instruction instruction : bc.getStepInstructions()) {
                    this.invokeMethod(traversal, Traversal.class, instruction.getOperator(), instruction.getArguments());
                }
                return traversal;
            }
            catch (Throwable e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
        if (object instanceof TraversalStrategyProxy) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Configuration configuration = ((TraversalStrategyProxy)object).getConfiguration();
            configuration.getKeys().forEachRemaining(key -> map.put((String)key, this.translateObject(configuration.getProperty(key))));
            return this.invokeStrategyCreationMethod(object, map);
        }
        if (object instanceof Map) {
            Tree map = object instanceof Tree ? new Tree() : (object instanceof LinkedHashMap ? new LinkedHashMap(((Map)object).size()) : new HashMap(((Map)object).size()));
            for (Map.Entry entry : ((Map)object).entrySet()) {
                map.put(this.translateObject(entry.getKey()), this.translateObject(entry.getValue()));
            }
            return map;
        }
        if (object instanceof List) {
            ArrayList<Object> list = new ArrayList<Object>(((List)object).size());
            for (Object o : (List)object) {
                list.add(this.translateObject(o));
            }
            return list;
        }
        if (object instanceof BulkSet) {
            BulkSet<Object> bulkSet = new BulkSet<Object>();
            for (Map.Entry entry : ((BulkSet)object).asBulk().entrySet()) {
                bulkSet.add(this.translateObject(entry.getKey()), entry.getValue());
            }
            return bulkSet;
        }
        if (object instanceof Set) {
            HashSet set = object instanceof LinkedHashSet ? new LinkedHashSet(((Set)object).size()) : new HashSet(((Set)object).size());
            for (Object o : (Set)object) {
                set.add(this.translateObject(o));
            }
            return set;
        }
        return object;
    }

    private Object invokeStrategyCreationMethod(Object delegate, Map<String, Object> map) {
        Class strategyClass = ((TraversalStrategyProxy)delegate).getStrategyClass();
        Map methodCache = this.localMethodCache.computeIfAbsent(strategyClass, k -> {
            HashMap<String, Method> cacheEntry = new HashMap<String, Method>();
            try {
                cacheEntry.put("instance", strategyClass.getMethod("instance", new Class[0]));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            try {
                cacheEntry.put("create", strategyClass.getMethod("create", Configuration.class));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (cacheEntry.isEmpty()) {
                throw new IllegalStateException(String.format("%s does can only be constructed with instance() or create(Configuration)", strategyClass.getSimpleName()));
            }
            return cacheEntry;
        });
        try {
            return map.isEmpty() ? ((Method)methodCache.get("instance")).invoke(null, new Object[0]) : ((Method)methodCache.get("create")).invoke(null, new MapConfiguration(map));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private Object invokeMethod(Object delegate, Class<?> returnType, String methodName, Object ... arguments) {
        Map methodCache = GLOBAL_METHOD_CACHE.getOrDefault(delegate.getClass(), new HashMap());
        if (methodCache.isEmpty()) {
            JavaTranslator.buildMethodCache(delegate, methodCache);
        }
        Object[] argumentsCopy = arguments.length > 0 ? new Object[arguments.length] : arguments;
        for (int i = 0; i < arguments.length; ++i) {
            argumentsCopy[i] = this.translateObject(arguments[i]);
        }
        if (!methodCache.containsKey(methodName)) {
            throw new IllegalStateException(this.generateMethodNotFoundMessage("Could not locate method", delegate, methodName, argumentsCopy));
        }
        try {
            for (ReflectedMethod methodx : (List)methodCache.get(methodName)) {
                Parameter[] parameters;
                Method method = methodx.method;
                if (!returnType.isAssignableFrom(method.getReturnType()) || (parameters = methodx.parameters).length != argumentsCopy.length && !methodx.hasVarArgs) continue;
                Object[] newArguments = new Object[parameters.length];
                boolean found = true;
                for (int i = 0; i < parameters.length; ++i) {
                    if (parameters[i].isVarArgs()) {
                        Class<?> parameterClass = parameters[i].getType().getComponentType();
                        if (argumentsCopy.length > i && argumentsCopy[i] != null && !parameterClass.isAssignableFrom(argumentsCopy[i].getClass())) {
                            found = false;
                            break;
                        }
                        Object[] varArgs = (Object[])Array.newInstance(parameterClass, argumentsCopy.length - i);
                        int counter = 0;
                        for (int j = i; j < argumentsCopy.length; ++j) {
                            varArgs[counter++] = argumentsCopy[j];
                        }
                        newArguments[i] = varArgs;
                        break;
                    }
                    if (!(i < argumentsCopy.length && (null == argumentsCopy[i] || argumentsCopy[i] != null && (parameters[i].getType().isAssignableFrom(argumentsCopy[i].getClass()) || parameters[i].getType().isPrimitive() && (Number.class.isAssignableFrom(argumentsCopy[i].getClass()) || argumentsCopy[i].getClass().equals(Boolean.class) || argumentsCopy[i].getClass().equals(Byte.class) || argumentsCopy[i].getClass().equals(Character.class)))))) {
                        found = false;
                        break;
                    }
                    newArguments[i] = argumentsCopy[i];
                }
                if (methodName.equals("has") && newArguments.length > 0 && null == newArguments[0] && method.getParameterTypes()[0].isAssignableFrom(T.class)) {
                    found = false;
                }
                if (!found) continue;
                return 0 == newArguments.length ? method.invoke(delegate, new Object[0]) : method.invoke(delegate, newArguments);
            }
        }
        catch (Throwable e) {
            throw new IllegalStateException(this.generateMethodNotFoundMessage(e.getMessage(), null, methodName, argumentsCopy), e);
        }
        throw new IllegalArgumentException(this.generateMethodNotFoundMessage("Could not locate exact method given the supplied arguments", delegate, methodName, argumentsCopy));
    }

    private String generateMethodNotFoundMessage(String message, Object delegate, String methodNameNotFound, Object[] args) {
        Object[] arguments = null == args ? new Object[]{} : args;
        String delegateClassName = delegate != null ? delegate.getClass().getSimpleName() : "";
        return message + ": " + delegateClassName + "." + methodNameNotFound + "(" + Stream.of(arguments).map(a -> null == a ? "null" : a.getClass().getSimpleName()).collect(Collectors.joining(", ")) + ")";
    }

    private static synchronized void buildMethodCache(Object delegate, Map<String, List<ReflectedMethod>> methodCache) {
        if (methodCache.isEmpty()) {
            for (Method method : delegate.getClass().getMethods()) {
                List list = methodCache.computeIfAbsent(method.getName(), k -> new ArrayList());
                list.add(new ReflectedMethod(method));
            }
            GLOBAL_METHOD_CACHE.put(delegate.getClass(), methodCache);
        }
    }

    private Method getStartMethodFromAnonymousTraversal() {
        if (this.anonymousTraversal != null) {
            try {
                return this.anonymousTraversal.getMethod("start", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    private static final class ReflectedMethod {
        private final Method method;
        private final Parameter[] parameters;
        private final boolean hasVarArgs;

        public ReflectedMethod(Method m) {
            this.method = m;
            this.parameters = m.getParameters();
            this.hasVarArgs = this.parameters.length > 0 && this.parameters[this.parameters.length - 1].isVarArgs();
        }
    }
}

