/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.google.common.base.Preconditions;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.common.AbstractStoreTransaction;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;

public class CQLTransaction
extends AbstractStoreTransaction {
    private final ConsistencyLevel readConsistencyLevel = DefaultConsistencyLevel.valueOf((String)((String)this.getConfiguration().getCustomOption(CQLConfigOptions.READ_CONSISTENCY)));
    private final ConsistencyLevel writeConsistencyLevel = DefaultConsistencyLevel.valueOf((String)((String)this.getConfiguration().getCustomOption(CQLConfigOptions.WRITE_CONSISTENCY)));

    public CQLTransaction(BaseTransactionConfig config) {
        super(config);
    }

    public ConsistencyLevel getReadConsistencyLevel() {
        return this.readConsistencyLevel;
    }

    public ConsistencyLevel getWriteConsistencyLevel() {
        return this.writeConsistencyLevel;
    }

    public static CQLTransaction getTransaction(StoreTransaction storeTransaction) {
        Preconditions.checkNotNull((Object)storeTransaction);
        Preconditions.checkArgument((boolean)(storeTransaction instanceof CQLTransaction), (String)"Unexpected transaction type %s", (Object)storeTransaction.getClass().getName());
        return (CQLTransaction)storeTransaction;
    }

    public String toString() {
        return "CQLTransaction@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + "[read=" + this.readConsistencyLevel + ",write=" + this.writeConsistencyLevel + "]";
    }
}

