/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.util.datastructures;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public class IterablesUtil {
    public static final Predicate NO_FILTER = new NoFilter();

    public static <O> Iterable<O> emptyIterable() {
        return Collections::emptyIterator;
    }

    public static <E> Predicate<E> noFilter() {
        return NO_FILTER;
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static int size(Iterable i) {
        if (i instanceof Collection) {
            return ((Collection)i).size();
        }
        return Iterables.size((Iterable)i);
    }

    public static boolean sizeLargerOrEqualThan(Iterable i, int limit) {
        if (i instanceof Collection) {
            return ((Collection)i).size() >= limit;
        }
        Iterator iterator = i.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            if (++count < limit) continue;
            return true;
        }
        return false;
    }

    public static <E> List<E> mergeSort(Collection<E> a, Collection<E> b, Comparator<E> comp) {
        Iterator<E> iteratorA = a.iterator();
        Iterator<E> iteratorB = b.iterator();
        Object headA = iteratorA.hasNext() ? iteratorA.next() : null;
        Object headB = iteratorB.hasNext() ? iteratorB.next() : null;
        ArrayList<Object> result = new ArrayList<Object>(a.size() + b.size());
        while (headA != null || headB != null) {
            Object next;
            if (headA == null) {
                next = headB;
                headB = null;
            } else if (headB == null) {
                next = headA;
                headA = null;
            } else if (comp.compare(headA, headB) <= 0) {
                next = headA;
                headA = null;
            } else {
                next = headB;
                headB = null;
            }
            assert (next != null);
            Preconditions.checkArgument((result.isEmpty() || comp.compare(result.get(result.size() - 1), next) <= 0 ? 1 : 0) != 0, (Object)"The input collections are not sorted");
            result.add(next);
            if (headA == null) {
                Object v0 = headA = iteratorA.hasNext() ? iteratorA.next() : null;
            }
            if (headB != null) continue;
            headB = iteratorB.hasNext() ? iteratorB.next() : null;
        }
        return result;
    }

    private static class NoFilter<E>
    implements Predicate<E> {
        private NoFilter() {
        }

        public boolean apply(@Nullable E e) {
            return true;
        }
    }
}

