/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ElementValueComparator;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.apache.tinkerpop.gremlin.util.function.MultiComparator;
import org.janusgraph.graphdb.tinkerpop.optimize.step.HasStepFolder;
import org.janusgraph.graphdb.util.CloseableAbstractIterator;

public class MultiDistinctOrderedIterator<E extends Element>
extends CloseableAbstractIterator<E> {
    private final Map<Integer, Iterator<E>> iterators;
    private final PriorityQueue<E> queue;
    private final Set<Object> allElements = new HashSet<Object>();
    private final List<E> iteratorValues;
    private final Map<E, Integer> iteratorIdx;
    private final Integer limit;
    private final boolean singleIterator;
    private long count = 0L;

    public MultiDistinctOrderedIterator(Integer lowLimit, Integer highLimit, List<Iterator<E>> iterators, List<HasStepFolder.OrderEntry> orders) {
        this.limit = highLimit;
        this.singleIterator = iterators.size() == 1;
        this.iterators = new LinkedHashMap<Integer, Iterator<E>>(iterators.size());
        this.iteratorValues = new ArrayList(iterators.size());
        this.iteratorIdx = new HashMap<E, Integer>(iterators.size());
        for (int i = 0; i < iterators.size(); ++i) {
            this.iterators.put(i, iterators.get(i));
            this.iteratorValues.add(null);
        }
        ArrayList comp = new ArrayList();
        orders.forEach(o -> comp.add(new ElementValueComparator(o.key, (Comparator)o.order)));
        this.queue = new PriorityQueue(iterators.size(), new MultiComparator(comp));
        for (long i = 0L; i < (long)lowLimit.intValue() && this.hasNext(); ++i) {
            this.next();
        }
    }

    protected E computeNext() {
        if (this.limit != null && this.limit != Integer.MAX_VALUE && this.count >= (long)this.limit.intValue()) {
            return (E)((Element)this.endOfData());
        }
        for (int i = 0; i < this.iterators.size(); ++i) {
            if (this.iteratorValues.get(i) != null || !this.iterators.get(i).hasNext()) continue;
            Element element = null;
            do {
                if (!this.allElements.contains((element = (Element)this.iterators.get(i).next()).id())) continue;
                element = null;
            } while (element == null && this.iterators.get(i).hasNext());
            if (element == null) continue;
            this.iteratorValues.set(i, element);
            this.iteratorIdx.put(element, i);
            this.queue.add(element);
            if (this.singleIterator) continue;
            this.allElements.add(element.id());
        }
        if (this.queue.isEmpty()) {
            return (E)((Element)this.endOfData());
        }
        ++this.count;
        Element result = (Element)this.queue.remove();
        this.iteratorValues.set(this.iteratorIdx.remove(result), null);
        return (E)result;
    }

    public void close() {
        this.iterators.values().forEach(CloseableIterator::closeIterator);
    }
}

