/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public enum StandardIndexProvider {
    LUCENE("org.janusgraph.diskstorage.lucene.LuceneIndex", "lucene"),
    ELASTICSEARCH("org.janusgraph.diskstorage.es.ElasticSearchIndex", Arrays.asList("elasticsearch", "es")),
    SOLR("org.janusgraph.diskstorage.solr.SolrIndex", "solr");

    private static final Set<String> ALL_SHORTHANDS;
    private static final Map<String, String> ALL_MANAGER_CLASSES;
    private final String providerName;
    private final Set<String> shorthands;

    private StandardIndexProvider(String providerName, String shorthand) {
        this(providerName, Collections.singleton(shorthand));
    }

    private StandardIndexProvider(String providerName, Collection<String> shorthands) {
        this.providerName = providerName;
        this.shorthands = Collections.unmodifiableSet(new LinkedHashSet<String>(shorthands));
    }

    public Set<String> getShorthands() {
        return this.shorthands;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public static Set<String> getAllShorthands() {
        return ALL_SHORTHANDS;
    }

    public static Map<String, String> getAllProviderClasses() {
        return ALL_MANAGER_CLASSES;
    }

    static {
        StandardIndexProvider[] backends = StandardIndexProvider.values();
        LinkedHashSet tempShorthands = new LinkedHashSet(backends.length);
        HashMap tempClassMap = new HashMap(backends.length);
        for (StandardIndexProvider backend : backends) {
            backend.getShorthands().forEach(shorthand -> {
                tempShorthands.add(shorthand);
                tempClassMap.put(shorthand, backend.getProviderName());
            });
        }
        ALL_SHORTHANDS = Collections.unmodifiableSet(tempShorthands);
        ALL_MANAGER_CLASSES = Collections.unmodifiableMap(tempClassMap);
    }
}

