/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure.io;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.KryoShimServiceLoader;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraph;

public final class VertexWritable
implements Writable,
Serializable {
    private StarGraph.StarVertex vertex;

    public VertexWritable() {
    }

    public VertexWritable(Vertex vertex) {
        this.set(vertex);
    }

    public void set(Vertex vertex) {
        this.vertex = vertex instanceof StarGraph.StarVertex ? (StarGraph.StarVertex)vertex : StarGraph.of((Vertex)vertex).getStarVertex();
    }

    public StarGraph.StarVertex get() {
        return this.vertex;
    }

    public void readFields(DataInput input) throws IOException {
        this.vertex = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(WritableUtils.readCompressedByteArray((DataInput)input));
        this.vertex = ((StarGraph)KryoShimServiceLoader.readClassAndObject((InputStream)bais)).getStarVertex();
    }

    public void write(DataOutput output) throws IOException {
        byte[] serialized = KryoShimServiceLoader.writeClassAndObjectToBytes((Object)this.vertex.graph());
        WritableUtils.writeCompressedByteArray((DataOutput)output, (byte[])serialized);
    }

    private void writeObject(ObjectOutputStream outputStream) throws IOException {
        this.write(outputStream);
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        this.readFields(inputStream);
    }

    public boolean equals(Object other) {
        return other instanceof VertexWritable && ElementHelper.areEqual((Vertex)this.vertex, (Vertex)((VertexWritable)other).get());
    }

    public int hashCode() {
        return this.vertex.hashCode();
    }

    public String toString() {
        return this.vertex.toString();
    }
}

