/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql.builder;

import com.datastax.oss.driver.api.core.CqlSession;
import java.util.Map;
import org.janusgraph.diskstorage.common.DistributedStoreManager;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.diskstorage.cql.CQLKeyColumnValueStore;
import org.janusgraph.diskstorage.cql.function.ConsumerWithBackendException;
import org.janusgraph.diskstorage.cql.function.mutate.AbstractCQLMutateManyFunction;
import org.janusgraph.diskstorage.cql.function.mutate.CQLMutateManyFunction;
import org.janusgraph.diskstorage.cql.function.mutate.CQLMutateManyLoggedFunction;
import org.janusgraph.diskstorage.cql.function.mutate.CQLMutateManyUnloggedFunction;
import org.janusgraph.diskstorage.util.backpressure.QueryBackPressure;
import org.janusgraph.diskstorage.util.time.TimestampProvider;

public class CQLMutateManyFunctionBuilder {
    public CQLMutateManyFunction build(CqlSession session, Configuration configuration, TimestampProvider times, boolean assignTimestamp, Map<String, CQLKeyColumnValueStore> openStores, ConsumerWithBackendException<DistributedStoreManager.MaskedTimestamp> sleepAfterWriteFunction, QueryBackPressure queriesBackPressure) {
        int batchSize = (Integer)configuration.get(CQLConfigOptions.BATCH_STATEMENT_SIZE, new String[0]);
        boolean atomicBatch = (Boolean)configuration.get(CQLConfigOptions.ATOMIC_BATCH_MUTATE, new String[0]);
        AbstractCQLMutateManyFunction mutateManyFunction = atomicBatch ? new CQLMutateManyLoggedFunction(times, assignTimestamp, openStores, session, sleepAfterWriteFunction, queriesBackPressure) : new CQLMutateManyUnloggedFunction(batchSize, session, openStores, times, assignTimestamp, sleepAfterWriteFunction, queriesBackPressure);
        return mutateManyFunction;
    }
}

