/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.inmemory;

import com.google.common.base.Preconditions;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.inmemory.BufferPage;
import org.janusgraph.diskstorage.inmemory.BufferPageUtils;
import org.janusgraph.diskstorage.inmemory.MemoryEntryList;
import org.janusgraph.diskstorage.inmemory.SharedEntryBuffer;
import org.janusgraph.diskstorage.inmemory.SharedEntryBufferFragmentationReport;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinglePageEntryBuffer
extends BufferPage
implements SharedEntryBuffer {
    private static final Logger log = LoggerFactory.getLogger(BufferPageUtils.class);

    public SinglePageEntryBuffer() {
        super(EMPTY_INDEX, EMPTY_DATA);
    }

    SinglePageEntryBuffer(int[] index, byte[] data) {
        super(index, data);
    }

    @Override
    public int numPages() {
        return 1;
    }

    @Override
    public EntryList getSlice(KeySliceQuery query) {
        int end;
        int start = this.getIndex(query.getSliceStart());
        if (start < 0) {
            start = -start - 1;
        }
        if ((end = this.getIndex(query.getSliceEnd())) < 0) {
            end = -end - 1;
        }
        if (start < end) {
            MemoryEntryList result = new MemoryEntryList(end - start);
            for (int i = start; !(i >= end || query.hasLimit() && result.size() >= query.getLimit()); ++i) {
                result.add(this.getNoCopy(i));
            }
            return result;
        }
        return EntryList.EMPTY_LIST;
    }

    @Override
    public void mutate(Entry[] add, Entry[] del, int maxPageSize) {
        List res = this.merge(add, 0, add.length, del, 0, del.length, Integer.MAX_VALUE);
        if (res.isEmpty()) {
            this.setOffsetIndex(EMPTY_INDEX);
            this.setRawData(EMPTY_DATA);
        } else {
            Preconditions.checkArgument((res.size() == 1 ? 1 : 0) != 0);
            BufferPage resPage = (BufferPage)res.get(0);
            this.setRawData(resPage.getRawData());
            this.setOffsetIndex(resPage.getOffsetIndex());
        }
    }

    @Override
    public boolean isPaged() {
        return false;
    }

    @Override
    public SharedEntryBufferFragmentationReport createFragmentationReport(int maxPageSize) {
        return new SharedEntryBufferFragmentationReport.Builder().pageCount(1).build();
    }

    @Override
    public void quickDefragment(int maxPageSize) {
    }

    @Override
    public void dumpTo(DataOutputStream out) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("number of pages in single page buffer is " + this.numPages());
        }
        out.writeInt(this.numPages());
        BufferPageUtils.dumpTo(this, out);
    }
}

