/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.agrona.concurrent;

import java.util.Collection;
import java.util.function.Consumer;
import org.apache.hadoop.hbase.shaded.org.agrona.UnsafeAccess;
import org.apache.hadoop.hbase.shaded.org.agrona.concurrent.AbstractConcurrentArrayQueue;
import org.apache.hadoop.hbase.shaded.org.agrona.hints.ThreadHints;

public class ManyToManyConcurrentArrayQueue<E>
extends AbstractConcurrentArrayQueue<E> {
    private static final int SEQUENCES_ARRAY_BASE = UnsafeAccess.UNSAFE.arrayBaseOffset(long[].class);
    private final long[] sequences;

    public ManyToManyConcurrentArrayQueue(int requestedCapacity) {
        super(requestedCapacity);
        if (requestedCapacity < 2) {
            throw new IllegalArgumentException("requestedCapacity must be >= 2: requestedCapacity=" + requestedCapacity);
        }
        long[] sequences = new long[this.capacity];
        for (int i = 0; i < this.capacity; ++i) {
            sequences[i] = i;
        }
        UnsafeAccess.UNSAFE.putLongVolatile(sequences, ManyToManyConcurrentArrayQueue.sequenceArrayOffset(0L, sequences.length - 1), 0L);
        this.sequences = sequences;
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException("element cannot be null");
        }
        long mask = this.capacity - 1;
        long[] sequences = this.sequences;
        Object[] buffer = this.buffer;
        long currentTail;
        long sequenceOffset;
        long sequence;
        while ((sequence = UnsafeAccess.UNSAFE.getLongVolatile(sequences, sequenceOffset = ManyToManyConcurrentArrayQueue.sequenceArrayOffset(currentTail = this.tail, mask))) >= currentTail) {
            if (UnsafeAccess.UNSAFE.compareAndSwapLong(this, TAIL_OFFSET, currentTail, currentTail + 1L)) {
                UnsafeAccess.UNSAFE.putObject(buffer, ManyToManyConcurrentArrayQueue.sequenceToBufferOffset(currentTail, mask), e);
                UnsafeAccess.UNSAFE.putOrderedLong(sequences, sequenceOffset, currentTail + 1L);
                return true;
            }
            ThreadHints.onSpinWait();
        }
        return false;
    }

    @Override
    public E poll() {
        long[] sequences = this.sequences;
        Object[] buffer = this.buffer;
        long mask = this.capacity - 1;
        long attemptedHead;
        long currentHead;
        long sequenceOffset;
        long sequence;
        while ((sequence = UnsafeAccess.UNSAFE.getLongVolatile(sequences, sequenceOffset = ManyToManyConcurrentArrayQueue.sequenceArrayOffset(currentHead = this.head, mask))) >= (attemptedHead = currentHead + 1L)) {
            if (UnsafeAccess.UNSAFE.compareAndSwapLong(this, HEAD_OFFSET, currentHead, attemptedHead)) {
                long elementOffset = ManyToManyConcurrentArrayQueue.sequenceToBufferOffset(currentHead, mask);
                Object e = UnsafeAccess.UNSAFE.getObject(buffer, elementOffset);
                UnsafeAccess.UNSAFE.putObject(buffer, elementOffset, null);
                UnsafeAccess.UNSAFE.putOrderedLong(sequences, sequenceOffset, attemptedHead + mask);
                return (E)e;
            }
            ThreadHints.onSpinWait();
        }
        return null;
    }

    @Override
    public E peek() {
        long[] sequences = this.sequences;
        Object[] buffer = this.buffer;
        long mask = this.capacity - 1;
        long attemptedHead;
        long currentHead;
        long sequenceOffset;
        long sequence;
        while ((sequence = UnsafeAccess.UNSAFE.getLongVolatile(sequences, sequenceOffset = ManyToManyConcurrentArrayQueue.sequenceArrayOffset(currentHead = this.head, mask))) >= (attemptedHead = currentHead + 1L)) {
            if (sequence == attemptedHead) {
                long elementOffset = ManyToManyConcurrentArrayQueue.sequenceToBufferOffset(currentHead, mask);
                Object e = UnsafeAccess.UNSAFE.getObject(buffer, elementOffset);
                if (currentHead == this.head) {
                    return (E)e;
                }
            }
            ThreadHints.onSpinWait();
        }
        return null;
    }

    @Override
    public int drain(Consumer<E> elementConsumer) {
        return this.drain(elementConsumer, this.size());
    }

    @Override
    public int drain(Consumer<E> elementConsumer, int limit) {
        E e;
        int count;
        for (count = 0; count < limit && null != (e = this.poll()); ++count) {
            elementConsumer.accept(e);
        }
        return count;
    }

    @Override
    public int drainTo(Collection<? super E> target, int limit) {
        E e;
        int count;
        for (count = 0; count < limit && null != (e = this.poll()); ++count) {
            target.add(e);
        }
        return count;
    }

    private static long sequenceArrayOffset(long sequence, long mask) {
        return (long)SEQUENCES_ARRAY_BASE + ((sequence & mask) << 3);
    }
}

