/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.com.squareup.okhttp.internal.http;

import java.io.IOException;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.hbase.shaded.com.squareup.okhttp.Authenticator;
import org.apache.hadoop.hbase.shaded.com.squareup.okhttp.Challenge;
import org.apache.hadoop.hbase.shaded.com.squareup.okhttp.Headers;
import org.apache.hadoop.hbase.shaded.com.squareup.okhttp.Request;
import org.apache.hadoop.hbase.shaded.com.squareup.okhttp.Response;
import org.apache.hadoop.hbase.shaded.com.squareup.okhttp.internal.Platform;
import org.apache.hadoop.hbase.shaded.com.squareup.okhttp.internal.Util;
import org.apache.hadoop.hbase.shaded.com.squareup.okhttp.internal.http.HeaderParser;

public final class OkHeaders {
    private static final Comparator<String> FIELD_NAME_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String a, String b) {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(a, b);
        }
    };
    static final String PREFIX = Platform.get().getPrefix();
    public static final String SENT_MILLIS = PREFIX + "-Sent-Millis";
    public static final String RECEIVED_MILLIS = PREFIX + "-Received-Millis";
    public static final String SELECTED_PROTOCOL = PREFIX + "-Selected-Protocol";
    public static final String RESPONSE_SOURCE = PREFIX + "-Response-Source";

    private OkHeaders() {
    }

    public static long contentLength(Request request) {
        return OkHeaders.contentLength(request.headers());
    }

    public static long contentLength(Response response) {
        return OkHeaders.contentLength(response.headers());
    }

    public static long contentLength(Headers headers) {
        return OkHeaders.stringToLong(headers.get("Content-Length"));
    }

    private static long stringToLong(String s2) {
        if (s2 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(s2);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static Map<String, List<String>> toMultimap(Headers headers, String valueForNullKey) {
        TreeMap result = new TreeMap(FIELD_NAME_COMPARATOR);
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            String fieldName = headers.name(i);
            String value = headers.value(i);
            ArrayList<String> allValues = new ArrayList<String>();
            List otherValues = (List)result.get(fieldName);
            if (otherValues != null) {
                allValues.addAll(otherValues);
            }
            allValues.add(value);
            result.put(fieldName, Collections.unmodifiableList(allValues));
        }
        if (valueForNullKey != null) {
            result.put(null, Collections.unmodifiableList(Collections.singletonList(valueForNullKey)));
        }
        return Collections.unmodifiableMap(result);
    }

    public static void addCookies(Request.Builder builder, Map<String, List<String>> cookieHeaders) {
        for (Map.Entry<String, List<String>> entry : cookieHeaders.entrySet()) {
            String key = entry.getKey();
            if (!"Cookie".equalsIgnoreCase(key) && !"Cookie2".equalsIgnoreCase(key) || entry.getValue().isEmpty()) continue;
            builder.addHeader(key, OkHeaders.buildCookieHeader(entry.getValue()));
        }
    }

    private static String buildCookieHeader(List<String> cookies) {
        if (cookies.size() == 1) {
            return cookies.get(0);
        }
        StringBuilder sb = new StringBuilder();
        int size = cookies.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append("; ");
            }
            sb.append(cookies.get(i));
        }
        return sb.toString();
    }

    public static boolean varyMatches(Response cachedResponse, Headers cachedRequest, Request newRequest) {
        for (String field : OkHeaders.varyFields(cachedResponse)) {
            if (Util.equal(cachedRequest.values(field), newRequest.headers(field))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasVaryAll(Response response) {
        return OkHeaders.hasVaryAll(response.headers());
    }

    public static boolean hasVaryAll(Headers responseHeaders) {
        return OkHeaders.varyFields(responseHeaders).contains("*");
    }

    private static Set<String> varyFields(Response response) {
        return OkHeaders.varyFields(response.headers());
    }

    public static Set<String> varyFields(Headers responseHeaders) {
        Set<String> result = Collections.emptySet();
        int size = responseHeaders.size();
        for (int i = 0; i < size; ++i) {
            if (!"Vary".equalsIgnoreCase(responseHeaders.name(i))) continue;
            String value = responseHeaders.value(i);
            if (result.isEmpty()) {
                result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            }
            for (String varyField : value.split(",")) {
                result.add(varyField.trim());
            }
        }
        return result;
    }

    public static Headers varyHeaders(Response response) {
        Headers requestHeaders = response.networkResponse().request().headers();
        Headers responseHeaders = response.headers();
        return OkHeaders.varyHeaders(requestHeaders, responseHeaders);
    }

    public static Headers varyHeaders(Headers requestHeaders, Headers responseHeaders) {
        Set<String> varyFields = OkHeaders.varyFields(responseHeaders);
        if (varyFields.isEmpty()) {
            return new Headers.Builder().build();
        }
        Headers.Builder result = new Headers.Builder();
        int size = requestHeaders.size();
        for (int i = 0; i < size; ++i) {
            String fieldName = requestHeaders.name(i);
            if (!varyFields.contains(fieldName)) continue;
            result.add(fieldName, requestHeaders.value(i));
        }
        return result.build();
    }

    static boolean isEndToEnd(String fieldName) {
        return !"Connection".equalsIgnoreCase(fieldName) && !"Keep-Alive".equalsIgnoreCase(fieldName) && !"Proxy-Authenticate".equalsIgnoreCase(fieldName) && !"Proxy-Authorization".equalsIgnoreCase(fieldName) && !"TE".equalsIgnoreCase(fieldName) && !"Trailers".equalsIgnoreCase(fieldName) && !"Transfer-Encoding".equalsIgnoreCase(fieldName) && !"Upgrade".equalsIgnoreCase(fieldName);
    }

    public static List<Challenge> parseChallenges(Headers responseHeaders, String challengeHeader) {
        ArrayList<Challenge> result = new ArrayList<Challenge>();
        int size = responseHeaders.size();
        block0: for (int i = 0; i < size; ++i) {
            if (!challengeHeader.equalsIgnoreCase(responseHeaders.name(i))) continue;
            String value = responseHeaders.value(i);
            int pos = 0;
            while (pos < value.length()) {
                int tokenStart = pos;
                pos = HeaderParser.skipUntil(value, pos, " ");
                String scheme = value.substring(tokenStart, pos).trim();
                if (!value.regionMatches(true, pos = HeaderParser.skipWhitespace(value, pos), "realm=\"", 0, "realm=\"".length())) continue block0;
                int realmStart = pos += "realm=\"".length();
                pos = HeaderParser.skipUntil(value, pos, "\"");
                String realm = value.substring(realmStart, pos);
                ++pos;
                pos = HeaderParser.skipUntil(value, pos, ",");
                ++pos;
                pos = HeaderParser.skipWhitespace(value, pos);
                result.add(new Challenge(scheme, realm));
            }
        }
        return result;
    }

    public static Request processAuthHeader(Authenticator authenticator, Response response, Proxy proxy) throws IOException {
        return response.code() == 407 ? authenticator.authenticateProxy(proxy, response) : authenticator.authenticate(proxy, response);
    }
}

