/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.storefiletracker;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.regionserver.StoreContext;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerBase;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class MigrationStoreFileTracker
extends StoreFileTrackerBase {
    public static final String SRC_IMPL = "hbase.store.file-tracker.migration.src.impl";
    public static final String DST_IMPL = "hbase.store.file-tracker.migration.dst.impl";
    private final StoreFileTrackerBase src;
    private final StoreFileTrackerBase dst;

    public MigrationStoreFileTracker(Configuration conf, boolean isPrimaryReplica, StoreContext ctx) {
        super(conf, isPrimaryReplica, ctx);
        this.src = StoreFileTrackerFactory.createForMigration(conf, SRC_IMPL, isPrimaryReplica, ctx);
        this.dst = StoreFileTrackerFactory.createForMigration(conf, DST_IMPL, isPrimaryReplica, ctx);
        Preconditions.checkArgument(!this.src.getClass().equals(this.dst.getClass()), "src and dst is the same: %s", this.src.getClass());
    }

    @Override
    public List<StoreFileInfo> load() throws IOException {
        List<StoreFileInfo> files = this.src.load();
        this.dst.set(files);
        return files;
    }

    @Override
    public boolean requireWritingToTmpDirFirst() {
        return this.src.requireWritingToTmpDirFirst() || this.dst.requireWritingToTmpDirFirst();
    }

    @Override
    protected void doAddNewStoreFiles(Collection<StoreFileInfo> newFiles) throws IOException {
        this.src.doAddNewStoreFiles(newFiles);
        this.dst.doAddNewStoreFiles(newFiles);
    }

    @Override
    protected void doAddCompactionResults(Collection<StoreFileInfo> compactedFiles, Collection<StoreFileInfo> newFiles) throws IOException {
        this.src.doAddCompactionResults(compactedFiles, newFiles);
        this.dst.doAddCompactionResults(compactedFiles, newFiles);
    }

    @Override
    public void set(List<StoreFileInfo> files) {
        throw new UnsupportedOperationException("Should not call this method on " + this.getClass().getSimpleName());
    }

    static Class<? extends StoreFileTracker> getSrcTrackerClass(Configuration conf) {
        return StoreFileTrackerFactory.getStoreFileTrackerClassForMigration(conf, SRC_IMPL);
    }

    static Class<? extends StoreFileTracker> getDstTrackerClass(Configuration conf) {
        return StoreFileTrackerFactory.getStoreFileTrackerClassForMigration(conf, DST_IMPL);
    }
}

