/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.nio.RefCnt;
import org.apache.hadoop.hbase.regionserver.Chunk;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.shaded.com.google.errorprone.annotations.RestrictedApi;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ImmutableMemStoreLAB
implements MemStoreLAB {
    private final RefCnt refCnt;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final List<MemStoreLAB> mslabs;

    public ImmutableMemStoreLAB(List<MemStoreLAB> mslabs) {
        this.mslabs = mslabs;
        this.refCnt = RefCnt.create(() -> this.closeMSLABs());
    }

    @Override
    public Cell copyCellInto(Cell cell) {
        throw new IllegalStateException("This is an Immutable MemStoreLAB.");
    }

    @Override
    public Cell forceCopyOfBigCellInto(Cell cell) {
        MemStoreLAB mslab = this.mslabs.get(0);
        return mslab.forceCopyOfBigCellInto(cell);
    }

    @Override
    public Chunk getNewExternalChunk(ChunkCreator.ChunkType chunkType) {
        MemStoreLAB mslab = this.mslabs.get(0);
        return mslab.getNewExternalChunk(chunkType);
    }

    @Override
    public Chunk getNewExternalChunk(int size) {
        MemStoreLAB mslab = this.mslabs.get(0);
        return mslab.getNewExternalChunk(size);
    }

    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.refCnt.release();
    }

    private void closeMSLABs() {
        for (MemStoreLAB mslab : this.mslabs) {
            mslab.close();
        }
    }

    @Override
    public void incScannerCount() {
        this.refCnt.retain();
    }

    @Override
    public void decScannerCount() {
        this.refCnt.release();
    }

    @Override
    public boolean isOnHeap() {
        return !this.isOffHeap();
    }

    @Override
    public boolean isOffHeap() {
        return ChunkCreator.getInstance().isOffheap();
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    int getRefCntValue() {
        return this.refCnt.refCnt();
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    boolean isClosed() {
        return this.closed.get();
    }
}

