/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas.policies;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.quotas.SpaceLimitingException;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicyEnforcement;
import org.apache.hadoop.hbase.quotas.policies.AbstractViolationPolicyEnforcement;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class MissingSnapshotViolationPolicyEnforcement
extends AbstractViolationPolicyEnforcement {
    private static final MissingSnapshotViolationPolicyEnforcement SINGLETON = new MissingSnapshotViolationPolicyEnforcement();

    private MissingSnapshotViolationPolicyEnforcement() {
    }

    @SuppressWarnings(value={"MS_EXPOSE_REP"}, justification="singleton pattern")
    public static SpaceViolationPolicyEnforcement getInstance() {
        return SINGLETON;
    }

    @Override
    public boolean shouldCheckBulkLoads() {
        return false;
    }

    @Override
    public long computeBulkLoadSize(FileSystem fs, List<String> paths) throws SpaceLimitingException {
        long size = 0L;
        for (String path : paths) {
            size += this.getFileSize(fs, path);
        }
        return size;
    }

    @Override
    public void enable() throws IOException {
    }

    @Override
    public void disable() throws IOException {
    }

    @Override
    public void check(Mutation m3) throws SpaceLimitingException {
    }

    @Override
    public String getPolicyName() {
        return "NoQuota";
    }
}

