/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.master.balancer.BalancerClusterState;
import org.apache.hadoop.hbase.master.balancer.CostFunction;
import org.apache.hadoop.hbase.regionserver.compactions.OffPeakHours;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class MoveCostFunction
extends CostFunction {
    private static final String MOVE_COST_KEY = "hbase.master.balancer.stochastic.moveCost";
    private static final String MOVE_COST_OFFPEAK_KEY = "hbase.master.balancer.stochastic.moveCost.offpeak";
    private static final String MAX_MOVES_PERCENT_KEY = "hbase.master.balancer.stochastic.maxMovePercent";
    static final float DEFAULT_MOVE_COST = 7.0f;
    static final float DEFAULT_MOVE_COST_OFFPEAK = 3.0f;
    private static final int DEFAULT_MAX_MOVES = 600;
    private static final float DEFAULT_MAX_MOVE_PERCENT = 1.0f;
    private final float maxMovesPercent;
    private final OffPeakHours offPeakHours;
    private final float moveCost;
    private final float moveCostOffPeak;

    MoveCostFunction(Configuration conf) {
        this.maxMovesPercent = conf.getFloat(MAX_MOVES_PERCENT_KEY, 1.0f);
        this.offPeakHours = OffPeakHours.getInstance(conf);
        this.moveCost = conf.getFloat(MOVE_COST_KEY, 7.0f);
        this.moveCostOffPeak = conf.getFloat(MOVE_COST_OFFPEAK_KEY, 3.0f);
        this.setMultiplier(this.moveCost);
    }

    @Override
    void prepare(BalancerClusterState cluster) {
        super.prepare(cluster);
        if (this.offPeakHours.isOffPeakHour()) {
            this.setMultiplier(this.moveCostOffPeak);
        } else {
            this.setMultiplier(this.moveCost);
        }
    }

    @Override
    protected double cost() {
        double moveCost = this.cluster.numMovedRegions;
        int maxMoves = Math.max((int)((float)this.cluster.numRegions * this.maxMovesPercent), 600);
        if (moveCost > (double)maxMoves) {
            return 1000000.0;
        }
        return MoveCostFunction.scale(0.0, Math.min(this.cluster.numRegions, maxMoves), moveCost);
    }
}

