/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ClusterMetricsBuilder;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerMetricsBuilder;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.NormalizeTableFilterParams;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.client.VersionInfoUtil;
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.exceptions.UnknownProtocolException;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.QosPriority;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerFactory;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterAnnotationReadingPriorityFunction;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterWalManager;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.cleaner.HFileCleaner;
import org.apache.hadoop.hbase.master.hbck.HbckChore;
import org.apache.hadoop.hbase.master.janitor.MetaFixer;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.namequeues.NamedQueueRecorder;
import org.apache.hadoop.hbase.namequeues.request.NamedQueueGetRequest;
import org.apache.hadoop.hbase.namequeues.response.NamedQueueGetResponse;
import org.apache.hadoop.hbase.procedure.MasterProcedureManager;
import org.apache.hadoop.hbase.procedure2.LockType;
import org.apache.hadoop.hbase.procedure2.LockedResource;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureException;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.quotas.QuotaObserverChore;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.regionserver.RpcSchedulerFactory;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.security.Superusers;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessChecker;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.PermissionStorage;
import org.apache.hadoop.hbase.security.access.ShadedAccessControlUtil;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.security.visibility.VisibilityController;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Descriptors;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Service;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.LockServiceProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegistryProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ForeignExceptionUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MasterRpcServices
extends RSRpcServices
implements MasterProtos.MasterService.BlockingInterface,
RegionServerStatusProtos.RegionServerStatusService.BlockingInterface,
LockServiceProtos.LockService.BlockingInterface,
MasterProtos.HbckService.BlockingInterface {
    private static final Logger LOG = LoggerFactory.getLogger((String)MasterRpcServices.class.getName());
    private static final Logger AUDITLOG = LoggerFactory.getLogger((String)("SecurityLogger." + MasterRpcServices.class.getName()));
    private final HMaster master;

    private RegionServerStatusProtos.RegionServerStartupResponse.Builder createConfigurationSubset() {
        RegionServerStatusProtos.RegionServerStartupResponse.Builder resp = this.addConfig(RegionServerStatusProtos.RegionServerStartupResponse.newBuilder(), "hbase.rootdir");
        resp = this.addConfig(resp, "fs.defaultFS");
        return this.addConfig(resp, "hbase.master.info.port");
    }

    private RegionServerStatusProtos.RegionServerStartupResponse.Builder addConfig(RegionServerStatusProtos.RegionServerStartupResponse.Builder resp, String key) {
        HBaseProtos.NameStringPair.Builder entry = HBaseProtos.NameStringPair.newBuilder().setName(key).setValue(this.master.getConfiguration().get(key));
        resp.addMapEntries(entry.build());
        return resp;
    }

    public MasterRpcServices(HMaster m3) throws IOException {
        super(m3);
        this.master = m3;
    }

    @Override
    protected Class<?> getRpcSchedulerFactoryClass() {
        Configuration conf = this.getConfiguration();
        if (conf != null) {
            return conf.getClass("hbase.master.rpc.scheduler.factory.class", super.getRpcSchedulerFactoryClass());
        }
        return super.getRpcSchedulerFactoryClass();
    }

    @Override
    protected RpcServerInterface createRpcServer(Server server, RpcSchedulerFactory rpcSchedulerFactory, InetSocketAddress bindAddress, String name) throws IOException {
        Configuration conf = this.regionServer.getConfiguration();
        boolean reservoirEnabled = conf.getBoolean("hbase.server.allocator.pool.enabled", LoadBalancer.isMasterCanHostUserRegions(conf));
        try {
            return RpcServerFactory.createRpcServer(server, name, this.getServices(), bindAddress, conf, rpcSchedulerFactory.create(conf, this, server), reservoirEnabled);
        }
        catch (BindException be) {
            throw new IOException(be.getMessage() + ". To switch ports use the '" + "hbase.master.port" + "' configuration property.", be.getCause() != null ? be.getCause() : be);
        }
    }

    @Override
    protected PriorityFunction createPriority() {
        return new MasterAnnotationReadingPriorityFunction(this);
    }

    private void rpcPreCheck(String requestName) throws ServiceException {
        try {
            this.master.checkInitialized();
            this.requirePermission(requestName, Permission.Action.ADMIN);
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean switchBalancer(boolean b, BalanceSwitchMode mode) throws IOException {
        boolean oldValue = this.master.loadBalancerTracker.isBalancerOn();
        boolean newValue = b;
        try {
            block10: {
                if (this.master.cpHost != null) {
                    this.master.cpHost.preBalanceSwitch(newValue);
                }
                try {
                    if (mode == BalanceSwitchMode.SYNC) {
                        LoadBalancer loadBalancer = this.master.getLoadBalancer();
                        synchronized (loadBalancer) {
                            this.master.loadBalancerTracker.setBalancerOn(newValue);
                            break block10;
                        }
                    }
                    this.master.loadBalancerTracker.setBalancerOn(newValue);
                }
                catch (KeeperException ke) {
                    throw new IOException(ke);
                }
            }
            LOG.info(this.master.getClientIdAuditPrefix() + " set balanceSwitch=" + newValue);
            if (this.master.cpHost != null) {
                this.master.cpHost.postBalanceSwitch(oldValue, newValue);
            }
            this.master.getLoadBalancer().updateBalancerStatus(newValue);
        }
        catch (IOException ioe) {
            LOG.warn("Error flipping balance switch", (Throwable)ioe);
        }
        return oldValue;
    }

    boolean synchronousBalanceSwitch(boolean b) throws IOException {
        return this.switchBalancer(b, BalanceSwitchMode.SYNC);
    }

    @Override
    protected List<RpcServer.BlockingServiceAndInterface> getServices() {
        ArrayList<RpcServer.BlockingServiceAndInterface> bssi = new ArrayList<RpcServer.BlockingServiceAndInterface>(5);
        bssi.add(new RpcServer.BlockingServiceAndInterface(MasterProtos.MasterService.newReflectiveBlockingService(this), MasterProtos.MasterService.BlockingInterface.class));
        bssi.add(new RpcServer.BlockingServiceAndInterface(RegionServerStatusProtos.RegionServerStatusService.newReflectiveBlockingService(this), RegionServerStatusProtos.RegionServerStatusService.BlockingInterface.class));
        bssi.add(new RpcServer.BlockingServiceAndInterface(LockServiceProtos.LockService.newReflectiveBlockingService(this), LockServiceProtos.LockService.BlockingInterface.class));
        bssi.add(new RpcServer.BlockingServiceAndInterface(MasterProtos.HbckService.newReflectiveBlockingService(this), MasterProtos.HbckService.BlockingInterface.class));
        bssi.add(new RpcServer.BlockingServiceAndInterface(RegistryProtos.ClientMetaService.newReflectiveBlockingService(this), RegistryProtos.ClientMetaService.BlockingInterface.class));
        bssi.addAll(super.getServices());
        return bssi;
    }

    @Override
    @QosPriority(priority=100)
    public RegionServerStatusProtos.GetLastFlushedSequenceIdResponse getLastFlushedSequenceId(RpcController controller, RegionServerStatusProtos.GetLastFlushedSequenceIdRequest request) throws ServiceException {
        try {
            this.master.checkServiceStarted();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
        byte[] encodedRegionName = request.getRegionName().toByteArray();
        ClusterStatusProtos.RegionStoreSequenceIds ids = this.master.getServerManager().getLastFlushedSequenceId(encodedRegionName);
        return ResponseConverter.buildGetLastFlushedSequenceIdResponse(ids);
    }

    @Override
    public RegionServerStatusProtos.RegionServerReportResponse regionServerReport(RpcController controller, RegionServerStatusProtos.RegionServerReportRequest request) throws ServiceException {
        try {
            this.master.checkServiceStarted();
            int versionNumber = 0;
            String version = "0.0.0";
            HBaseProtos.VersionInfo versionInfo = VersionInfoUtil.getCurrentClientVersionInfo();
            if (versionInfo != null) {
                version = versionInfo.getVersion();
                versionNumber = VersionInfoUtil.getVersionNumber(versionInfo);
            }
            ClusterStatusProtos.ServerLoad sl = request.getLoad();
            ServerName serverName = ProtobufUtil.toServerName(request.getServer());
            ServerMetrics oldLoad = this.master.getServerManager().getLoad(serverName);
            ServerMetrics newLoad = ServerMetricsBuilder.toServerMetrics(serverName, versionNumber, version, sl);
            this.master.getServerManager().regionServerReport(serverName, newLoad);
            this.master.getAssignmentManager().reportOnlineRegions(serverName, newLoad.getRegionMetrics().keySet());
            if (sl != null && this.master.metricsMaster != null) {
                this.master.metricsMaster.incrementRequests(sl.getTotalNumberOfRequests() - (oldLoad != null ? oldLoad.getRequestCount() : 0L));
            }
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
        return RegionServerStatusProtos.RegionServerReportResponse.newBuilder().build();
    }

    @Override
    public RegionServerStatusProtos.RegionServerStartupResponse regionServerStartup(RpcController controller, RegionServerStatusProtos.RegionServerStartupRequest request) throws ServiceException {
        try {
            this.master.checkServiceStarted();
            int versionNumber = 0;
            String version = "0.0.0";
            HBaseProtos.VersionInfo versionInfo = VersionInfoUtil.getCurrentClientVersionInfo();
            if (versionInfo != null) {
                version = versionInfo.getVersion();
                versionNumber = VersionInfoUtil.getVersionNumber(versionInfo);
            }
            InetAddress ia = this.master.getRemoteInetAddress(request.getPort(), request.getServerStartCode());
            ServerName rs = this.master.getServerManager().regionServerStartup(request, versionNumber, version, ia);
            RegionServerStatusProtos.RegionServerStartupResponse.Builder resp = this.createConfigurationSubset();
            HBaseProtos.NameStringPair.Builder entry = HBaseProtos.NameStringPair.newBuilder().setName("hbase.regionserver.hostname.seen.by.master").setValue(rs.getHostname());
            resp.addMapEntries(entry.build());
            return resp.build();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public RegionServerStatusProtos.ReportRSFatalErrorResponse reportRSFatalError(RpcController controller, RegionServerStatusProtos.ReportRSFatalErrorRequest request) throws ServiceException {
        String errorText = request.getErrorMessage();
        ServerName sn = ProtobufUtil.toServerName(request.getServer());
        String msg = sn + " reported a fatal error:\n" + errorText;
        LOG.warn(msg);
        this.master.rsFatals.add(msg);
        return RegionServerStatusProtos.ReportRSFatalErrorResponse.newBuilder().build();
    }

    @Override
    public MasterProtos.AddColumnResponse addColumn(RpcController controller, MasterProtos.AddColumnRequest req) throws ServiceException {
        try {
            long procId = this.master.addColumn(ProtobufUtil.toTableName(req.getTableName()), ProtobufUtil.toColumnFamilyDescriptor(req.getColumnFamilies()), req.getNonceGroup(), req.getNonce());
            if (procId == -1L) {
                return MasterProtos.AddColumnResponse.newBuilder().build();
            }
            return MasterProtos.AddColumnResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public MasterProtos.AssignRegionResponse assignRegion(RpcController controller, MasterProtos.AssignRegionRequest req) throws ServiceException {
        try {
            this.master.checkInitialized();
            HBaseProtos.RegionSpecifier.RegionSpecifierType type = req.getRegion().getType();
            if (type != HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME) {
                LOG.warn("assignRegion specifier type: expected: " + HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME + " actual: " + type);
            }
            byte[] regionName = req.getRegion().getValue().toByteArray();
            RegionInfo regionInfo = this.master.getAssignmentManager().getRegionInfo(regionName);
            if (regionInfo == null) {
                throw new UnknownRegionException(Bytes.toStringBinary(regionName));
            }
            MasterProtos.AssignRegionResponse arr = MasterProtos.AssignRegionResponse.newBuilder().build();
            if (this.master.cpHost != null) {
                this.master.cpHost.preAssign(regionInfo);
            }
            LOG.info(this.master.getClientIdAuditPrefix() + " assign " + regionInfo.getRegionNameAsString());
            this.master.getAssignmentManager().assign(regionInfo);
            if (this.master.cpHost != null) {
                this.master.cpHost.postAssign(regionInfo);
            }
            return arr;
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public MasterProtos.BalanceResponse balance(RpcController controller, MasterProtos.BalanceRequest request) throws ServiceException {
        try {
            return ProtobufUtil.toBalanceResponse(this.master.balance(ProtobufUtil.toBalanceRequest(request)));
        }
        catch (IOException ex) {
            throw new ServiceException(ex);
        }
    }

    @Override
    public MasterProtos.CreateNamespaceResponse createNamespace(RpcController controller, MasterProtos.CreateNamespaceRequest request) throws ServiceException {
        try {
            long procId = this.master.createNamespace(ProtobufUtil.toNamespaceDescriptor(request.getNamespaceDescriptor()), request.getNonceGroup(), request.getNonce());
            return MasterProtos.CreateNamespaceResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.CreateTableResponse createTable(RpcController controller, MasterProtos.CreateTableRequest req) throws ServiceException {
        TableDescriptor tableDescriptor = ProtobufUtil.toTableDescriptor(req.getTableSchema());
        byte[][] splitKeys = ProtobufUtil.getSplitKeysArray(req);
        try {
            long procId = this.master.createTable(tableDescriptor, splitKeys, req.getNonceGroup(), req.getNonce());
            LOG.info(this.master.getClientIdAuditPrefix() + " procedure request for creating table: " + req.getTableSchema().getTableName() + " procId is: " + procId);
            return MasterProtos.CreateTableResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public MasterProtos.DeleteColumnResponse deleteColumn(RpcController controller, MasterProtos.DeleteColumnRequest req) throws ServiceException {
        try {
            long procId = this.master.deleteColumn(ProtobufUtil.toTableName(req.getTableName()), req.getColumnName().toByteArray(), req.getNonceGroup(), req.getNonce());
            if (procId == -1L) {
                return MasterProtos.DeleteColumnResponse.newBuilder().build();
            }
            return MasterProtos.DeleteColumnResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public MasterProtos.DeleteNamespaceResponse deleteNamespace(RpcController controller, MasterProtos.DeleteNamespaceRequest request) throws ServiceException {
        try {
            long procId = this.master.deleteNamespace(request.getNamespaceName(), request.getNonceGroup(), request.getNonce());
            return MasterProtos.DeleteNamespaceResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.DeleteSnapshotResponse deleteSnapshot(RpcController controller, MasterProtos.DeleteSnapshotRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            this.master.snapshotManager.checkSnapshotSupport();
            LOG.info(this.master.getClientIdAuditPrefix() + " delete " + request.getSnapshot());
            this.master.snapshotManager.deleteSnapshot(request.getSnapshot());
            return MasterProtos.DeleteSnapshotResponse.newBuilder().build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.DeleteTableResponse deleteTable(RpcController controller, MasterProtos.DeleteTableRequest request) throws ServiceException {
        try {
            long procId = this.master.deleteTable(ProtobufUtil.toTableName(request.getTableName()), request.getNonceGroup(), request.getNonce());
            return MasterProtos.DeleteTableResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public MasterProtos.TruncateTableResponse truncateTable(RpcController controller, MasterProtos.TruncateTableRequest request) throws ServiceException {
        try {
            long procId = this.master.truncateTable(ProtobufUtil.toTableName(request.getTableName()), request.getPreserveSplits(), request.getNonceGroup(), request.getNonce());
            return MasterProtos.TruncateTableResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public MasterProtos.DisableTableResponse disableTable(RpcController controller, MasterProtos.DisableTableRequest request) throws ServiceException {
        try {
            long procId = this.master.disableTable(ProtobufUtil.toTableName(request.getTableName()), request.getNonceGroup(), request.getNonce());
            return MasterProtos.DisableTableResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public MasterProtos.EnableCatalogJanitorResponse enableCatalogJanitor(RpcController c, MasterProtos.EnableCatalogJanitorRequest req) throws ServiceException {
        this.rpcPreCheck("enableCatalogJanitor");
        return MasterProtos.EnableCatalogJanitorResponse.newBuilder().setPrevValue(this.master.catalogJanitorChore.setEnabled(req.getEnable())).build();
    }

    @Override
    public MasterProtos.SetCleanerChoreRunningResponse setCleanerChoreRunning(RpcController c, MasterProtos.SetCleanerChoreRunningRequest req) throws ServiceException {
        this.rpcPreCheck("setCleanerChoreRunning");
        boolean prevValue = this.master.getLogCleaner().getEnabled() && this.master.getHFileCleaner().getEnabled();
        this.master.getLogCleaner().setEnabled(req.getOn());
        for (HFileCleaner hFileCleaner : this.master.getHFileCleaners()) {
            hFileCleaner.setEnabled(req.getOn());
        }
        return MasterProtos.SetCleanerChoreRunningResponse.newBuilder().setPrevValue(prevValue).build();
    }

    @Override
    public MasterProtos.EnableTableResponse enableTable(RpcController controller, MasterProtos.EnableTableRequest request) throws ServiceException {
        try {
            long procId = this.master.enableTable(ProtobufUtil.toTableName(request.getTableName()), request.getNonceGroup(), request.getNonce());
            return MasterProtos.EnableTableResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public MasterProtos.MergeTableRegionsResponse mergeTableRegions(RpcController c, MasterProtos.MergeTableRegionsRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
        RegionStates regionStates = this.master.getAssignmentManager().getRegionStates();
        RegionInfo[] regionsToMerge = new RegionInfo[request.getRegionCount()];
        for (int i = 0; i < request.getRegionCount(); ++i) {
            RegionState regionState;
            byte[] encodedNameOfRegion = request.getRegion(i).getValue().toByteArray();
            if (request.getRegion(i).getType() != HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME) {
                LOG.warn("MergeRegions specifier type: expected: " + HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME + " actual: region " + i + " =" + request.getRegion(i).getType());
            }
            if ((regionState = regionStates.getRegionState(Bytes.toString(encodedNameOfRegion))) == null) {
                throw new ServiceException(new UnknownRegionException(Bytes.toStringBinary(encodedNameOfRegion)));
            }
            regionsToMerge[i] = regionState.getRegion();
        }
        try {
            long procId = this.master.mergeRegions(regionsToMerge, request.getForcible(), request.getNonceGroup(), request.getNonce());
            return MasterProtos.MergeTableRegionsResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public MasterProtos.SplitTableRegionResponse splitRegion(RpcController controller, MasterProtos.SplitTableRegionRequest request) throws ServiceException {
        try {
            long procId = this.master.splitRegion(ProtobufUtil.toRegionInfo(request.getRegionInfo()), request.hasSplitRow() ? request.getSplitRow().toByteArray() : null, request.getNonceGroup(), request.getNonce());
            return MasterProtos.SplitTableRegionResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ie) {
            throw new ServiceException(ie);
        }
    }

    @Override
    public ClientProtos.CoprocessorServiceResponse execMasterService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
        this.rpcPreCheck("execMasterService");
        try {
            ServerRpcController execController = new ServerRpcController();
            ClientProtos.CoprocessorServiceCall call = request.getCall();
            String serviceName = call.getServiceName();
            String methodName = call.getMethodName();
            if (!this.master.coprocessorServiceHandlers.containsKey(serviceName)) {
                throw new UnknownProtocolException(null, "No registered Master Coprocessor Endpoint found for " + serviceName + ". Has it been enabled?");
            }
            Service service = this.master.coprocessorServiceHandlers.get(serviceName);
            Descriptors.ServiceDescriptor serviceDesc = service.getDescriptorForType();
            Descriptors.MethodDescriptor methodDesc = CoprocessorRpcUtils.getMethodDescriptor(methodName, serviceDesc);
            Message execRequest = CoprocessorRpcUtils.getRequest(service, methodDesc, call.getRequest());
            Message.Builder responseBuilder = service.getResponsePrototype(methodDesc).newBuilderForType();
            service.callMethod(methodDesc, execController, execRequest, message -> {
                if (message != null) {
                    responseBuilder.mergeFrom((Message)message);
                }
            });
            Message execResult = responseBuilder.build();
            if (execController.getFailedOn() != null) {
                throw execController.getFailedOn();
            }
            String remoteAddress = RpcServer.getRemoteAddress().map(InetAddress::toString).orElse("");
            User caller = RpcServer.getRequestUser().orElse(null);
            AUDITLOG.info("User {} (remote address: {}) master service request for {}.{}", new Object[]{caller, remoteAddress, serviceName, methodName});
            return CoprocessorRpcUtils.getResponse(execResult, HConstants.EMPTY_BYTE_ARRAY);
        }
        catch (IOException ie) {
            throw new ServiceException(ie);
        }
    }

    @Override
    public MasterProtos.ExecProcedureResponse execProcedure(RpcController controller, MasterProtos.ExecProcedureRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            HBaseProtos.ProcedureDescription desc = request.getProcedure();
            MasterProcedureManager mpm = this.master.getMasterProcedureManagerHost().getProcedureManager(desc.getSignature());
            if (mpm == null) {
                throw new ServiceException(new DoNotRetryIOException("The procedure is not registered: " + desc.getSignature()));
            }
            LOG.info(this.master.getClientIdAuditPrefix() + " procedure request for: " + desc.getSignature());
            mpm.checkPermissions(desc, this.getAccessChecker(), RpcServer.getRequestUser().orElse(null));
            mpm.execProcedure(desc);
            long waitTime = 300000L;
            return MasterProtos.ExecProcedureResponse.newBuilder().setExpectedTimeout(waitTime).build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.ExecProcedureResponse execProcedureWithRet(RpcController controller, MasterProtos.ExecProcedureRequest request) throws ServiceException {
        this.rpcPreCheck("execProcedureWithRet");
        try {
            HBaseProtos.ProcedureDescription desc = request.getProcedure();
            MasterProcedureManager mpm = this.master.getMasterProcedureManagerHost().getProcedureManager(desc.getSignature());
            if (mpm == null) {
                throw new ServiceException("The procedure is not registered: " + desc.getSignature());
            }
            LOG.info(this.master.getClientIdAuditPrefix() + " procedure request for: " + desc.getSignature());
            byte[] data = mpm.execProcedureWithRet(desc);
            MasterProtos.ExecProcedureResponse.Builder builder = MasterProtos.ExecProcedureResponse.newBuilder();
            if (data != null) {
                builder.setReturnData(UnsafeByteOperations.unsafeWrap(data));
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.GetClusterStatusResponse getClusterStatus(RpcController controller, MasterProtos.GetClusterStatusRequest req) throws ServiceException {
        MasterProtos.GetClusterStatusResponse.Builder response = MasterProtos.GetClusterStatusResponse.newBuilder();
        try {
            response.setClusterStatus(ClusterMetricsBuilder.toClusterStatus(this.master.getClusterMetrics(ClusterMetricsBuilder.toOptions(req.getOptionsList()))));
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return response.build();
    }

    @Override
    public MasterProtos.GetCompletedSnapshotsResponse getCompletedSnapshots(RpcController controller, MasterProtos.GetCompletedSnapshotsRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            MasterProtos.GetCompletedSnapshotsResponse.Builder builder = MasterProtos.GetCompletedSnapshotsResponse.newBuilder();
            List<SnapshotProtos.SnapshotDescription> snapshots = this.master.snapshotManager.getCompletedSnapshots();
            for (SnapshotProtos.SnapshotDescription snapshot : snapshots) {
                builder.addSnapshots(snapshot);
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.ListNamespacesResponse listNamespaces(RpcController controller, MasterProtos.ListNamespacesRequest request) throws ServiceException {
        try {
            return MasterProtos.ListNamespacesResponse.newBuilder().addAllNamespaceName(this.master.listNamespaces()).build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.GetNamespaceDescriptorResponse getNamespaceDescriptor(RpcController controller, MasterProtos.GetNamespaceDescriptorRequest request) throws ServiceException {
        try {
            return MasterProtos.GetNamespaceDescriptorResponse.newBuilder().setNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor(this.master.getNamespace(request.getNamespaceName()))).build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.GetSchemaAlterStatusResponse getSchemaAlterStatus(RpcController controller, MasterProtos.GetSchemaAlterStatusRequest req) throws ServiceException {
        TableName tableName = ProtobufUtil.toTableName(req.getTableName());
        try {
            this.master.checkInitialized();
            Pair<Integer, Integer> pair = this.master.getAssignmentManager().getReopenStatus(tableName);
            MasterProtos.GetSchemaAlterStatusResponse.Builder ret = MasterProtos.GetSchemaAlterStatusResponse.newBuilder();
            ret.setYetToUpdateRegions(pair.getFirst());
            ret.setTotalRegions(pair.getSecond());
            return ret.build();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public MasterProtos.GetTableDescriptorsResponse getTableDescriptors(RpcController c, MasterProtos.GetTableDescriptorsRequest req) throws ServiceException {
        try {
            this.master.checkInitialized();
            String regex = req.hasRegex() ? req.getRegex() : null;
            String namespace = req.hasNamespace() ? req.getNamespace() : null;
            ArrayList<TableName> tableNameList = null;
            if (req.getTableNamesCount() > 0) {
                tableNameList = new ArrayList<TableName>(req.getTableNamesCount());
                for (HBaseProtos.TableName tableNamePB : req.getTableNamesList()) {
                    tableNameList.add(ProtobufUtil.toTableName(tableNamePB));
                }
            }
            List<TableDescriptor> descriptors = this.master.listTableDescriptors(namespace, regex, tableNameList, req.getIncludeSysTables());
            MasterProtos.GetTableDescriptorsResponse.Builder builder = MasterProtos.GetTableDescriptorsResponse.newBuilder();
            if (descriptors != null && descriptors.size() > 0) {
                for (TableDescriptor htd : descriptors) {
                    builder.addTableSchema(ProtobufUtil.toTableSchema(htd));
                }
            }
            return builder.build();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public MasterProtos.GetTableNamesResponse getTableNames(RpcController controller, MasterProtos.GetTableNamesRequest req) throws ServiceException {
        try {
            this.master.checkServiceStarted();
            String regex = req.hasRegex() ? req.getRegex() : null;
            String namespace = req.hasNamespace() ? req.getNamespace() : null;
            List<TableName> tableNames = this.master.listTableNames(namespace, regex, req.getIncludeSysTables());
            MasterProtos.GetTableNamesResponse.Builder builder = MasterProtos.GetTableNamesResponse.newBuilder();
            if (tableNames != null && tableNames.size() > 0) {
                for (TableName table : tableNames) {
                    builder.addTableNames(ProtobufUtil.toProtoTableName(table));
                }
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.GetTableStateResponse getTableState(RpcController controller, MasterProtos.GetTableStateRequest request) throws ServiceException {
        try {
            this.master.checkServiceStarted();
            TableName tableName = ProtobufUtil.toTableName(request.getTableName());
            TableState ts = this.master.getTableStateManager().getTableState(tableName);
            MasterProtos.GetTableStateResponse.Builder builder = MasterProtos.GetTableStateResponse.newBuilder();
            builder.setTableState(ts.convert());
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.IsCatalogJanitorEnabledResponse isCatalogJanitorEnabled(RpcController c, MasterProtos.IsCatalogJanitorEnabledRequest req) throws ServiceException {
        return MasterProtos.IsCatalogJanitorEnabledResponse.newBuilder().setValue(this.master.isCatalogJanitorEnabled()).build();
    }

    @Override
    public MasterProtos.IsCleanerChoreEnabledResponse isCleanerChoreEnabled(RpcController c, MasterProtos.IsCleanerChoreEnabledRequest req) throws ServiceException {
        return MasterProtos.IsCleanerChoreEnabledResponse.newBuilder().setValue(this.master.isCleanerChoreEnabled()).build();
    }

    @Override
    public MasterProtos.IsMasterRunningResponse isMasterRunning(RpcController c, MasterProtos.IsMasterRunningRequest req) throws ServiceException {
        try {
            this.master.checkServiceStarted();
            return MasterProtos.IsMasterRunningResponse.newBuilder().setIsMasterRunning(!this.master.isStopped()).build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.IsProcedureDoneResponse isProcedureDone(RpcController controller, MasterProtos.IsProcedureDoneRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            HBaseProtos.ProcedureDescription desc = request.getProcedure();
            MasterProcedureManager mpm = this.master.getMasterProcedureManagerHost().getProcedureManager(desc.getSignature());
            if (mpm == null) {
                throw new ServiceException("The procedure is not registered: " + desc.getSignature());
            }
            LOG.debug("Checking to see if procedure from request:" + desc.getSignature() + " is done");
            MasterProtos.IsProcedureDoneResponse.Builder builder = MasterProtos.IsProcedureDoneResponse.newBuilder();
            boolean done = mpm.isProcedureDone(desc);
            builder.setDone(done);
            return builder.build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.IsSnapshotDoneResponse isSnapshotDone(RpcController controller, MasterProtos.IsSnapshotDoneRequest request) throws ServiceException {
        LOG.debug("Checking to see if snapshot from request:" + ClientSnapshotDescriptionUtils.toString(request.getSnapshot()) + " is done");
        try {
            this.master.checkInitialized();
            MasterProtos.IsSnapshotDoneResponse.Builder builder = MasterProtos.IsSnapshotDoneResponse.newBuilder();
            boolean done = this.master.snapshotManager.isSnapshotDone(request.getSnapshot());
            builder.setDone(done);
            return builder.build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.GetProcedureResultResponse getProcedureResult(RpcController controller, MasterProtos.GetProcedureResultRequest request) throws ServiceException {
        LOG.debug("Checking to see if procedure is done pid=" + request.getProcId());
        try {
            this.master.checkInitialized();
            MasterProtos.GetProcedureResultResponse.Builder builder = MasterProtos.GetProcedureResultResponse.newBuilder();
            long procId = request.getProcId();
            ProcedureExecutor<MasterProcedureEnv> executor = this.master.getMasterProcedureExecutor();
            Procedure<MasterProcedureEnv> result = executor.getResultOrProcedure(procId);
            if (result != null) {
                builder.setSubmittedTime(result.getSubmittedTime());
                builder.setLastUpdate(result.getLastUpdate());
                if (executor.isFinished(procId)) {
                    byte[] resultData;
                    builder.setState(MasterProtos.GetProcedureResultResponse.State.FINISHED);
                    if (result.isFailed()) {
                        IOException exception = MasterProcedureUtil.unwrapRemoteIOException(result);
                        builder.setException(ForeignExceptionUtil.toProtoForeignException(exception));
                    }
                    if ((resultData = result.getResult()) != null) {
                        builder.setResult(UnsafeByteOperations.unsafeWrap(resultData));
                    }
                    this.master.getMasterProcedureExecutor().removeResult(request.getProcId());
                } else {
                    builder.setState(MasterProtos.GetProcedureResultResponse.State.RUNNING);
                }
            } else {
                builder.setState(MasterProtos.GetProcedureResultResponse.State.NOT_FOUND);
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.AbortProcedureResponse abortProcedure(RpcController rpcController, MasterProtos.AbortProcedureRequest request) throws ServiceException {
        try {
            MasterProtos.AbortProcedureResponse.Builder response = MasterProtos.AbortProcedureResponse.newBuilder();
            boolean abortResult = this.master.abortProcedure(request.getProcId(), request.getMayInterruptIfRunning());
            response.setIsProcedureAborted(abortResult);
            return response.build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.ListNamespaceDescriptorsResponse listNamespaceDescriptors(RpcController c, MasterProtos.ListNamespaceDescriptorsRequest request) throws ServiceException {
        try {
            MasterProtos.ListNamespaceDescriptorsResponse.Builder response = MasterProtos.ListNamespaceDescriptorsResponse.newBuilder();
            for (NamespaceDescriptor ns : this.master.getNamespaces()) {
                response.addNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor(ns));
            }
            return response.build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.GetProceduresResponse getProcedures(RpcController rpcController, MasterProtos.GetProceduresRequest request) throws ServiceException {
        try {
            MasterProtos.GetProceduresResponse.Builder response = MasterProtos.GetProceduresResponse.newBuilder();
            for (Procedure<?> p : this.master.getProcedures()) {
                response.addProcedure(ProcedureUtil.convertToProtoProcedure(p));
            }
            return response.build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.GetLocksResponse getLocks(RpcController controller, MasterProtos.GetLocksRequest request) throws ServiceException {
        try {
            MasterProtos.GetLocksResponse.Builder builder = MasterProtos.GetLocksResponse.newBuilder();
            for (LockedResource lockedResource : this.master.getLocks()) {
                builder.addLock(ProcedureUtil.convertToProtoLockedResource(lockedResource));
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.ListTableDescriptorsByNamespaceResponse listTableDescriptorsByNamespace(RpcController c, MasterProtos.ListTableDescriptorsByNamespaceRequest request) throws ServiceException {
        try {
            MasterProtos.ListTableDescriptorsByNamespaceResponse.Builder b = MasterProtos.ListTableDescriptorsByNamespaceResponse.newBuilder();
            for (TableDescriptor htd : this.master.listTableDescriptorsByNamespace(request.getNamespaceName())) {
                b.addTableSchema(ProtobufUtil.toTableSchema(htd));
            }
            return b.build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.ListTableNamesByNamespaceResponse listTableNamesByNamespace(RpcController c, MasterProtos.ListTableNamesByNamespaceRequest request) throws ServiceException {
        try {
            MasterProtos.ListTableNamesByNamespaceResponse.Builder b = MasterProtos.ListTableNamesByNamespaceResponse.newBuilder();
            for (TableName tableName : this.master.listTableNamesByNamespace(request.getNamespaceName())) {
                b.addTableName(ProtobufUtil.toProtoTableName(tableName));
            }
            return b.build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.ModifyColumnResponse modifyColumn(RpcController controller, MasterProtos.ModifyColumnRequest req) throws ServiceException {
        try {
            long procId = this.master.modifyColumn(ProtobufUtil.toTableName(req.getTableName()), ProtobufUtil.toColumnFamilyDescriptor(req.getColumnFamilies()), req.getNonceGroup(), req.getNonce());
            if (procId == -1L) {
                return MasterProtos.ModifyColumnResponse.newBuilder().build();
            }
            return MasterProtos.ModifyColumnResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public MasterProtos.ModifyColumnStoreFileTrackerResponse modifyColumnStoreFileTracker(RpcController controller, MasterProtos.ModifyColumnStoreFileTrackerRequest req) throws ServiceException {
        try {
            long procId = this.master.modifyColumnStoreFileTracker(ProtobufUtil.toTableName(req.getTableName()), req.getFamily().toByteArray(), req.getDstSft(), req.getNonceGroup(), req.getNonce());
            return MasterProtos.ModifyColumnStoreFileTrackerResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public MasterProtos.FlushMasterStoreResponse flushMasterStore(RpcController controller, MasterProtos.FlushMasterStoreRequest request) throws ServiceException {
        this.rpcPreCheck("flushMasterStore");
        try {
            this.master.flushMasterStore();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
        return MasterProtos.FlushMasterStoreResponse.newBuilder().build();
    }

    @Override
    public MasterProtos.ModifyNamespaceResponse modifyNamespace(RpcController controller, MasterProtos.ModifyNamespaceRequest request) throws ServiceException {
        try {
            long procId = this.master.modifyNamespace(ProtobufUtil.toNamespaceDescriptor(request.getNamespaceDescriptor()), request.getNonceGroup(), request.getNonce());
            return MasterProtos.ModifyNamespaceResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.ModifyTableResponse modifyTable(RpcController controller, MasterProtos.ModifyTableRequest req) throws ServiceException {
        try {
            long procId = this.master.modifyTable(ProtobufUtil.toTableName(req.getTableName()), ProtobufUtil.toTableDescriptor(req.getTableSchema()), req.getNonceGroup(), req.getNonce());
            return MasterProtos.ModifyTableResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public MasterProtos.ModifyTableStoreFileTrackerResponse modifyTableStoreFileTracker(RpcController controller, MasterProtos.ModifyTableStoreFileTrackerRequest req) throws ServiceException {
        try {
            long procId = this.master.modifyTableStoreFileTracker(ProtobufUtil.toTableName(req.getTableName()), req.getDstSft(), req.getNonceGroup(), req.getNonce());
            return MasterProtos.ModifyTableStoreFileTrackerResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public MasterProtos.MoveRegionResponse moveRegion(RpcController controller, MasterProtos.MoveRegionRequest req) throws ServiceException {
        byte[] encodedRegionName = req.getRegion().getValue().toByteArray();
        HBaseProtos.RegionSpecifier.RegionSpecifierType type = req.getRegion().getType();
        byte[] destServerName = req.hasDestServerName() ? Bytes.toBytes(ProtobufUtil.toServerName(req.getDestServerName()).getServerName()) : null;
        MasterProtos.MoveRegionResponse mrr = MasterProtos.MoveRegionResponse.newBuilder().build();
        if (type != HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME) {
            LOG.warn("moveRegion specifier type: expected: " + HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME + " actual: " + type);
        }
        try {
            this.master.checkInitialized();
            this.master.move(encodedRegionName, destServerName);
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
        return mrr;
    }

    @Override
    public MasterProtos.OfflineRegionResponse offlineRegion(RpcController controller, MasterProtos.OfflineRegionRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            HBaseProtos.RegionSpecifier.RegionSpecifierType type = request.getRegion().getType();
            if (type != HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME) {
                LOG.warn("moveRegion specifier type: expected: " + HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME + " actual: " + type);
            }
            byte[] regionName = request.getRegion().getValue().toByteArray();
            RegionInfo hri = this.master.getAssignmentManager().getRegionInfo(regionName);
            if (hri == null) {
                throw new UnknownRegionException(Bytes.toStringBinary(regionName));
            }
            if (this.master.cpHost != null) {
                this.master.cpHost.preRegionOffline(hri);
            }
            LOG.info(this.master.getClientIdAuditPrefix() + " offline " + hri.getRegionNameAsString());
            this.master.getAssignmentManager().offlineRegion(hri);
            if (this.master.cpHost != null) {
                this.master.cpHost.postRegionOffline(hri);
            }
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
        return MasterProtos.OfflineRegionResponse.newBuilder().build();
    }

    @Override
    public MasterProtos.RestoreSnapshotResponse restoreSnapshot(RpcController controller, MasterProtos.RestoreSnapshotRequest request) throws ServiceException {
        try {
            long procId = this.master.restoreSnapshot(request.getSnapshot(), request.getNonceGroup(), request.getNonce(), request.getRestoreACL(), request.getCustomSFT());
            return MasterProtos.RestoreSnapshotResponse.newBuilder().setProcId(procId).build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.SetSnapshotCleanupResponse switchSnapshotCleanup(RpcController controller, MasterProtos.SetSnapshotCleanupRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            boolean enabled = request.getEnabled();
            boolean isSynchronous = request.hasSynchronous() && request.getSynchronous();
            boolean prevSnapshotCleanupRunning = this.switchSnapshotCleanup(enabled, isSynchronous);
            return MasterProtos.SetSnapshotCleanupResponse.newBuilder().setPrevSnapshotCleanup(prevSnapshotCleanupRunning).build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.IsSnapshotCleanupEnabledResponse isSnapshotCleanupEnabled(RpcController controller, MasterProtos.IsSnapshotCleanupEnabledRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            boolean isSnapshotCleanupEnabled = this.master.snapshotCleanupTracker.isSnapshotCleanupEnabled();
            return MasterProtos.IsSnapshotCleanupEnabledResponse.newBuilder().setEnabled(isSnapshotCleanupEnabled).build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    private synchronized boolean switchSnapshotCleanup(boolean enabledNewVal, boolean synchronous) {
        boolean oldValue = this.master.snapshotCleanupTracker.isSnapshotCleanupEnabled();
        this.master.switchSnapshotCleanup(enabledNewVal, synchronous);
        LOG.info("{} Successfully set snapshot cleanup to {}", (Object)this.master.getClientIdAuditPrefix(), (Object)enabledNewVal);
        return oldValue;
    }

    @Override
    public MasterProtos.RunCatalogScanResponse runCatalogScan(RpcController c, MasterProtos.RunCatalogScanRequest req) throws ServiceException {
        this.rpcPreCheck("runCatalogScan");
        try {
            return ResponseConverter.buildRunCatalogScanResponse(this.master.catalogJanitorChore.scan());
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public MasterProtos.RunCleanerChoreResponse runCleanerChore(RpcController c, MasterProtos.RunCleanerChoreRequest req) throws ServiceException {
        this.rpcPreCheck("runCleanerChore");
        boolean result = this.master.getHFileCleaner().runCleaner() && this.master.getLogCleaner().runCleaner();
        return ResponseConverter.buildRunCleanerChoreResponse(result);
    }

    @Override
    public MasterProtos.SetBalancerRunningResponse setBalancerRunning(RpcController c, MasterProtos.SetBalancerRunningRequest req) throws ServiceException {
        try {
            this.master.checkInitialized();
            boolean prevValue = req.getSynchronous() ? this.synchronousBalanceSwitch(req.getOn()) : this.master.balanceSwitch(req.getOn());
            return MasterProtos.SetBalancerRunningResponse.newBuilder().setPrevBalanceValue(prevValue).build();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public MasterProtos.ShutdownResponse shutdown(RpcController controller, MasterProtos.ShutdownRequest request) throws ServiceException {
        LOG.info(this.master.getClientIdAuditPrefix() + " shutdown");
        try {
            this.master.shutdown();
        }
        catch (IOException e) {
            LOG.error("Exception occurred in HMaster.shutdown()", (Throwable)e);
            throw new ServiceException(e);
        }
        return MasterProtos.ShutdownResponse.newBuilder().build();
    }

    @Override
    public MasterProtos.SnapshotResponse snapshot(RpcController controller, MasterProtos.SnapshotRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            this.master.snapshotManager.checkSnapshotSupport();
            LOG.info(this.master.getClientIdAuditPrefix() + " snapshot request for:" + ClientSnapshotDescriptionUtils.toString(request.getSnapshot()));
            SnapshotProtos.SnapshotDescription snapshot = SnapshotDescriptionUtils.validate(request.getSnapshot(), this.master.getConfiguration());
            this.master.snapshotManager.takeSnapshot(snapshot);
            long waitTime = SnapshotDescriptionUtils.getMaxMasterTimeout(this.master.getConfiguration(), snapshot.getType(), 300000L);
            return MasterProtos.SnapshotResponse.newBuilder().setExpectedTimeout(waitTime).build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.StopMasterResponse stopMaster(RpcController controller, MasterProtos.StopMasterRequest request) throws ServiceException {
        LOG.info(this.master.getClientIdAuditPrefix() + " stop");
        try {
            this.master.stopMaster();
        }
        catch (IOException e) {
            LOG.error("Exception occurred while stopping master", (Throwable)e);
            throw new ServiceException(e);
        }
        return MasterProtos.StopMasterResponse.newBuilder().build();
    }

    @Override
    public MasterProtos.IsInMaintenanceModeResponse isMasterInMaintenanceMode(RpcController controller, MasterProtos.IsInMaintenanceModeRequest request) throws ServiceException {
        MasterProtos.IsInMaintenanceModeResponse.Builder response = MasterProtos.IsInMaintenanceModeResponse.newBuilder();
        response.setInMaintenanceMode(this.master.isInMaintenanceMode());
        return response.build();
    }

    @Override
    public MasterProtos.UnassignRegionResponse unassignRegion(RpcController controller, MasterProtos.UnassignRegionRequest req) throws ServiceException {
        try {
            RegionStateNode rsn;
            byte[] regionName = req.getRegion().getValue().toByteArray();
            HBaseProtos.RegionSpecifier.RegionSpecifierType type = req.getRegion().getType();
            MasterProtos.UnassignRegionResponse urr = MasterProtos.UnassignRegionResponse.newBuilder().build();
            this.master.checkInitialized();
            if (type != HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME) {
                LOG.warn("unassignRegion specifier type: expected: " + HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME + " actual: " + type);
            }
            if ((rsn = this.master.getAssignmentManager().getRegionStates().getRegionStateNodeFromName(regionName)) == null) {
                throw new UnknownRegionException(Bytes.toString(regionName));
            }
            RegionInfo hri = rsn.getRegionInfo();
            if (this.master.cpHost != null) {
                this.master.cpHost.preUnassign(hri);
            }
            LOG.debug(this.master.getClientIdAuditPrefix() + " unassign " + hri.getRegionNameAsString() + " in current location if it is online");
            this.master.getAssignmentManager().unassign(hri);
            if (this.master.cpHost != null) {
                this.master.cpHost.postUnassign(hri);
            }
            return urr;
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public RegionServerStatusProtos.ReportRegionStateTransitionResponse reportRegionStateTransition(RpcController c, RegionServerStatusProtos.ReportRegionStateTransitionRequest req) throws ServiceException {
        try {
            this.master.checkServiceStarted();
            return this.master.getAssignmentManager().reportRegionStateTransition(req);
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public MasterProtos.SetQuotaResponse setQuota(RpcController c, MasterProtos.SetQuotaRequest req) throws ServiceException {
        try {
            this.master.checkInitialized();
            return this.master.getMasterQuotaManager().setQuota(req);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.MajorCompactionTimestampResponse getLastMajorCompactionTimestamp(RpcController controller, MasterProtos.MajorCompactionTimestampRequest request) throws ServiceException {
        MasterProtos.MajorCompactionTimestampResponse.Builder response = MasterProtos.MajorCompactionTimestampResponse.newBuilder();
        try {
            this.master.checkInitialized();
            response.setCompactionTimestamp(this.master.getLastMajorCompactionTimestamp(ProtobufUtil.toTableName(request.getTableName())));
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return response.build();
    }

    @Override
    public MasterProtos.MajorCompactionTimestampResponse getLastMajorCompactionTimestampForRegion(RpcController controller, MasterProtos.MajorCompactionTimestampForRegionRequest request) throws ServiceException {
        MasterProtos.MajorCompactionTimestampResponse.Builder response = MasterProtos.MajorCompactionTimestampResponse.newBuilder();
        try {
            this.master.checkInitialized();
            response.setCompactionTimestamp(this.master.getLastMajorCompactionTimestampForRegion(request.getRegion().getValue().toByteArray()));
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return response.build();
    }

    @Override
    @QosPriority(priority=100)
    public AdminProtos.CompactRegionResponse compactRegion(RpcController controller, AdminProtos.CompactRegionRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            byte[] regionName = request.getRegion().getValue().toByteArray();
            TableName tableName = RegionInfo.getTable(regionName);
            if (MobUtils.isMobRegionName(tableName, regionName)) {
                this.checkHFileFormatVersionForMob();
                LOG.warn("CompactType.MOB is not supported yet, will run regular compaction. Refer to HBASE-23571.");
                return super.compactRegion(controller, request);
            }
            return super.compactRegion(controller, request);
        }
        catch (IOException ie) {
            throw new ServiceException(ie);
        }
    }

    private void checkHFileFormatVersionForMob() throws IOException {
        if (HFile.getFormatVersion(this.master.getConfiguration()) < 3) {
            LOG.error("A minimum HFile version of 3 is required for MOB compaction. Compaction will not run.");
            throw new IOException("A minimum HFile version of 3 is required for MOB feature. Consider setting hfile.format.version accordingly.");
        }
    }

    @Override
    @QosPriority(priority=100)
    public AdminProtos.GetRegionInfoResponse getRegionInfo(RpcController controller, AdminProtos.GetRegionInfoRequest request) throws ServiceException {
        RegionInfo ri = null;
        try {
            ri = this.getRegionInfo(request.getRegion());
        }
        catch (UnknownRegionException ure) {
            throw new ServiceException(ure);
        }
        AdminProtos.GetRegionInfoResponse.Builder builder = AdminProtos.GetRegionInfoResponse.newBuilder();
        if (ri != null) {
            builder.setRegionInfo(ProtobufUtil.toRegionInfo(ri));
        } else {
            byte[] regionName = request.getRegion().getValue().toByteArray();
            TableName tableName = RegionInfo.getTable(regionName);
            if (MobUtils.isMobRegionName(tableName, regionName)) {
                RegionInfo mobRegionInfo = MobUtils.getMobRegionInfo(tableName);
                builder.setRegionInfo(ProtobufUtil.toRegionInfo(mobRegionInfo));
                if (request.hasCompactionState() && request.getCompactionState()) {
                    builder.setCompactionState(this.master.getMobCompactionState(tableName));
                }
            } else {
                throw new ServiceException(new UnknownRegionException(Bytes.toString(regionName)));
            }
        }
        return builder.build();
    }

    @Override
    public MasterProtos.IsBalancerEnabledResponse isBalancerEnabled(RpcController controller, MasterProtos.IsBalancerEnabledRequest request) throws ServiceException {
        MasterProtos.IsBalancerEnabledResponse.Builder response = MasterProtos.IsBalancerEnabledResponse.newBuilder();
        response.setEnabled(this.master.isBalancerOn());
        return response.build();
    }

    @Override
    public MasterProtos.SetSplitOrMergeEnabledResponse setSplitOrMergeEnabled(RpcController controller, MasterProtos.SetSplitOrMergeEnabledRequest request) throws ServiceException {
        MasterProtos.SetSplitOrMergeEnabledResponse.Builder response = MasterProtos.SetSplitOrMergeEnabledResponse.newBuilder();
        try {
            this.master.checkInitialized();
            boolean newValue = request.getEnabled();
            for (MasterProtos.MasterSwitchType masterSwitchType : request.getSwitchTypesList()) {
                MasterSwitchType switchType = this.convert(masterSwitchType);
                boolean oldValue = this.master.isSplitOrMergeEnabled(switchType);
                response.addPrevValue(oldValue);
                if (this.master.cpHost != null) {
                    this.master.cpHost.preSetSplitOrMergeEnabled(newValue, switchType);
                }
                this.master.getSplitOrMergeTracker().setSplitOrMergeEnabled(newValue, switchType);
                if (this.master.cpHost == null) continue;
                this.master.cpHost.postSetSplitOrMergeEnabled(newValue, switchType);
            }
        }
        catch (IOException | KeeperException e) {
            throw new ServiceException(e);
        }
        return response.build();
    }

    @Override
    public MasterProtos.IsSplitOrMergeEnabledResponse isSplitOrMergeEnabled(RpcController controller, MasterProtos.IsSplitOrMergeEnabledRequest request) throws ServiceException {
        MasterProtos.IsSplitOrMergeEnabledResponse.Builder response = MasterProtos.IsSplitOrMergeEnabledResponse.newBuilder();
        response.setEnabled(this.master.isSplitOrMergeEnabled(this.convert(request.getSwitchType())));
        return response.build();
    }

    @Override
    public MasterProtos.NormalizeResponse normalize(RpcController controller, MasterProtos.NormalizeRequest request) throws ServiceException {
        this.rpcPreCheck("normalize");
        try {
            NormalizeTableFilterParams ntfp = new NormalizeTableFilterParams.Builder().tableNames(ProtobufUtil.toTableNameList(request.getTableNamesList())).regex(request.hasRegex() ? request.getRegex() : null).namespace(request.hasNamespace() ? request.getNamespace() : null).build();
            return MasterProtos.NormalizeResponse.newBuilder().setNormalizerRan(this.master.normalizeRegions(ntfp, true)).build();
        }
        catch (IOException ex) {
            throw new ServiceException(ex);
        }
    }

    @Override
    public MasterProtos.SetNormalizerRunningResponse setNormalizerRunning(RpcController controller, MasterProtos.SetNormalizerRunningRequest request) throws ServiceException {
        this.rpcPreCheck("setNormalizerRunning");
        boolean prevValue = this.master.getRegionNormalizerManager().isNormalizerOn();
        boolean newValue = request.getOn();
        this.master.getRegionNormalizerManager().setNormalizerOn(newValue);
        LOG.info("{} set normalizerSwitch={}", (Object)this.master.getClientIdAuditPrefix(), (Object)newValue);
        return MasterProtos.SetNormalizerRunningResponse.newBuilder().setPrevNormalizerValue(prevValue).build();
    }

    @Override
    public MasterProtos.IsNormalizerEnabledResponse isNormalizerEnabled(RpcController controller, MasterProtos.IsNormalizerEnabledRequest request) {
        MasterProtos.IsNormalizerEnabledResponse.Builder response = MasterProtos.IsNormalizerEnabledResponse.newBuilder();
        response.setEnabled(this.master.isNormalizerOn());
        return response.build();
    }

    @Override
    public MasterProtos.SecurityCapabilitiesResponse getSecurityCapabilities(RpcController controller, MasterProtos.SecurityCapabilitiesRequest request) throws ServiceException {
        MasterProtos.SecurityCapabilitiesResponse.Builder response = MasterProtos.SecurityCapabilitiesResponse.newBuilder();
        try {
            this.master.checkInitialized();
            HashSet<MasterProtos.SecurityCapabilitiesResponse.Capability> capabilities = new HashSet<MasterProtos.SecurityCapabilitiesResponse.Capability>();
            if (User.isHBaseSecurityEnabled(this.master.getConfiguration())) {
                capabilities.add(MasterProtos.SecurityCapabilitiesResponse.Capability.SECURE_AUTHENTICATION);
            } else {
                capabilities.add(MasterProtos.SecurityCapabilitiesResponse.Capability.SIMPLE_AUTHENTICATION);
            }
            if (this.master.cpHost != null && this.hasAccessControlServiceCoprocessor(this.master.cpHost)) {
                if (AccessChecker.isAuthorizationSupported(this.master.getConfiguration())) {
                    capabilities.add(MasterProtos.SecurityCapabilitiesResponse.Capability.AUTHORIZATION);
                }
                if (AccessController.isCellAuthorizationSupported(this.master.getConfiguration())) {
                    capabilities.add(MasterProtos.SecurityCapabilitiesResponse.Capability.CELL_AUTHORIZATION);
                }
            }
            if (this.master.cpHost != null && this.hasVisibilityLabelsServiceCoprocessor(this.master.cpHost) && VisibilityController.isCellAuthorizationSupported(this.master.getConfiguration())) {
                capabilities.add(MasterProtos.SecurityCapabilitiesResponse.Capability.CELL_VISIBILITY);
            }
            response.addAllCapabilities(capabilities);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return response.build();
    }

    boolean hasAccessControlServiceCoprocessor(MasterCoprocessorHost cpHost) {
        return this.checkCoprocessorWithService(cpHost.findCoprocessors(MasterCoprocessor.class), AccessControlProtos.AccessControlService.Interface.class);
    }

    boolean hasVisibilityLabelsServiceCoprocessor(MasterCoprocessorHost cpHost) {
        return this.checkCoprocessorWithService(cpHost.findCoprocessors(MasterCoprocessor.class), VisibilityLabelsProtos.VisibilityLabelsService.Interface.class);
    }

    boolean checkCoprocessorWithService(List<MasterCoprocessor> coprocessorsToCheck, Class<?> service) {
        if (coprocessorsToCheck == null || coprocessorsToCheck.isEmpty()) {
            return false;
        }
        for (MasterCoprocessor cp : coprocessorsToCheck) {
            if (!service.isAssignableFrom(cp.getClass())) continue;
            return true;
        }
        return false;
    }

    private MasterSwitchType convert(MasterProtos.MasterSwitchType switchType) {
        switch (switchType) {
            case SPLIT: {
                return MasterSwitchType.SPLIT;
            }
            case MERGE: {
                return MasterSwitchType.MERGE;
            }
        }
        return null;
    }

    @Override
    public ReplicationProtos.AddReplicationPeerResponse addReplicationPeer(RpcController controller, ReplicationProtos.AddReplicationPeerRequest request) throws ServiceException {
        try {
            long procId = this.master.addReplicationPeer(request.getPeerId(), ReplicationPeerConfigUtil.convert(request.getPeerConfig()), request.getPeerState().getState().equals(ReplicationProtos.ReplicationState.State.ENABLED));
            return ReplicationProtos.AddReplicationPeerResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException | ReplicationException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public ReplicationProtos.RemoveReplicationPeerResponse removeReplicationPeer(RpcController controller, ReplicationProtos.RemoveReplicationPeerRequest request) throws ServiceException {
        try {
            long procId = this.master.removeReplicationPeer(request.getPeerId());
            return ReplicationProtos.RemoveReplicationPeerResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException | ReplicationException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public ReplicationProtos.EnableReplicationPeerResponse enableReplicationPeer(RpcController controller, ReplicationProtos.EnableReplicationPeerRequest request) throws ServiceException {
        try {
            long procId = this.master.enableReplicationPeer(request.getPeerId());
            return ReplicationProtos.EnableReplicationPeerResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException | ReplicationException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public ReplicationProtos.DisableReplicationPeerResponse disableReplicationPeer(RpcController controller, ReplicationProtos.DisableReplicationPeerRequest request) throws ServiceException {
        try {
            long procId = this.master.disableReplicationPeer(request.getPeerId());
            return ReplicationProtos.DisableReplicationPeerResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException | ReplicationException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public ReplicationProtos.GetReplicationPeerConfigResponse getReplicationPeerConfig(RpcController controller, ReplicationProtos.GetReplicationPeerConfigRequest request) throws ServiceException {
        ReplicationProtos.GetReplicationPeerConfigResponse.Builder response = ReplicationProtos.GetReplicationPeerConfigResponse.newBuilder();
        try {
            String peerId = request.getPeerId();
            ReplicationPeerConfig peerConfig = this.master.getReplicationPeerConfig(peerId);
            response.setPeerId(peerId);
            response.setPeerConfig(ReplicationPeerConfigUtil.convert(peerConfig));
        }
        catch (IOException | ReplicationException e) {
            throw new ServiceException(e);
        }
        return response.build();
    }

    @Override
    public ReplicationProtos.UpdateReplicationPeerConfigResponse updateReplicationPeerConfig(RpcController controller, ReplicationProtos.UpdateReplicationPeerConfigRequest request) throws ServiceException {
        try {
            long procId = this.master.updateReplicationPeerConfig(request.getPeerId(), ReplicationPeerConfigUtil.convert(request.getPeerConfig()));
            return ReplicationProtos.UpdateReplicationPeerConfigResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException | ReplicationException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public ReplicationProtos.ListReplicationPeersResponse listReplicationPeers(RpcController controller, ReplicationProtos.ListReplicationPeersRequest request) throws ServiceException {
        ReplicationProtos.ListReplicationPeersResponse.Builder response = ReplicationProtos.ListReplicationPeersResponse.newBuilder();
        try {
            List<ReplicationPeerDescription> peers = this.master.listReplicationPeers(request.hasRegex() ? request.getRegex() : null);
            for (ReplicationPeerDescription peer : peers) {
                response.addPeerDesc(ReplicationPeerConfigUtil.toProtoReplicationPeerDescription(peer));
            }
        }
        catch (IOException | ReplicationException e) {
            throw new ServiceException(e);
        }
        return response.build();
    }

    @Override
    public MasterProtos.ListDecommissionedRegionServersResponse listDecommissionedRegionServers(RpcController controller, MasterProtos.ListDecommissionedRegionServersRequest request) throws ServiceException {
        MasterProtos.ListDecommissionedRegionServersResponse.Builder response = MasterProtos.ListDecommissionedRegionServersResponse.newBuilder();
        try {
            this.master.checkInitialized();
            if (this.master.cpHost != null) {
                this.master.cpHost.preListDecommissionedRegionServers();
            }
            List<ServerName> servers = this.master.listDecommissionedRegionServers();
            response.addAllServerName(servers.stream().map(server -> ProtobufUtil.toServerName(server)).collect(Collectors.toList()));
            if (this.master.cpHost != null) {
                this.master.cpHost.postListDecommissionedRegionServers();
            }
        }
        catch (IOException io) {
            throw new ServiceException(io);
        }
        return response.build();
    }

    @Override
    public MasterProtos.DecommissionRegionServersResponse decommissionRegionServers(RpcController controller, MasterProtos.DecommissionRegionServersRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            List<ServerName> servers = request.getServerNameList().stream().map(pbServer -> ProtobufUtil.toServerName(pbServer)).collect(Collectors.toList());
            boolean offload = request.getOffload();
            if (this.master.cpHost != null) {
                this.master.cpHost.preDecommissionRegionServers(servers, offload);
            }
            this.master.decommissionRegionServers(servers, offload);
            if (this.master.cpHost != null) {
                this.master.cpHost.postDecommissionRegionServers(servers, offload);
            }
        }
        catch (IOException io) {
            throw new ServiceException(io);
        }
        return MasterProtos.DecommissionRegionServersResponse.newBuilder().build();
    }

    @Override
    public MasterProtos.RecommissionRegionServerResponse recommissionRegionServer(RpcController controller, MasterProtos.RecommissionRegionServerRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            ServerName server = ProtobufUtil.toServerName(request.getServerName());
            List<byte[]> encodedRegionNames = request.getRegionList().stream().map(regionSpecifier -> regionSpecifier.getValue().toByteArray()).collect(Collectors.toList());
            if (this.master.cpHost != null) {
                this.master.cpHost.preRecommissionRegionServer(server, encodedRegionNames);
            }
            this.master.recommissionRegionServer(server, encodedRegionNames);
            if (this.master.cpHost != null) {
                this.master.cpHost.postRecommissionRegionServer(server, encodedRegionNames);
            }
        }
        catch (IOException io) {
            throw new ServiceException(io);
        }
        return MasterProtos.RecommissionRegionServerResponse.newBuilder().build();
    }

    @Override
    public LockServiceProtos.LockResponse requestLock(RpcController controller, final LockServiceProtos.LockRequest request) throws ServiceException {
        try {
            MasterProcedureUtil.NonceProcedureRunnable npr;
            if (request.getDescription().isEmpty()) {
                throw new IllegalArgumentException("Empty description");
            }
            final LockType type = LockType.valueOf(request.getLockType().name());
            if (request.getRegionInfoCount() > 0) {
                final RegionInfo[] regionInfos = new RegionInfo[request.getRegionInfoCount()];
                for (int i = 0; i < request.getRegionInfoCount(); ++i) {
                    regionInfos[i] = ProtobufUtil.toRegionInfo(request.getRegionInfo(i));
                }
                npr = new MasterProcedureUtil.NonceProcedureRunnable(this.master, request.getNonceGroup(), request.getNonce()){

                    @Override
                    protected void run() throws IOException {
                        this.setProcId(MasterRpcServices.this.master.getLockManager().remoteLocks().requestRegionsLock(regionInfos, request.getDescription(), this.getNonceKey()));
                    }

                    @Override
                    protected String getDescription() {
                        return "RequestLock";
                    }
                };
            } else if (request.hasTableName()) {
                final TableName tableName = ProtobufUtil.toTableName(request.getTableName());
                npr = new MasterProcedureUtil.NonceProcedureRunnable(this.master, request.getNonceGroup(), request.getNonce()){

                    @Override
                    protected void run() throws IOException {
                        this.setProcId(MasterRpcServices.this.master.getLockManager().remoteLocks().requestTableLock(tableName, type, request.getDescription(), this.getNonceKey()));
                    }

                    @Override
                    protected String getDescription() {
                        return "RequestLock";
                    }
                };
            } else if (request.hasNamespace()) {
                npr = new MasterProcedureUtil.NonceProcedureRunnable(this.master, request.getNonceGroup(), request.getNonce()){

                    @Override
                    protected void run() throws IOException {
                        this.setProcId(MasterRpcServices.this.master.getLockManager().remoteLocks().requestNamespaceLock(request.getNamespace(), type, request.getDescription(), this.getNonceKey()));
                    }

                    @Override
                    protected String getDescription() {
                        return "RequestLock";
                    }
                };
            } else {
                throw new IllegalArgumentException("one of table/namespace/region should be specified");
            }
            long procId = MasterProcedureUtil.submitProcedure(npr);
            return LockServiceProtos.LockResponse.newBuilder().setProcId(procId).build();
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Exception when queuing lock", (Throwable)e);
            throw new ServiceException(new DoNotRetryIOException(e));
        }
        catch (IOException e) {
            LOG.warn("Exception when queuing lock", (Throwable)e);
            throw new ServiceException(e);
        }
    }

    @Override
    public LockServiceProtos.LockHeartbeatResponse lockHeartbeat(RpcController controller, LockServiceProtos.LockHeartbeatRequest request) throws ServiceException {
        try {
            if (this.master.getLockManager().remoteLocks().lockHeartbeat(request.getProcId(), request.getKeepAlive())) {
                return LockServiceProtos.LockHeartbeatResponse.newBuilder().setTimeoutMs(this.master.getConfiguration().getInt("hbase.master.procedure.remote.locks.timeout.ms", 30000)).setLockStatus(LockServiceProtos.LockHeartbeatResponse.LockStatus.LOCKED).build();
            }
            return LockServiceProtos.LockHeartbeatResponse.newBuilder().setLockStatus(LockServiceProtos.LockHeartbeatResponse.LockStatus.UNLOCKED).build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public RegionServerStatusProtos.RegionSpaceUseReportResponse reportRegionSpaceUse(RpcController controller, RegionServerStatusProtos.RegionSpaceUseReportRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            if (!QuotaUtil.isQuotaEnabled(this.master.getConfiguration())) {
                return RegionServerStatusProtos.RegionSpaceUseReportResponse.newBuilder().build();
            }
            MasterQuotaManager quotaManager = this.master.getMasterQuotaManager();
            if (quotaManager != null) {
                long now = EnvironmentEdgeManager.currentTime();
                for (RegionServerStatusProtos.RegionSpaceUse report : request.getSpaceUseList()) {
                    quotaManager.addRegionSize(ProtobufUtil.toRegionInfo(report.getRegionInfo()), report.getRegionSize(), now);
                }
            } else {
                LOG.debug("Received region space usage report but HMaster is not ready to process it, skipping");
            }
            return RegionServerStatusProtos.RegionSpaceUseReportResponse.newBuilder().build();
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public QuotaProtos.GetSpaceQuotaRegionSizesResponse getSpaceQuotaRegionSizes(RpcController controller, QuotaProtos.GetSpaceQuotaRegionSizesRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            MasterQuotaManager quotaManager = this.master.getMasterQuotaManager();
            QuotaProtos.GetSpaceQuotaRegionSizesResponse.Builder builder = QuotaProtos.GetSpaceQuotaRegionSizesResponse.newBuilder();
            if (quotaManager != null) {
                Map<RegionInfo, Long> regionSizes = quotaManager.snapshotRegionSizes();
                HashMap<TableName, Long> regionSizesByTable = new HashMap<TableName, Long>();
                for (Map.Entry<RegionInfo, Long> entry : regionSizes.entrySet()) {
                    TableName tableName = entry.getKey().getTable();
                    Long prevSize = (Long)regionSizesByTable.get(tableName);
                    if (prevSize == null) {
                        prevSize = 0L;
                    }
                    regionSizesByTable.put(tableName, prevSize + entry.getValue());
                }
                for (Map.Entry<RegionInfo, Long> entry : regionSizesByTable.entrySet()) {
                    builder.addSizes(QuotaProtos.GetSpaceQuotaRegionSizesResponse.RegionSizes.newBuilder().setTableName(ProtobufUtil.toProtoTableName((TableName)((Object)entry.getKey()))).setSize(entry.getValue()).build());
                }
                return builder.build();
            }
            LOG.debug("Received space quota region size report but HMaster is not ready to process it,skipping");
            return builder.build();
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public QuotaProtos.GetQuotaStatesResponse getQuotaStates(RpcController controller, QuotaProtos.GetQuotaStatesRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            QuotaObserverChore quotaChore = this.master.getQuotaObserverChore();
            QuotaProtos.GetQuotaStatesResponse.Builder builder = QuotaProtos.GetQuotaStatesResponse.newBuilder();
            if (quotaChore != null) {
                Map<TableName, SpaceQuotaSnapshot> tableSnapshots = quotaChore.getTableQuotaSnapshots();
                for (Map.Entry<TableName, SpaceQuotaSnapshot> entry : tableSnapshots.entrySet()) {
                    builder.addTableSnapshots(QuotaProtos.GetQuotaStatesResponse.TableQuotaSnapshot.newBuilder().setTableName(ProtobufUtil.toProtoTableName(entry.getKey())).setSnapshot(SpaceQuotaSnapshot.toProtoSnapshot(entry.getValue())).build());
                }
                Map<String, SpaceQuotaSnapshot> nsSnapshots = quotaChore.getNamespaceQuotaSnapshots();
                for (Map.Entry<String, SpaceQuotaSnapshot> entry : nsSnapshots.entrySet()) {
                    builder.addNsSnapshots(QuotaProtos.GetQuotaStatesResponse.NamespaceQuotaSnapshot.newBuilder().setNamespace(entry.getKey()).setSnapshot(SpaceQuotaSnapshot.toProtoSnapshot(entry.getValue())).build());
                }
                return builder.build();
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.ClearDeadServersResponse clearDeadServers(RpcController controller, MasterProtos.ClearDeadServersRequest request) throws ServiceException {
        LOG.debug(this.master.getClientIdAuditPrefix() + " clear dead region servers.");
        MasterProtos.ClearDeadServersResponse.Builder response = MasterProtos.ClearDeadServersResponse.newBuilder();
        try {
            this.master.checkInitialized();
            if (this.master.cpHost != null) {
                this.master.cpHost.preClearDeadServers();
            }
            if (this.master.getServerManager().areDeadServersInProgress()) {
                LOG.debug("Some dead server is still under processing, won't clear the dead server list");
                response.addAllServerName(request.getServerNameList());
            } else {
                for (HBaseProtos.ServerName pbServer : request.getServerNameList()) {
                    if (this.master.getServerManager().getDeadServers().removeDeadServer(ProtobufUtil.toServerName(pbServer))) continue;
                    response.addServerName(pbServer);
                }
            }
            if (this.master.cpHost != null) {
                this.master.cpHost.postClearDeadServers(ProtobufUtil.toServerNameList(request.getServerNameList()), ProtobufUtil.toServerNameList(response.getServerNameList()));
            }
        }
        catch (IOException io) {
            throw new ServiceException(io);
        }
        return response.build();
    }

    @Override
    public RegionServerStatusProtos.ReportProcedureDoneResponse reportProcedureDone(RpcController controller, RegionServerStatusProtos.ReportProcedureDoneRequest request) throws ServiceException {
        try {
            this.master.checkServiceStarted();
        }
        catch (ServerNotRunningYetException snrye) {
            throw new ServiceException(snrye);
        }
        request.getResultList().forEach(result -> {
            if (result.getStatus() == RegionServerStatusProtos.RemoteProcedureResult.Status.SUCCESS) {
                this.master.remoteProcedureCompleted(result.getProcId());
            } else {
                this.master.remoteProcedureFailed(result.getProcId(), RemoteProcedureException.fromProto(result.getError()));
            }
        });
        return RegionServerStatusProtos.ReportProcedureDoneResponse.getDefaultInstance();
    }

    @Override
    public MasterProtos.RunHbckChoreResponse runHbckChore(RpcController c, MasterProtos.RunHbckChoreRequest req) throws ServiceException {
        this.rpcPreCheck("runHbckChore");
        LOG.info("{} request HBCK chore to run", (Object)this.master.getClientIdAuditPrefix());
        HbckChore hbckChore = this.master.getHbckChore();
        boolean ran = hbckChore.runChore();
        return MasterProtos.RunHbckChoreResponse.newBuilder().setRan(ran).build();
    }

    @Override
    public MasterProtos.GetTableStateResponse setTableStateInMeta(RpcController controller, MasterProtos.SetTableStateInMetaRequest request) throws ServiceException {
        this.rpcPreCheck("setTableStateInMeta");
        TableName tn = ProtobufUtil.toTableName(request.getTableName());
        try {
            TableState prevState = this.master.getTableStateManager().getTableState(tn);
            TableState newState = TableState.convert(tn, request.getTableState());
            LOG.info("{} set table={} state from {} to {}", new Object[]{this.master.getClientIdAuditPrefix(), tn, prevState.getState(), newState.getState()});
            this.master.getTableStateManager().setTableState(tn, newState.getState());
            return MasterProtos.GetTableStateResponse.newBuilder().setTableState(prevState.convert()).build();
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.SetRegionStateInMetaResponse setRegionStateInMeta(RpcController controller, MasterProtos.SetRegionStateInMetaRequest request) throws ServiceException {
        this.rpcPreCheck("setRegionStateInMeta");
        MasterProtos.SetRegionStateInMetaResponse.Builder builder = MasterProtos.SetRegionStateInMetaResponse.newBuilder();
        try {
            for (MasterProtos.RegionSpecifierAndState s2 : request.getStatesList()) {
                HBaseProtos.RegionSpecifier spec = s2.getRegionSpecifier();
                String encodedName = spec.getType() == HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME ? spec.getValue().toStringUtf8() : RegionInfo.encodeRegionName(spec.getValue().toByteArray());
                RegionInfo info = this.master.getAssignmentManager().loadRegionFromMeta(encodedName);
                LOG.trace("region info loaded from meta table: {}", (Object)info);
                RegionState prevState = this.master.getAssignmentManager().getRegionStates().getRegionState(info);
                RegionState.State newState = RegionState.State.convert(s2.getState());
                LOG.info("{} set region={} state from {} to {}", new Object[]{this.master.getClientIdAuditPrefix(), info, prevState.getState(), newState});
                Put metaPut = MetaTableAccessor.makePutFromRegionInfo(info, EnvironmentEdgeManager.currentTime());
                metaPut.addColumn(HConstants.CATALOG_FAMILY, HConstants.STATE_QUALIFIER, Bytes.toBytes(newState.name()));
                ArrayList<Put> putList = new ArrayList<Put>();
                putList.add(metaPut);
                MetaTableAccessor.putsToMetaTable(this.master.getConnection(), putList);
                this.master.getAssignmentManager().loadRegionFromMeta(encodedName);
                builder.addStates(MasterProtos.RegionSpecifierAndState.newBuilder().setRegionSpecifier(spec).setState(prevState.getState().convert()));
            }
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
        return builder.build();
    }

    private RegionInfo getRegionInfo(HBaseProtos.RegionSpecifier rs) throws UnknownRegionException {
        RegionInfo ri = null;
        switch (rs.getType()) {
            case REGION_NAME: {
                byte[] regionName = rs.getValue().toByteArray();
                ri = this.master.getAssignmentManager().getRegionInfo(regionName);
                break;
            }
            case ENCODED_REGION_NAME: {
                String encodedRegionName = Bytes.toString(rs.getValue().toByteArray());
                RegionState regionState = this.master.getAssignmentManager().getRegionStates().getRegionState(encodedRegionName);
                ri = regionState == null ? this.master.getAssignmentManager().loadRegionFromMeta(encodedRegionName) : regionState.getRegion();
                break;
            }
        }
        return ri;
    }

    private void checkMasterProcedureExecutor() throws ServiceException {
        if (this.master.getMasterProcedureExecutor() == null) {
            throw new ServiceException("Master's ProcedureExecutor not initialized; retry later");
        }
    }

    @Override
    public MasterProtos.AssignsResponse assigns(RpcController controller, MasterProtos.AssignsRequest request) throws ServiceException {
        this.checkMasterProcedureExecutor();
        MasterProtos.AssignsResponse.Builder responseBuilder = MasterProtos.AssignsResponse.newBuilder();
        try {
            boolean override = request.getOverride();
            LOG.info("{} assigns, override={}", (Object)this.master.getClientIdAuditPrefix(), (Object)override);
            for (HBaseProtos.RegionSpecifier rs : request.getRegionList()) {
                long pid = -1L;
                RegionInfo ri = this.getRegionInfo(rs);
                if (ri == null) {
                    LOG.info("Unknown={}", (Object)rs);
                } else {
                    TransitRegionStateProcedure p = this.master.getAssignmentManager().createOneAssignProcedure(ri, override);
                    if (p != null) {
                        pid = this.master.getMasterProcedureExecutor().submitProcedure(p);
                    }
                }
                responseBuilder.addPid(pid);
            }
            return responseBuilder.build();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public MasterProtos.UnassignsResponse unassigns(RpcController controller, MasterProtos.UnassignsRequest request) throws ServiceException {
        this.checkMasterProcedureExecutor();
        MasterProtos.UnassignsResponse.Builder responseBuilder = MasterProtos.UnassignsResponse.newBuilder();
        try {
            boolean override = request.getOverride();
            LOG.info("{} unassigns, override={}", (Object)this.master.getClientIdAuditPrefix(), (Object)override);
            for (HBaseProtos.RegionSpecifier rs : request.getRegionList()) {
                long pid = -1L;
                RegionInfo ri = this.getRegionInfo(rs);
                if (ri == null) {
                    LOG.info("Unknown={}", (Object)rs);
                } else {
                    TransitRegionStateProcedure p = this.master.getAssignmentManager().createOneUnassignProcedure(ri, override);
                    if (p != null) {
                        pid = this.master.getMasterProcedureExecutor().submitProcedure(p);
                    }
                }
                responseBuilder.addPid(pid);
            }
            return responseBuilder.build();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public MasterProtos.BypassProcedureResponse bypassProcedure(RpcController controller, MasterProtos.BypassProcedureRequest request) throws ServiceException {
        try {
            LOG.info("{} bypass procedures={}, waitTime={}, override={}, recursive={}", new Object[]{this.master.getClientIdAuditPrefix(), request.getProcIdList(), request.getWaitTime(), request.getOverride(), request.getRecursive()});
            List<Boolean> ret = this.master.getMasterProcedureExecutor().bypassProcedure(request.getProcIdList(), request.getWaitTime(), request.getOverride(), request.getRecursive());
            return MasterProtos.BypassProcedureResponse.newBuilder().addAllBypassed(ret).build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.ScheduleServerCrashProcedureResponse scheduleServerCrashProcedure(RpcController controller, MasterProtos.ScheduleServerCrashProcedureRequest request) throws ServiceException {
        ArrayList<Long> pids = new ArrayList<Long>();
        for (HBaseProtos.ServerName sn : request.getServerNameList()) {
            ServerName serverName = ProtobufUtil.toServerName(sn);
            LOG.info("{} schedule ServerCrashProcedure for {}", (Object)this.master.getClientIdAuditPrefix(), (Object)serverName);
            if (this.shouldSubmitSCP(serverName)) {
                pids.add(this.master.getServerManager().expireServer(serverName, true));
                continue;
            }
            pids.add(-1L);
        }
        return MasterProtos.ScheduleServerCrashProcedureResponse.newBuilder().addAllPid(pids).build();
    }

    @Override
    public MasterProtos.ScheduleSCPsForUnknownServersResponse scheduleSCPsForUnknownServers(RpcController controller, MasterProtos.ScheduleSCPsForUnknownServersRequest request) throws ServiceException {
        ArrayList<Long> pids = new ArrayList<Long>();
        Set serverNames = this.master.getAssignmentManager().getRegionStates().getRegionStates().stream().map(RegionState::getServerName).collect(Collectors.toSet());
        Set unknownServerNames = serverNames.stream().filter(sn -> this.master.getServerManager().isServerUnknown((ServerName)sn)).collect(Collectors.toSet());
        for (ServerName sn2 : unknownServerNames) {
            LOG.info("{} schedule ServerCrashProcedure for unknown {}", (Object)this.master.getClientIdAuditPrefix(), (Object)sn2);
            if (this.shouldSubmitSCP(sn2)) {
                pids.add(this.master.getServerManager().expireServer(sn2, true));
                continue;
            }
            pids.add(-1L);
        }
        return MasterProtos.ScheduleSCPsForUnknownServersResponse.newBuilder().addAllPid(pids).build();
    }

    @Override
    public MasterProtos.FixMetaResponse fixMeta(RpcController controller, MasterProtos.FixMetaRequest request) throws ServiceException {
        this.rpcPreCheck("fixMeta");
        try {
            MetaFixer mf = new MetaFixer(this.master);
            mf.fix();
            return MasterProtos.FixMetaResponse.newBuilder().build();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public MasterProtos.SwitchRpcThrottleResponse switchRpcThrottle(RpcController controller, MasterProtos.SwitchRpcThrottleRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            return this.master.getMasterQuotaManager().switchRpcThrottle(request);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.IsRpcThrottleEnabledResponse isRpcThrottleEnabled(RpcController controller, MasterProtos.IsRpcThrottleEnabledRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            return this.master.getMasterQuotaManager().isRpcThrottleEnabled(request);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public MasterProtos.SwitchExceedThrottleQuotaResponse switchExceedThrottleQuota(RpcController controller, MasterProtos.SwitchExceedThrottleQuotaRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            return this.master.getMasterQuotaManager().switchExceedThrottleQuota(request);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public RegionServerStatusProtos.FileArchiveNotificationResponse reportFileArchival(RpcController controller, RegionServerStatusProtos.FileArchiveNotificationRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            if (!QuotaUtil.isQuotaEnabled(this.master.getConfiguration())) {
                return RegionServerStatusProtos.FileArchiveNotificationResponse.newBuilder().build();
            }
            this.master.getMasterQuotaManager().processFileArchivals(request, this.master.getConnection(), this.master.getConfiguration(), this.master.getFileSystem());
            return RegionServerStatusProtos.FileArchiveNotificationResponse.newBuilder().build();
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public AccessControlProtos.GrantResponse grant(RpcController controller, AccessControlProtos.GrantRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            if (this.master.cpHost != null && this.hasAccessControlServiceCoprocessor(this.master.cpHost)) {
                UserPermission perm = ShadedAccessControlUtil.toUserPermission(request.getUserPermission());
                boolean mergeExistingPermissions = request.getMergeExistingPermissions();
                this.master.cpHost.preGrant(perm, mergeExistingPermissions);
                try (Table table = this.master.getConnection().getTable(PermissionStorage.ACL_TABLE_NAME);){
                    PermissionStorage.addUserPermission(this.getConfiguration(), perm, table, mergeExistingPermissions);
                }
                this.master.cpHost.postGrant(perm, mergeExistingPermissions);
                User caller = RpcServer.getRequestUser().orElse(null);
                if (AUDITLOG.isTraceEnabled()) {
                    String remoteAddress = RpcServer.getRemoteAddress().map(InetAddress::toString).orElse("");
                    AUDITLOG.trace("User {} (remote address: {}) granted permission {}", new Object[]{caller, remoteAddress, perm});
                }
                return AccessControlProtos.GrantResponse.getDefaultInstance();
            }
            throw new DoNotRetryIOException(new UnsupportedOperationException(AccessController.class.getName() + " is not loaded"));
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public AccessControlProtos.RevokeResponse revoke(RpcController controller, AccessControlProtos.RevokeRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            if (this.master.cpHost != null && this.hasAccessControlServiceCoprocessor(this.master.cpHost)) {
                UserPermission userPermission = ShadedAccessControlUtil.toUserPermission(request.getUserPermission());
                this.master.cpHost.preRevoke(userPermission);
                try (Table table = this.master.getConnection().getTable(PermissionStorage.ACL_TABLE_NAME);){
                    PermissionStorage.removeUserPermission(this.master.getConfiguration(), userPermission, table);
                }
                this.master.cpHost.postRevoke(userPermission);
                User caller = RpcServer.getRequestUser().orElse(null);
                if (AUDITLOG.isTraceEnabled()) {
                    String remoteAddress = RpcServer.getRemoteAddress().map(InetAddress::toString).orElse("");
                    AUDITLOG.trace("User {} (remote address: {}) revoked permission {}", new Object[]{caller, remoteAddress, userPermission});
                }
                return AccessControlProtos.RevokeResponse.getDefaultInstance();
            }
            throw new DoNotRetryIOException(new UnsupportedOperationException(AccessController.class.getName() + " is not loaded"));
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public AccessControlProtos.GetUserPermissionsResponse getUserPermissions(RpcController controller, AccessControlProtos.GetUserPermissionsRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            if (this.master.cpHost != null && this.hasAccessControlServiceCoprocessor(this.master.cpHost)) {
                String userName = request.hasUserName() ? request.getUserName().toStringUtf8() : null;
                String namespace = request.hasNamespaceName() ? request.getNamespaceName().toStringUtf8() : null;
                TableName table = request.hasTableName() ? ProtobufUtil.toTableName(request.getTableName()) : null;
                byte[] cf = request.hasColumnFamily() ? request.getColumnFamily().toByteArray() : null;
                byte[] cq = request.hasColumnQualifier() ? request.getColumnQualifier().toByteArray() : null;
                AccessControlProtos.Permission.Type permissionType = request.hasType() ? request.getType() : null;
                this.master.getMasterCoprocessorHost().preGetUserPermissions(userName, namespace, table, cf, cq);
                List<UserPermission> perms = null;
                if (permissionType == AccessControlProtos.Permission.Type.Table) {
                    boolean filter = cf != null || userName != null;
                    perms = PermissionStorage.getUserTablePermissions(this.master.getConfiguration(), table, cf, cq, userName, filter);
                } else if (permissionType == AccessControlProtos.Permission.Type.Namespace) {
                    perms = PermissionStorage.getUserNamespacePermissions(this.master.getConfiguration(), namespace, userName, userName != null);
                } else {
                    perms = PermissionStorage.getUserPermissions(this.master.getConfiguration(), null, null, null, userName, userName != null);
                    if (userName == null) {
                        for (String user : Superusers.getSuperUsers()) {
                            perms.add(new UserPermission(user, Permission.newBuilder().withActions(Permission.Action.values()).build()));
                        }
                    }
                }
                this.master.getMasterCoprocessorHost().postGetUserPermissions(userName, namespace, table, cf, cq);
                AccessControlProtos.GetUserPermissionsResponse response = ShadedAccessControlUtil.buildGetUserPermissionsResponse(perms);
                return response;
            }
            throw new DoNotRetryIOException(new UnsupportedOperationException(AccessController.class.getName() + " is not loaded"));
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public AccessControlProtos.HasUserPermissionsResponse hasUserPermissions(RpcController controller, AccessControlProtos.HasUserPermissionsRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            if (this.master.cpHost != null && this.hasAccessControlServiceCoprocessor(this.master.cpHost)) {
                User caller = RpcServer.getRequestUser().orElse(null);
                String userName = request.hasUserName() ? request.getUserName().toStringUtf8() : caller.getShortName();
                ArrayList<Permission> permissions = new ArrayList<Permission>();
                for (int i = 0; i < request.getPermissionCount(); ++i) {
                    permissions.add(ShadedAccessControlUtil.toPermission(request.getPermission(i)));
                }
                this.master.getMasterCoprocessorHost().preHasUserPermissions(userName, permissions);
                if (!caller.getShortName().equals(userName)) {
                    List<String> groups = AccessChecker.getUserGroups(userName);
                    caller = new AccessChecker.InputUser(userName, groups.toArray(new String[groups.size()]));
                }
                ArrayList<Boolean> hasUserPermissions = new ArrayList<Boolean>();
                if (this.getAccessChecker() != null) {
                    for (Permission permission : permissions) {
                        boolean hasUserPermission = this.getAccessChecker().hasUserPermission(caller, "hasUserPermissions", permission);
                        hasUserPermissions.add(hasUserPermission);
                    }
                } else {
                    for (int i = 0; i < permissions.size(); ++i) {
                        hasUserPermissions.add(true);
                    }
                }
                this.master.getMasterCoprocessorHost().postHasUserPermissions(userName, permissions);
                AccessControlProtos.HasUserPermissionsResponse.Builder builder = AccessControlProtos.HasUserPermissionsResponse.newBuilder().addAllHasUserPermission(hasUserPermissions);
                return builder.build();
            }
            throw new DoNotRetryIOException(new UnsupportedOperationException(AccessController.class.getName() + " is not loaded"));
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    private boolean containMetaWals(ServerName serverName) throws IOException {
        Path logDir = new Path(this.master.getWALRootDir(), AbstractFSWALProvider.getWALDirectoryName(serverName.toString()));
        Path splitDir = logDir.suffix("-splitting");
        Path checkDir = this.master.getFileSystem().exists(splitDir) ? splitDir : logDir;
        try {
            return this.master.getFileSystem().listStatus(checkDir, MasterWalManager.META_FILTER).length > 0;
        }
        catch (FileNotFoundException fnfe) {
            LOG.warn("No dir for WALs for {}; continuing", (Object)serverName.toString());
            return false;
        }
    }

    private boolean shouldSubmitSCP(ServerName serverName) {
        List<Procedure<MasterProcedureEnv>> procedures = this.master.getMasterProcedureExecutor().getProcedures();
        for (Procedure<MasterProcedureEnv> procedure : procedures) {
            if (!(procedure instanceof ServerCrashProcedure) || serverName.compareTo(((ServerCrashProcedure)procedure).getServerName()) != 0 || procedure.isFinished()) continue;
            LOG.info("there is already a SCP of this server {} running, pid {}", (Object)serverName, (Object)procedure.getProcId());
            return false;
        }
        return true;
    }

    @Override
    public HBaseProtos.LogEntry getLogEntries(RpcController controller, HBaseProtos.LogRequest request) throws ServiceException {
        try {
            String logClassName = request.getLogClassName();
            Class<org.apache.hbase.thirdparty.com.google.protobuf.Message> logClass = Class.forName(logClassName).asSubclass(org.apache.hbase.thirdparty.com.google.protobuf.Message.class);
            Method method = logClass.getMethod("parseFrom", ByteString.class);
            if (logClassName.contains("BalancerDecisionsRequest")) {
                MasterProtos.BalancerDecisionsRequest balancerDecisionsRequest = (MasterProtos.BalancerDecisionsRequest)method.invoke(null, request.getLogMessage());
                MasterProtos.BalancerDecisionsResponse balancerDecisionsResponse = this.getBalancerDecisions(balancerDecisionsRequest);
                return HBaseProtos.LogEntry.newBuilder().setLogClassName(balancerDecisionsResponse.getClass().getName()).setLogMessage(balancerDecisionsResponse.toByteString()).build();
            }
            if (logClassName.contains("BalancerRejectionsRequest")) {
                MasterProtos.BalancerRejectionsRequest balancerRejectionsRequest = (MasterProtos.BalancerRejectionsRequest)method.invoke(null, request.getLogMessage());
                MasterProtos.BalancerRejectionsResponse balancerRejectionsResponse = this.getBalancerRejections(balancerRejectionsRequest);
                return HBaseProtos.LogEntry.newBuilder().setLogClassName(balancerRejectionsResponse.getClass().getName()).setLogMessage(balancerRejectionsResponse.toByteString()).build();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error("Error while retrieving log entries.", (Throwable)e);
            throw new ServiceException(e);
        }
        throw new ServiceException("Invalid request params");
    }

    private MasterProtos.BalancerDecisionsResponse getBalancerDecisions(MasterProtos.BalancerDecisionsRequest request) {
        NamedQueueRecorder namedQueueRecorder = this.regionServer.getNamedQueueRecorder();
        if (namedQueueRecorder == null) {
            return MasterProtos.BalancerDecisionsResponse.newBuilder().addAllBalancerDecision(Collections.emptyList()).build();
        }
        NamedQueueGetRequest namedQueueGetRequest = new NamedQueueGetRequest();
        namedQueueGetRequest.setNamedQueueEvent(1);
        namedQueueGetRequest.setBalancerDecisionsRequest(request);
        NamedQueueGetResponse namedQueueGetResponse = namedQueueRecorder.getNamedQueueRecords(namedQueueGetRequest);
        List<Object> balancerDecisions = namedQueueGetResponse != null ? namedQueueGetResponse.getBalancerDecisions() : Collections.emptyList();
        return MasterProtos.BalancerDecisionsResponse.newBuilder().addAllBalancerDecision(balancerDecisions).build();
    }

    private MasterProtos.BalancerRejectionsResponse getBalancerRejections(MasterProtos.BalancerRejectionsRequest request) {
        NamedQueueRecorder namedQueueRecorder = this.regionServer.getNamedQueueRecorder();
        if (namedQueueRecorder == null) {
            return MasterProtos.BalancerRejectionsResponse.newBuilder().addAllBalancerRejection(Collections.emptyList()).build();
        }
        NamedQueueGetRequest namedQueueGetRequest = new NamedQueueGetRequest();
        namedQueueGetRequest.setNamedQueueEvent(2);
        namedQueueGetRequest.setBalancerRejectionsRequest(request);
        NamedQueueGetResponse namedQueueGetResponse = namedQueueRecorder.getNamedQueueRecords(namedQueueGetRequest);
        List<Object> balancerRejections = namedQueueGetResponse != null ? namedQueueGetResponse.getBalancerRejections() : Collections.emptyList();
        return MasterProtos.BalancerRejectionsResponse.newBuilder().addAllBalancerRejection(balancerRejections).build();
    }

    static enum BalanceSwitchMode {
        SYNC,
        ASYNC;

    }
}

