/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.master.RegionServerList;
import org.apache.hadoop.hbase.master.assignment.ServerState;
import org.apache.hadoop.hbase.master.region.MasterRegion;
import org.apache.hadoop.hbase.master.region.MasterRegionFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MasterRegionServerList
implements RegionServerList {
    private static final Logger LOG = LoggerFactory.getLogger(MasterRegionServerList.class);
    private final MasterRegion region;
    private final Abortable abortable;

    public MasterRegionServerList(MasterRegion region, Abortable abortable) {
        this.region = region;
        this.abortable = abortable;
    }

    @Override
    public void started(ServerName sn) {
        Put put = new Put(Bytes.toBytes(sn.getServerName())).addColumn(MasterRegionFactory.REGION_SERVER_FAMILY, HConstants.STATE_QUALIFIER, Bytes.toBytes(ServerState.ONLINE.name()));
        try {
            this.region.update(r -> r.put(put));
        }
        catch (IOException e) {
            LOG.error(HBaseMarkers.FATAL, "Failed to record region server {} as started, aborting...", (Object)sn, (Object)e);
            this.abortable.abort("Failed to record region server as started");
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void expired(ServerName sn) {
        Delete delete = new Delete(Bytes.toBytes(sn.getServerName())).addFamily(MasterRegionFactory.REGION_SERVER_FAMILY);
        try {
            this.region.update(r -> r.delete(delete));
        }
        catch (IOException e) {
            LOG.error(HBaseMarkers.FATAL, "Failed to record region server {} as expired, aborting...", (Object)sn, (Object)e);
            this.abortable.abort("Failed to record region server as expired");
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Set<ServerName> getAll() throws IOException {
        HashSet<ServerName> rsList = new HashSet<ServerName>();
        try (ResultScanner scanner = this.region.getScanner(new Scan().addFamily(MasterRegionFactory.REGION_SERVER_FAMILY));){
            Result result;
            while ((result = scanner.next()) != null) {
                rsList.add(ServerName.valueOf(Bytes.toString(result.getRow())));
            }
        }
        return rsList;
    }
}

