/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.rep.RestartRequiredException;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.stream.MatchpointSearchResults;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.VLSN;

public class RollbackProhibitedException
extends RestartRequiredException {
    private static final long serialVersionUID = 1L;
    private final MatchpointSearchResults searchResults;

    public RollbackProhibitedException(RepImpl repImpl, int rollbackTxnLimit, boolean rollbackDisabled, VLSN matchpointVLSN, MatchpointSearchResults searchResults) {
        super((EnvironmentImpl)repImpl, EnvironmentFailureReason.ROLLBACK_PROHIBITED, RollbackProhibitedException.makeMessage(repImpl.getName(), searchResults, matchpointVLSN, rollbackTxnLimit, rollbackDisabled));
        this.searchResults = searchResults;
    }

    private static String makeMessage(String nodeName, MatchpointSearchResults searchResults, VLSN matchpointVLSN, int rollbackTxnLimit, boolean rollbackDisabled) {
        long matchpointLSN = searchResults.getMatchpointLSN();
        long fileNumber = DbLsn.getFileNumber(matchpointLSN);
        long fileOffset = DbLsn.getFileOffset(matchpointLSN);
        StringBuilder str = new StringBuilder();
        str.append("Node ").append(nodeName).append(" must rollback ").append(searchResults.getRollbackMsg()).append(" in order to rejoin the replication group, but ");
        if (rollbackDisabled) {
            str.append("rollbacks are disabled because ").append("je.rep.txnRollbackDisabled has been set to true. ").append("Either set je.rep.txnRollbackDisabled to false to ").append("permit automatic rollback,");
        } else {
            str.append(" the transaction rollback limit of ").append(rollbackTxnLimit).append(" prohibits this. ").append("Either increase je.rep.txnRollbackLimit to a ").append("value larger than ").append(rollbackTxnLimit).append(" to permit automatic rollback,");
        }
        str.append(" or manually remove the problematic transactions. ").append("To do manual removal, truncate the log to file ").append(FileManager.getFileName(fileNumber)).append(", offset 0x").append(Long.toHexString(fileOffset)).append(", vlsn ").append(matchpointVLSN).append(" using the directions in ").append("com.sleepycat.je.util.DbTruncateLog.");
        return str.toString();
    }

    public RollbackProhibitedException(String message, RollbackProhibitedException cause) {
        super(message + " " + cause.getMessage(), cause);
        this.searchResults = cause.searchResults;
    }

    @Override
    public RollbackProhibitedException wrapSelf(String msg) {
        return new RollbackProhibitedException(msg, this);
    }

    public long getTruncationFileNumber() {
        return DbLsn.getFileNumber(this.searchResults.getMatchpointLSN());
    }

    public long getTruncationFileOffset() {
        return DbLsn.getFileOffset(this.searchResults.getMatchpointLSN());
    }

    public Long getEarliestTransactionCommitTime() {
        return this.searchResults.getEarliestPassedTxn().time.getTime();
    }

    public long getEarliestTransactionId() {
        return this.searchResults.getEarliestPassedTxn().id;
    }
}

