/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.AbstractTinkerIndex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerElement;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerElementContainer;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerTransactionGraph;

final class TinkerTransactionalIndex<T extends TinkerElement>
extends AbstractTinkerIndex<T> {
    protected Map<String, Map<Object, Set<TinkerElementContainer<T>>>> index = new ConcurrentHashMap<String, Map<Object, Set<TinkerElementContainer<T>>>>();
    protected ThreadLocal<Map<String, Map<Object, Set<T>>>> txIndex = ThreadLocal.withInitial(() -> new ConcurrentHashMap());

    public TinkerTransactionalIndex(TinkerTransactionGraph graph, Class<T> indexClass) {
        super(graph, indexClass);
    }

    private void putTxElement(String key, Object value, T element) {
        Object indexableValue;
        Set<T> objects;
        Map<Object, Set<T>> keyMap;
        Map<String, Map<Object, Set<T>>> index = this.txIndex.get();
        if (index == null) {
            this.txIndex.set(new HashMap());
            index = this.txIndex.get();
        }
        if (null == (keyMap = index.get(key))) {
            index.putIfAbsent(key, new ConcurrentHashMap());
            keyMap = index.get(key);
        }
        if (null == (objects = keyMap.get(indexableValue = TinkerTransactionalIndex.indexable(value)))) {
            keyMap.putIfAbsent(indexableValue, ConcurrentHashMap.newKeySet());
            objects = keyMap.get(indexableValue);
        }
        objects.add(element);
    }

    private List<T> getNotModifiedElements(String key, Object value) {
        Map<Object, Set<TinkerElementContainer<T>>> keyMap = this.index.get(key);
        if (null == keyMap) {
            return new ArrayList();
        }
        Set<TinkerElementContainer<T>> set = keyMap.get(TinkerTransactionalIndex.indexable(value));
        if (null == set) {
            return new ArrayList();
        }
        return set.stream().filter(e -> !e.isChanged() && e.get() != null).map(e -> e.get()).collect(Collectors.toList());
    }

    private Set<T> getModifiedElements(String key, Object value) {
        Map<String, Map<Object, Set<T>>> index = this.txIndex.get();
        if (null == index) {
            return null;
        }
        Map<Object, Set<T>> keyMap = index.get(key);
        if (null == keyMap) {
            return null;
        }
        return keyMap.get(TinkerTransactionalIndex.indexable(value));
    }

    @Override
    public List<T> get(String key, Object value) {
        List notModifiedElements = this.getNotModifiedElements(key, value);
        Set<TinkerElement> modifiedElements = this.getModifiedElements(key, value);
        if (modifiedElements != null) {
            modifiedElements.forEach(e -> {
                if (!notModifiedElements.contains(e)) {
                    notModifiedElements.add(e);
                }
            });
        }
        return notModifiedElements;
    }

    @Override
    public long count(String key, Object value) {
        return this.get(key, value).size();
    }

    @Override
    public void remove(String key, Object value, T element) {
        Set<T> objects;
        Map<String, Map<Object, Set<T>>> index = this.txIndex.get();
        if (null == index) {
            return;
        }
        Map<Object, Set<T>> keyMap = index.get(key);
        if (null != keyMap && null != (objects = keyMap.get(TinkerTransactionalIndex.indexable(value)))) {
            objects.remove(element);
            if (objects.isEmpty()) {
                keyMap.remove(TinkerTransactionalIndex.indexable(value));
            }
        }
    }

    @Override
    public void removeElement(T element) {
        if (this.indexClass.isAssignableFrom(element.getClass())) {
            element.properties(new String[0]).forEachRemaining(p -> {
                if (p.isPresent() && this.indexedKeys.contains(p.key())) {
                    this.remove(p.key(), p.value(), element);
                }
            });
        }
    }

    private void put(String key, Object value, TinkerElementContainer<T> container) {
        Object indexableValue;
        Set<TinkerElementContainer<T>> objects;
        Map<Object, Set<TinkerElementContainer<T>>> keyMap = this.index.get(key);
        if (null == keyMap) {
            this.index.putIfAbsent(key, new ConcurrentHashMap());
            keyMap = this.index.get(key);
        }
        if (null == (objects = keyMap.get(indexableValue = TinkerTransactionalIndex.indexable(value)))) {
            keyMap.putIfAbsent(indexableValue, ConcurrentHashMap.newKeySet());
            objects = keyMap.get(indexableValue);
        }
        objects.add(container);
    }

    private void addContainer(TinkerElementContainer<T> container) {
        T element = container.get();
        if (!this.indexClass.isAssignableFrom(element.getClass()) || !element.properties(new String[0]).hasNext()) {
            return;
        }
        element.properties(new String[0]).forEachRemaining(p -> {
            if (p.isPresent() && this.indexedKeys.contains(p.key())) {
                this.put(p.key(), p.value(), container);
            }
        });
    }

    @Override
    public void autoUpdate(String key, Object newValue, Object oldValue, T element) {
        if (this.indexedKeys.contains(key)) {
            this.remove(key, oldValue, element);
            this.putTxElement(key, newValue, element);
        }
    }

    @Override
    public void createKeyIndex(String key) {
        if (null == key) {
            throw Graph.Exceptions.argumentCanNotBeNull((String)"key");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("The key for the index cannot be an empty string");
        }
        if (this.indexedKeys.contains(key)) {
            return;
        }
        this.indexedKeys.add(key);
        Map<Object, TinkerElementContainer<TinkerElement>> elements = Vertex.class.isAssignableFrom(this.indexClass) ? ((TinkerTransactionGraph)this.graph).vertices : ((TinkerTransactionGraph)this.graph).edges;
        for (TinkerElementContainer<TinkerElement> element : elements.values()) {
            this.addContainer(element);
        }
    }

    @Override
    public void dropKeyIndex(String key) {
        Map<String, Map<Object, Set<T>>> index;
        if (this.index.containsKey(key)) {
            this.index.remove(key).clear();
        }
        if ((index = this.txIndex.get()) != null && index.containsKey(key)) {
            index.remove(key).clear();
        }
        this.indexedKeys.remove(key);
    }

    private void removeContainer(TinkerElementContainer<T> container) {
        T element = container.getUnmodified();
        if (element == null || !this.indexClass.isAssignableFrom(element.getClass()) || !element.properties(new String[0]).hasNext()) {
            return;
        }
        element.properties(new String[0]).forEachRemaining(p -> {
            Set<TinkerElementContainer<T>> objects;
            Map<Object, Set<TinkerElementContainer<T>>> keyMap = this.index.get(p.key());
            Object indexableValue = TinkerTransactionalIndex.indexable(p.value());
            if (null != keyMap && null != (objects = keyMap.get(indexableValue))) {
                objects.remove(container);
                if (objects.isEmpty()) {
                    keyMap.remove(indexableValue);
                }
            }
        });
    }

    public void commit(Set<TinkerElementContainer<T>> updatedElements) {
        for (TinkerElementContainer<T> element : updatedElements) {
            this.removeContainer(element);
            if (element.isDeleted()) continue;
            this.addContainer(element);
        }
        this.txIndex.remove();
    }

    public void rollback() {
        this.txIndex.remove();
    }
}

