/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.data;

import com.datastax.oss.driver.api.core.data.AccessibleByName;
import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.data.CqlVector;
import com.datastax.oss.driver.api.core.data.SettableByIndex;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public interface SettableByName<SelfT extends SettableByName<SelfT>>
extends SettableByIndex<SelfT>,
AccessibleByName {
    @NonNull
    @CheckReturnValue
    default public SelfT setBytesUnsafe(@NonNull String name, @Nullable ByteBuffer v) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setBytesUnsafe(i, v);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @Override
    @NonNull
    default public DataType getType(@NonNull String name) {
        return this.getType(this.firstIndexOf(name));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setToNull(@NonNull String name) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setToNull(i);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public <ValueT> SelfT set(@NonNull String name, @Nullable ValueT v, @NonNull TypeCodec<ValueT> codec) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).set((int)i, v, codec);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public <ValueT> SelfT set(@NonNull String name, @Nullable ValueT v, @NonNull GenericType<ValueT> targetType) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).set((int)i, v, targetType);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public <ValueT> SelfT set(@NonNull String name, @Nullable ValueT v, @NonNull Class<ValueT> targetClass) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).set((int)i, v, targetClass);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setBoolean(@NonNull String name, boolean v) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setBoolean(i, v);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @Deprecated
    @NonNull
    @CheckReturnValue
    default public SelfT setBool(@NonNull String name, boolean v) {
        return this.setBoolean(name, v);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setByte(@NonNull String name, byte v) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setByte(i, v);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setDouble(@NonNull String name, double v) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setDouble(i, v);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setFloat(@NonNull String name, float v) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setFloat(i, v);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setInt(@NonNull String name, int v) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setInt(i, v);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setLong(@NonNull String name, long v) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setLong(i, v);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setShort(@NonNull String name, short v) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setShort(i, v);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setInstant(@NonNull String name, @Nullable Instant v) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setInstant(i, v);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setLocalDate(@NonNull String name, @Nullable LocalDate v) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setLocalDate(i, v);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setLocalTime(@NonNull String name, @Nullable LocalTime v) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setLocalTime(i, v);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setByteBuffer(@NonNull String name, @Nullable ByteBuffer v) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setByteBuffer(i, v);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setString(@NonNull String name, @Nullable String v) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setString(i, v);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setBigInteger(@NonNull String name, @Nullable BigInteger v) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setBigInteger(i, v);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setBigDecimal(@NonNull String name, @Nullable BigDecimal v) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setBigDecimal(i, v);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setUuid(@NonNull String name, @Nullable UUID v) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setUuid(i, v);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setInetAddress(@NonNull String name, @Nullable InetAddress v) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setInetAddress(i, v);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setCqlDuration(@NonNull String name, @Nullable CqlDuration v) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setCqlDuration(i, v);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public <ElementT extends Number> SelfT setVector(@NonNull String name, @Nullable CqlVector<ElementT> v, @NonNull Class<ElementT> elementsClass) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setVector(i, v, elementsClass);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setToken(@NonNull String name, @NonNull Token v) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setToken(i, v);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public <ElementT> SelfT setList(@NonNull String name, @Nullable List<ElementT> v, @NonNull Class<ElementT> elementsClass) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setList(i, v, elementsClass);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public <ElementT> SelfT setSet(@NonNull String name, @Nullable Set<ElementT> v, @NonNull Class<ElementT> elementsClass) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setSet(i, v, elementsClass);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public <KeyT, ValueT> SelfT setMap(@NonNull String name, @Nullable Map<KeyT, ValueT> v, @NonNull Class<KeyT> keyClass, @NonNull Class<ValueT> valueClass) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setMap(i, v, keyClass, valueClass);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setUdtValue(@NonNull String name, @Nullable UdtValue v) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setUdtValue(i, v);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setTupleValue(@NonNull String name, @Nullable TupleValue v) {
        SettableByName result = null;
        for (Integer i : this.allIndicesOf(name)) {
            result = (SettableByName)(result == null ? this : result).setTupleValue(i, v);
        }
        if (!1.$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return (SelfT)result;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

