/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util.ser;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryIo;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryMapper;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.TypeSerializerRegistry;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.CustomTypeSerializer;
import org.apache.tinkerpop.gremlin.util.message.RequestMessage;
import org.apache.tinkerpop.gremlin.util.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.util.ser.AbstractMessageSerializer;
import org.apache.tinkerpop.gremlin.util.ser.MessageTextSerializer;
import org.apache.tinkerpop.gremlin.util.ser.SerializationException;
import org.apache.tinkerpop.gremlin.util.ser.binary.RequestMessageSerializer;
import org.apache.tinkerpop.gremlin.util.ser.binary.ResponseMessageSerializer;
import org.javatuples.Pair;

public class GraphBinaryMessageSerializerV1
extends AbstractMessageSerializer<GraphBinaryMapper>
implements MessageTextSerializer<GraphBinaryMapper> {
    public static final String TOKEN_CUSTOM = "custom";
    public static final String TOKEN_BUILDER = "builder";
    public static final String TOKEN_SERIALIZE_RESULT_TO_STRING = "serializeResultToString";
    private static final String MIME_TYPE = "application/vnd.graphbinary-v1.0";
    private static final String MIME_TYPE_STRINGD = "application/vnd.graphbinary-v1.0-stringd";
    private static final Base64.Encoder base64Encoder = Base64.getEncoder();
    private static final Base64.Decoder base64Decoder = Base64.getDecoder();
    private byte[] header = "application/vnd.graphbinary-v1.0".getBytes(StandardCharsets.UTF_8);
    private boolean serializeToString = false;
    private GraphBinaryReader reader;
    private GraphBinaryWriter writer;
    private RequestMessageSerializer requestSerializer;
    private ResponseMessageSerializer responseSerializer;
    private GraphBinaryMapper mapper;

    public GraphBinaryMessageSerializerV1() {
        this(TypeSerializerRegistry.INSTANCE);
    }

    public GraphBinaryMessageSerializerV1(TypeSerializerRegistry registry) {
        this.reader = new GraphBinaryReader(registry);
        this.writer = new GraphBinaryWriter(registry);
        this.mapper = new GraphBinaryMapper(this.writer, this.reader);
        this.requestSerializer = new RequestMessageSerializer();
        this.responseSerializer = new ResponseMessageSerializer();
    }

    public GraphBinaryMessageSerializerV1(TypeSerializerRegistry.Builder builder) {
        this(builder.create());
    }

    @Override
    public GraphBinaryMapper getMapper() {
        return this.mapper;
    }

    @Override
    public void configure(Map<String, Object> config, Map<String, Graph> graphs) {
        TypeSerializerRegistry.Builder builder;
        String builderClassName = (String)config.get(TOKEN_BUILDER);
        if (builderClassName != null) {
            try {
                Class<?> clazz = Class.forName(builderClassName);
                Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                builder = (TypeSerializerRegistry.Builder)ctor.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        } else {
            builder = TypeSerializerRegistry.build();
        }
        List<String> classNameList = this.getListStringFromConfig("ioRegistries", config);
        classNameList.forEach(className -> {
            try {
                Class<?> clazz = Class.forName(className);
                try {
                    Method instanceMethod = this.tryInstanceMethod(clazz);
                    IoRegistry ioreg = (IoRegistry)instanceMethod.invoke(null, new Object[0]);
                    List classSerializers = ioreg.find(GraphBinaryIo.class, CustomTypeSerializer.class);
                    for (Pair cs : classSerializers) {
                        builder.addCustomType((Class)cs.getValue0(), (CustomTypeSerializer)cs.getValue1());
                    }
                }
                catch (Exception methodex) {
                    throw new IllegalStateException(String.format("Could not instantiate IoRegistry from an instance() method on %s", className), methodex);
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        });
        this.addCustomClasses(config, builder);
        this.serializeToString = Boolean.parseBoolean(config.getOrDefault(TOKEN_SERIALIZE_RESULT_TO_STRING, "false").toString());
        this.header = this.serializeToString ? MIME_TYPE_STRINGD.getBytes(StandardCharsets.UTF_8) : MIME_TYPE.getBytes(StandardCharsets.UTF_8);
        TypeSerializerRegistry registry = builder.create();
        this.reader = new GraphBinaryReader(registry);
        this.writer = new GraphBinaryWriter(registry);
        this.requestSerializer = new RequestMessageSerializer();
        this.responseSerializer = new ResponseMessageSerializer();
    }

    @Override
    public ByteBuf serializeResponseAsBinary(ResponseMessage responseMessage, ByteBufAllocator allocator) throws SerializationException {
        ByteBuf buffer = allocator.buffer();
        try {
            ResponseMessage msgToWrite = !this.serializeToString ? responseMessage : ResponseMessage.build(responseMessage.getRequestId()).code(responseMessage.getStatus().getCode()).statusAttributes(responseMessage.getStatus().getAttributes()).responseMetaData(responseMessage.getResult().getMeta()).result(this.serializeResultToString(responseMessage)).statusMessage(responseMessage.getStatus().getMessage()).create();
            this.responseSerializer.writeValue(msgToWrite, buffer, this.writer);
        }
        catch (Exception ex) {
            buffer.release();
            throw ex;
        }
        return buffer;
    }

    @Override
    public ByteBuf serializeRequestAsBinary(RequestMessage requestMessage, ByteBufAllocator allocator) throws SerializationException {
        ByteBuf buffer = allocator.buffer().writeByte(this.header.length).writeBytes(this.header);
        try {
            this.requestSerializer.writeValue(requestMessage, buffer, this.writer);
        }
        catch (Exception ex) {
            buffer.release();
            throw ex;
        }
        return buffer;
    }

    @Override
    public RequestMessage deserializeRequest(ByteBuf msg) throws SerializationException {
        return this.requestSerializer.readValue(msg, this.reader);
    }

    @Override
    public ResponseMessage deserializeResponse(ByteBuf msg) throws SerializationException {
        return this.responseSerializer.readValue(msg, this.reader);
    }

    @Override
    public String[] mimeTypesSupported() {
        return new String[]{this.serializeToString ? MIME_TYPE_STRINGD : MIME_TYPE};
    }

    @Override
    public String serializeResponseAsString(ResponseMessage responseMessage, ByteBufAllocator allocator) throws SerializationException {
        ByteBuf bb = this.serializeResponseAsBinary(responseMessage, allocator);
        return base64Encoder.encodeToString(this.convertToBytes(bb));
    }

    @Override
    public String serializeRequestAsString(RequestMessage requestMessage, ByteBufAllocator allocator) throws SerializationException {
        ByteBuf bb = this.serializeRequestAsBinary(requestMessage, allocator);
        return base64Encoder.encodeToString(this.convertToBytes(bb));
    }

    @Override
    public RequestMessage deserializeRequest(String msg) throws SerializationException {
        return this.deserializeRequest(this.convertToByteBuf(msg));
    }

    @Override
    public ResponseMessage deserializeResponse(String msg) throws SerializationException {
        return this.deserializeResponse(this.convertToByteBuf(msg));
    }

    private byte[] convertToBytes(ByteBuf bb) {
        byte[] bytes = new byte[bb.readableBytes()];
        bb.getBytes(bb.readerIndex(), bytes);
        return bytes;
    }

    private ByteBuf convertToByteBuf(String msg) {
        byte[] b = base64Decoder.decode(msg);
        ByteBuf bb = Unpooled.buffer((int)b.length);
        bb.writeBytes(b);
        return bb;
    }

    private void addCustomClasses(Map<String, Object> config, TypeSerializerRegistry.Builder builder) {
        List<String> classNameList = this.getListStringFromConfig(TOKEN_CUSTOM, config);
        classNameList.forEach(serializerDefinition -> {
            String[] split;
            if (serializerDefinition.contains(";")) {
                split = serializerDefinition.split(";");
                if (split.length != 2) {
                    throw new IllegalStateException(String.format("Invalid format for serializer definition [%s] - expected <class>;<serializer-class>", serializerDefinition));
                }
            } else {
                throw new IllegalStateException(String.format("Invalid format for serializer definition [%s] - expected <class>;<serializer-class>", serializerDefinition));
            }
            String className = split[0];
            String serializerName = split[1];
            try {
                Class<?> clazz = Class.forName(className);
                Class<?> serializerClazz = Class.forName(serializerName);
                CustomTypeSerializer serializer = (CustomTypeSerializer)serializerClazz.newInstance();
                builder.addCustomType(clazz, serializer);
            }
            catch (Exception ex) {
                throw new IllegalStateException("CustomTypeSerializer could not be instantiated", ex);
            }
        });
    }

    private Object serializeResultToString(ResponseMessage msg) {
        if (msg.getResult() == null) {
            return "null";
        }
        if (msg.getResult().getData() == null) {
            return "null";
        }
        Object o = msg.getResult().getData();
        if (o instanceof Collection) {
            return ((Collection)o).stream().map(d -> null == d ? "null" : d.toString()).collect(Collectors.toList());
        }
        return o.toString();
    }
}

