/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.step;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.collections.iterators.EmptyIterator;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Profiling;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ReducingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.MixedIndexAggQuery;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.graphdb.database.util.IndexRecordUtil;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.query.graph.GraphCentricQuery;
import org.janusgraph.graphdb.query.graph.JointIndexQuery;
import org.janusgraph.graphdb.query.graph.MixedIndexAggQueryBuilder;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.step.Aggregation;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphStep;
import org.janusgraph.graphdb.tinkerpop.profile.TP3ProfileWrapper;
import org.janusgraph.graphdb.types.MixedIndexType;

public class JanusGraphMixedIndexAggStep<S>
extends ReducingBarrierStep<S, Number>
implements Profiling {
    private final ArrayList<HasContainer> hasContainers = new ArrayList();
    private MixedIndexAggQuery mixedIndexAggQuery = null;
    private boolean done;
    private final Aggregation aggregation;

    public JanusGraphMixedIndexAggStep(JanusGraphStep janusGraphStep, Traversal.Admin<?, ?> traversal, Aggregation agg) {
        super(traversal);
        JanusGraphTransaction tx = JanusGraphTraversalUtil.getTx(traversal);
        this.aggregation = agg;
        MixedIndexAggQueryBuilder aggregationQueryBuilder = (MixedIndexAggQueryBuilder)tx.mixedIndexAggQuery();
        GraphCentricQuery query = janusGraphStep.buildGlobalGraphCentricQuery();
        if (query != null && query.getIndexQuery().isFitted()) {
            String fieldName = agg.getFieldName();
            boolean isIndexed = false;
            if (fieldName == null) {
                isIndexed = true;
            } else {
                MixedIndexType indexType = (MixedIndexType)query.getIndexQuery().getBackendQuery().getQuery(0).getIndex();
                Optional<Class> dataType = Arrays.stream(indexType.getFieldKeys()).filter(f -> f.getFieldKey().name().equals(fieldName)).map(f -> f.getFieldKey().dataType()).filter(Number.class::isAssignableFrom).findFirst();
                if (dataType.isPresent()) {
                    isIndexed = true;
                    this.aggregation.setDataType(dataType.get());
                    RelationType rt = tx.getRelationType(fieldName);
                    if (rt instanceof PropertyKey) {
                        this.aggregation.setFieldName(IndexRecordUtil.key2Field(indexType, (PropertyKey)rt));
                    }
                }
            }
            if (isIndexed) {
                JointIndexQuery indexQuery = query.getIndexQuery().getBackendQuery();
                this.mixedIndexAggQuery = aggregationQueryBuilder.constructIndex(indexQuery, Vertex.class.isAssignableFrom(janusGraphStep.getReturnClass()) ? ElementCategory.VERTEX : ElementCategory.EDGE);
            }
        }
    }

    public Number projectTraverser(Traverser.Admin<S> traverser) {
        return traverser.bulk();
    }

    public Traverser.Admin<Number> processNextStart() {
        if (!this.done) {
            this.done = true;
            return this.getTraversal().getTraverserGenerator().generate((Object)this.mixedIndexAggQuery.execute(this.aggregation), (Step)this, 1L);
        }
        return this.getTraversal().getTraverserGenerator().generate(EmptyIterator.INSTANCE.next(), (Step)this, 1L);
    }

    public String toString() {
        if (this.hasContainers.isEmpty()) {
            return super.toString();
        }
        return StringFactory.stepString((Step)this, (Object[])new Object[]{this.hasContainers});
    }

    public void setMetrics(MutableMetrics metrics) {
        TP3ProfileWrapper queryProfiler = new TP3ProfileWrapper(metrics);
        this.mixedIndexAggQuery.observeWith(queryProfiler);
    }

    public MixedIndexAggQuery getMixedIndexAggQuery() {
        return this.mixedIndexAggQuery;
    }
}

