/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.cache;

import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.util.CacheMetricsAction;
import org.janusgraph.graphdb.database.cache.SchemaCache;
import org.janusgraph.graphdb.database.cache.StandardSchemaCache;
import org.janusgraph.graphdb.types.system.BaseRelationType;
import org.janusgraph.util.stats.MetricManager;

public class MetricInstrumentedSchemaCache
implements SchemaCache {
    public static final String METRICS_NAME = "schemacache";
    public static final String METRICS_TYPENAME = "name";
    public static final String METRICS_RELATIONS = "relations";
    private final SchemaCache cache;

    public MetricInstrumentedSchemaCache(final SchemaCache.StoreRetrieval retriever) {
        this.cache = new StandardSchemaCache(new SchemaCache.StoreRetrieval(){

            @Override
            public Long retrieveSchemaByName(String typeName) {
                MetricInstrumentedSchemaCache.this.incAction(MetricInstrumentedSchemaCache.METRICS_TYPENAME, CacheMetricsAction.MISS);
                return retriever.retrieveSchemaByName(typeName);
            }

            @Override
            public EntryList retrieveSchemaRelations(long schemaId, BaseRelationType type, Direction dir) {
                MetricInstrumentedSchemaCache.this.incAction(MetricInstrumentedSchemaCache.METRICS_RELATIONS, CacheMetricsAction.MISS);
                return retriever.retrieveSchemaRelations(schemaId, type, dir);
            }
        });
    }

    private void incAction(String type, CacheMetricsAction action) {
        MetricManager.INSTANCE.getCounter("org.janusgraph.sys", METRICS_NAME, type, action.getName()).inc();
    }

    @Override
    public Long getSchemaId(String schemaName) {
        this.incAction(METRICS_TYPENAME, CacheMetricsAction.RETRIEVAL);
        return this.cache.getSchemaId(schemaName);
    }

    @Override
    public EntryList getSchemaRelations(long schemaId, BaseRelationType type, Direction dir) {
        this.incAction(METRICS_RELATIONS, CacheMetricsAction.RETRIEVAL);
        return this.cache.getSchemaRelations(schemaId, type, dir);
    }

    @Override
    public void expireSchemaElement(long schemaId) {
        this.cache.expireSchemaElement(schemaId);
    }
}

