/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.keycolumnvalue.keyvalue;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.TemporaryBackendException;
import org.janusgraph.diskstorage.keycolumnvalue.KeyIterator;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRangeQuery;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.KeySlicesIterator;
import org.janusgraph.diskstorage.keycolumnvalue.MultiSlicesQuery;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.keycolumnvalue.keyvalue.BaseKeyColumnValueAdapter;
import org.janusgraph.diskstorage.keycolumnvalue.keyvalue.KVQuery;
import org.janusgraph.diskstorage.keycolumnvalue.keyvalue.KeyValueEntry;
import org.janusgraph.diskstorage.keycolumnvalue.keyvalue.OrderedKeyValueStore;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.diskstorage.util.RecordIterator;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.janusgraph.diskstorage.util.StaticArrayEntryList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedKeyValueStoreAdapter
extends BaseKeyColumnValueAdapter {
    private static final Logger log = LoggerFactory.getLogger(OrderedKeyValueStoreAdapter.class);
    public static final int variableKeyLength = 0;
    public static final int maxVariableKeyLength = Short.MAX_VALUE;
    public static final int variableKeyLengthSize = 2;
    private final OrderedKeyValueStore store;
    private final int keyLength;
    private final StaticArrayEntry.GetColVal<KeyValueEntry, StaticBuffer> kvEntryGetter = new StaticArrayEntry.GetColVal<KeyValueEntry, StaticBuffer>(){

        @Override
        public StaticBuffer getColumn(KeyValueEntry element) {
            return OrderedKeyValueStoreAdapter.this.getColumnFromKey(element.getKey());
        }

        @Override
        public StaticBuffer getValue(KeyValueEntry element) {
            return element.getValue();
        }

        @Override
        public EntryMetaData[] getMetaSchema(KeyValueEntry element) {
            return StaticArrayEntry.EMPTY_SCHEMA;
        }

        @Override
        public Object getMetaData(KeyValueEntry element, EntryMetaData meta) {
            throw new UnsupportedOperationException("Unsupported meta data: " + (Object)((Object)meta));
        }
    };

    public OrderedKeyValueStoreAdapter(OrderedKeyValueStore store) {
        this(store, 0);
    }

    public OrderedKeyValueStoreAdapter(OrderedKeyValueStore store, int keyLength) {
        super(store);
        Preconditions.checkNotNull((Object)store);
        Preconditions.checkArgument((keyLength >= 0 ? 1 : 0) != 0);
        this.store = store;
        this.keyLength = keyLength;
        log.debug("Used key length {} for database {}", (Object)keyLength, (Object)store.getName());
    }

    @Override
    public EntryList getSlice(KeySliceQuery query, StoreTransaction txh) throws BackendException {
        return this.convert(this.store.getSlice(this.convertQuery(query), txh));
    }

    @Override
    public Map<StaticBuffer, EntryList> getSlice(List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) throws BackendException {
        ArrayList<KVQuery> queries = new ArrayList<KVQuery>(keys.size());
        for (StaticBuffer key : keys) {
            queries.add(this.convertQuery(new KeySliceQuery(key, query)));
        }
        Map<KVQuery, RecordIterator<KeyValueEntry>> results = this.store.getSlices(queries, txh);
        HashMap<StaticBuffer, EntryList> convertedResults = new HashMap<StaticBuffer, EntryList>(keys.size());
        assert (queries.size() == keys.size());
        for (int i = 0; i < queries.size(); ++i) {
            convertedResults.put(keys.get(i), this.convert(results.get(queries.get(i))));
        }
        return convertedResults;
    }

    @Override
    public void mutate(StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions, StoreTransaction txh) throws BackendException {
        if (!deletions.isEmpty()) {
            for (StaticBuffer deletion : deletions) {
                StaticBuffer del = this.concatenate(key, deletion.as(StaticBuffer.STATIC_FACTORY));
                this.store.delete(del, txh);
            }
        }
        if (!additions.isEmpty()) {
            for (Entry entry : additions) {
                StaticBuffer newKey = this.concatenate(key, entry.getColumnAs(StaticBuffer.STATIC_FACTORY));
                this.store.insert(newKey, entry.getValueAs(StaticBuffer.STATIC_FACTORY), txh, (Integer)entry.getMetaData().get((Object)EntryMetaData.TTL));
            }
        }
    }

    @Override
    public KeyIterator getKeys(KeyRangeQuery keyQuery, StoreTransaction txh) throws BackendException {
        KVQuery query = new KVQuery(this.concatenatePrefix(this.adjustToLength(keyQuery.getKeyStart()), keyQuery.getSliceStart()), this.concatenatePrefix(this.adjustToLength(keyQuery.getKeyEnd()), keyQuery.getSliceEnd()), (Predicate<StaticBuffer>)((Predicate)keycolumn -> {
            StaticBuffer key = this.getKey((StaticBuffer)keycolumn);
            return key.compareTo(keyQuery.getKeyStart()) >= 0 && key.compareTo(keyQuery.getKeyEnd()) < 0 && this.columnInRange((StaticBuffer)keycolumn, keyQuery.getSliceStart(), keyQuery.getSliceEnd());
        }), Integer.MAX_VALUE);
        return new KeyIteratorImpl(keyQuery, this.store.getSlice(query, txh));
    }

    private StaticBuffer adjustToLength(StaticBuffer key) {
        if (this.hasFixedKeyLength() && key.length() != this.keyLength) {
            if (key.length() > this.keyLength) {
                return key.subrange(0, this.keyLength);
            }
            return BufferUtil.padBuffer(key, this.keyLength);
        }
        return key;
    }

    @Override
    public KeyIterator getKeys(SliceQuery columnQuery, StoreTransaction txh) throws BackendException {
        throw new UnsupportedOperationException("This store has ordered keys, use getKeys(KeyRangeQuery, StoreTransaction) instead");
    }

    @Override
    public KeySlicesIterator getKeys(MultiSlicesQuery queries, StoreTransaction txh) throws BackendException {
        throw new UnsupportedOperationException("This store has ordered keys, use getKeys(KeyRangeQuery, StoreTransaction) instead");
    }

    @Override
    public void acquireLock(StaticBuffer key, StaticBuffer column, StaticBuffer expectedValue, StoreTransaction txh) throws BackendException {
        this.store.acquireLock(this.concatenate(key, column), expectedValue, txh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntryList convert(RecordIterator<KeyValueEntry> entries) throws BackendException {
        try {
            EntryList entryList = StaticArrayEntryList.ofStaticBuffer(entries, this.kvEntryGetter);
            return entryList;
        }
        finally {
            try {
                entries.close();
            }
            catch (IOException e) {
                throw new TemporaryBackendException(e);
            }
        }
    }

    private Entry getEntry(KeyValueEntry entry) {
        return StaticArrayEntry.ofStaticBuffer(entry, this.kvEntryGetter);
    }

    private boolean hasFixedKeyLength() {
        return this.keyLength > 0;
    }

    private int getLength(StaticBuffer key) {
        int length = this.keyLength;
        if (this.hasFixedKeyLength()) {
            Preconditions.checkArgument((key.length() == length ? 1 : 0) != 0);
        } else {
            length = key.length();
            Preconditions.checkArgument((length < Short.MAX_VALUE ? 1 : 0) != 0);
        }
        return length;
    }

    final KeyValueEntry concatenate(StaticBuffer front, Entry entry) {
        return new KeyValueEntry(this.concatenate(front, entry.getColumnAs(StaticBuffer.STATIC_FACTORY)), entry.getValueAs(StaticBuffer.STATIC_FACTORY));
    }

    final KVQuery convertQuery(KeySliceQuery query) {
        Predicate filter = Predicates.alwaysTrue();
        if (!this.hasFixedKeyLength()) {
            filter = keyAndColumn -> this.equalKey((StaticBuffer)keyAndColumn, query.getKey());
        }
        return new KVQuery(this.concatenatePrefix(query.getKey(), query.getSliceStart()), this.concatenatePrefix(query.getKey(), query.getSliceEnd()), (Predicate<StaticBuffer>)filter, query.getLimit());
    }

    final StaticBuffer concatenate(StaticBuffer front, StaticBuffer end) {
        return this.concatenate(front, end, true);
    }

    private StaticBuffer concatenatePrefix(StaticBuffer front, StaticBuffer end) {
        return this.concatenate(front, end, false);
    }

    private StaticBuffer concatenate(StaticBuffer front, StaticBuffer end, boolean appendLength) {
        int i;
        boolean addKeyLength = !this.hasFixedKeyLength() && appendLength;
        int length = this.getLength(front);
        byte[] result = new byte[length + end.length() + (addKeyLength ? 2 : 0)];
        int position = 0;
        for (i = 0; i < front.length(); ++i) {
            result[position++] = front.getByte(i);
        }
        for (i = 0; i < end.length(); ++i) {
            result[position++] = end.getByte(i);
        }
        if (addKeyLength) {
            result[position++] = (byte)(length >>> 8);
            result[position] = (byte)length;
        }
        return StaticArrayBuffer.of(result);
    }

    private StaticBuffer getColumnFromKey(StaticBuffer concat) {
        int offset = this.getKeyLength(concat);
        int length = concat.length() - offset;
        if (!this.hasFixedKeyLength()) {
            length -= 2;
        }
        return concat.subrange(offset, length);
    }

    private int getKeyLength(StaticBuffer concat) {
        int length = this.keyLength;
        if (!this.hasFixedKeyLength()) {
            length = concat.getShort(concat.length() - 2);
        }
        return length;
    }

    private StaticBuffer getKey(StaticBuffer concat) {
        return concat.subrange(0, this.getKeyLength(concat));
    }

    private boolean equalKey(StaticBuffer concat, StaticBuffer key) {
        int keyLength = this.getKeyLength(concat);
        for (int i = 0; i < keyLength; ++i) {
            if (concat.getByte(i) == key.getByte(i)) continue;
            return false;
        }
        return true;
    }

    private boolean columnInRange(StaticBuffer concat, StaticBuffer columnStart, StaticBuffer columnEnd) {
        StaticBuffer column = this.getColumnFromKey(concat);
        return column.compareTo(columnStart) >= 0 && column.compareTo(columnEnd) < 0;
    }

    private class KeyIteratorImpl
    implements KeyIterator {
        private final KeyRangeQuery query;
        private final RecordIterator<KeyValueEntry> iterator;
        private StaticBuffer currentKey = null;
        private EntryIterator currentIterator = null;
        private boolean currentKeyReturned = true;
        private KeyValueEntry current;

        private KeyIteratorImpl(KeyRangeQuery query, RecordIterator<KeyValueEntry> iterator) {
            this.query = query;
            this.iterator = iterator;
        }

        private StaticBuffer nextKey() {
            while (this.iterator.hasNext()) {
                this.current = (KeyValueEntry)this.iterator.next();
                StaticBuffer key = OrderedKeyValueStoreAdapter.this.getKey(this.current.getKey());
                if (key.equals(this.currentKey)) continue;
                return key;
            }
            return null;
        }

        private void resetKey(StaticBuffer nextKey) {
            this.currentKey = nextKey;
            this.currentKeyReturned = false;
            if (this.currentIterator != null) {
                this.currentIterator.close();
            }
            this.currentIterator = new EntryIterator();
        }

        @Override
        public RecordIterator<Entry> getEntries() {
            Preconditions.checkNotNull((Object)this.currentIterator);
            return this.currentIterator;
        }

        @Override
        public boolean hasNext() {
            if (this.currentKeyReturned) {
                this.resetKey(this.nextKey());
            }
            return this.currentKey != null;
        }

        @Override
        public StaticBuffer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentKeyReturned = true;
            return this.currentKey;
        }

        @Override
        public void close() throws IOException {
            this.iterator.close();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private class EntryIterator
        implements RecordIterator<Entry>,
        Closeable {
            private boolean open = true;
            private int count = 0;

            private EntryIterator() {
            }

            @Override
            public boolean hasNext() {
                Preconditions.checkState((boolean)this.open);
                if (KeyIteratorImpl.this.current == null) {
                    return false;
                }
                StaticBuffer nextKey = OrderedKeyValueStoreAdapter.this.getKey(KeyIteratorImpl.this.current.getKey());
                if (!nextKey.equals(KeyIteratorImpl.this.currentKey)) {
                    KeyIteratorImpl.this.resetKey(nextKey);
                    return false;
                }
                return this.count < KeyIteratorImpl.this.query.getLimit();
            }

            @Override
            public Entry next() {
                Preconditions.checkState((boolean)this.open);
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Entry kve = OrderedKeyValueStoreAdapter.this.getEntry(KeyIteratorImpl.this.current);
                KeyIteratorImpl.this.current = KeyIteratorImpl.this.iterator.hasNext() ? (KeyValueEntry)KeyIteratorImpl.this.iterator.next() : null;
                ++this.count;
                return kve;
            }

            @Override
            public void close() {
                this.open = false;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

