/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionLoadStats;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.StatisticTrackable;
import org.apache.hadoop.hbase.shaded.com.codahale.metrics.Counter;
import org.apache.hadoop.hbase.shaded.com.codahale.metrics.Histogram;
import org.apache.hadoop.hbase.shaded.com.codahale.metrics.JmxReporter;
import org.apache.hadoop.hbase.shaded.com.codahale.metrics.MetricRegistry;
import org.apache.hadoop.hbase.shaded.com.codahale.metrics.RatioGauge;
import org.apache.hadoop.hbase.shaded.com.codahale.metrics.Timer;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConcurrentMapUtils;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class MetricsConnection
implements StatisticTrackable {
    private static final ConcurrentMap<String, MetricsConnection> METRICS_INSTANCES = new ConcurrentHashMap<String, MetricsConnection>();
    public static final String CLIENT_SIDE_METRICS_ENABLED_KEY = "hbase.client.metrics.enable";
    public static final String METRICS_SCOPE_KEY = "hbase.client.metrics.scope";
    private static final String CNT_BASE = "rpcCount_";
    private static final String FAILURE_CNT_BASE = "rpcFailureCount_";
    private static final String DRTN_BASE = "rpcCallDurationMs_";
    private static final String REQ_BASE = "rpcCallRequestSizeBytes_";
    private static final String RESP_BASE = "rpcCallResponseSizeBytes_";
    private static final String MEMLOAD_BASE = "memstoreLoad_";
    private static final String HEAP_BASE = "heapOccupancy_";
    private static final String CACHE_BASE = "cacheDroppingExceptions_";
    private static final String UNKNOWN_EXCEPTION = "UnknownException";
    private static final String NS_LOOKUPS = "nsLookups";
    private static final String NS_LOOKUPS_FAILED = "nsLookupsFailed";
    private static final String CLIENT_SVC = ClientProtos.ClientService.getDescriptor().getName();
    private ConcurrentHashMap<ServerName, ConcurrentMap<byte[], RegionStats>> serverStats = new ConcurrentHashMap();
    private static final int CAPACITY = 50;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int CONCURRENCY_LEVEL = 256;
    private final MetricRegistry registry;
    private final JmxReporter reporter;
    private final String scope;
    private final NewMetric<Timer> timerFactory = new NewMetric<Timer>(){

        @Override
        public Timer newMetric(Class<?> clazz, String name, String scope) {
            return MetricsConnection.this.registry.timer(MetricRegistry.name(clazz, name, scope));
        }
    };
    private final NewMetric<Histogram> histogramFactory = new NewMetric<Histogram>(){

        @Override
        public Histogram newMetric(Class<?> clazz, String name, String scope) {
            return MetricsConnection.this.registry.histogram(MetricRegistry.name(clazz, name, scope));
        }
    };
    private final NewMetric<Counter> counterFactory = new NewMetric<Counter>(){

        @Override
        public Counter newMetric(Class<?> clazz, String name, String scope) {
            return MetricsConnection.this.registry.counter(MetricRegistry.name(clazz, name, scope));
        }
    };
    private final List<Supplier<ThreadPoolExecutor>> batchPools = new ArrayList<Supplier<ThreadPoolExecutor>>();
    private final List<Supplier<ThreadPoolExecutor>> metaPools = new ArrayList<Supplier<ThreadPoolExecutor>>();
    private final Counter connectionCount;
    private final Counter metaCacheHits;
    private final Counter metaCacheMisses;
    private final CallTracker getTracker;
    private final CallTracker scanTracker;
    private final CallTracker appendTracker;
    private final CallTracker deleteTracker;
    private final CallTracker incrementTracker;
    private final CallTracker putTracker;
    private final CallTracker multiTracker;
    private final RunnerStats runnerStats;
    private final Counter metaCacheNumClearServer;
    private final Counter metaCacheNumClearRegion;
    private final Counter hedgedReadOps;
    private final Counter hedgedReadWin;
    private final Histogram concurrentCallsPerServerHist;
    private final Histogram numActionsPerServerHist;
    private final Counter nsLookups;
    private final Counter nsLookupsFailed;
    private final Timer overloadedBackoffTimer;
    private final ConcurrentMap<String, Timer> rpcTimers = new ConcurrentHashMap<String, Timer>(50, 0.75f, 256);
    private final ConcurrentMap<String, Histogram> rpcHistograms = new ConcurrentHashMap<String, Histogram>(100, 0.75f, 256);
    private final ConcurrentMap<String, Counter> cacheDroppingExceptions = new ConcurrentHashMap<String, Counter>(50, 0.75f, 256);
    private final ConcurrentMap<String, Counter> rpcCounters = new ConcurrentHashMap<String, Counter>(50, 0.75f, 256);

    static MetricsConnection getMetricsConnection(String scope, Supplier<ThreadPoolExecutor> batchPool, Supplier<ThreadPoolExecutor> metaPool) {
        return METRICS_INSTANCES.compute(scope, (s2, metricsConnection) -> {
            if (metricsConnection == null) {
                MetricsConnection newMetricsConn = new MetricsConnection(scope, batchPool, metaPool);
                newMetricsConn.incrConnectionCount();
                return newMetricsConn;
            }
            metricsConnection.addThreadPools(batchPool, metaPool);
            metricsConnection.incrConnectionCount();
            return metricsConnection;
        });
    }

    static void deleteMetricsConnection(String scope) {
        METRICS_INSTANCES.computeIfPresent(scope, (s2, metricsConnection) -> {
            metricsConnection.decrConnectionCount();
            if (metricsConnection.getConnectionCount() == 0L) {
                metricsConnection.shutdown();
                return null;
            }
            return metricsConnection;
        });
    }

    static String getScope(Configuration conf, String clusterId, Object connectionObj) {
        return conf.get(METRICS_SCOPE_KEY, clusterId + "@" + Integer.toHexString(connectionObj.hashCode()));
    }

    public void updateServerStats(ServerName serverName, byte[] regionName, Object r) {
        if (!(r instanceof Result)) {
            return;
        }
        Result result = (Result)r;
        RegionLoadStats stats = result.getStats();
        if (stats == null) {
            return;
        }
        this.updateRegionStats(serverName, regionName, stats);
    }

    @Override
    public void updateRegionStats(ServerName serverName, byte[] regionName, RegionLoadStats stats) {
        String name = serverName.getServerName() + "," + Bytes.toStringBinary(regionName);
        ConcurrentMap rsStats = ConcurrentMapUtils.computeIfAbsent(this.serverStats, serverName, () -> new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR));
        RegionStats regionStats = ConcurrentMapUtils.computeIfAbsent(rsStats, regionName, () -> new RegionStats(this.registry, name));
        regionStats.update(stats);
    }

    private MetricsConnection(String scope, Supplier<ThreadPoolExecutor> batchPool, Supplier<ThreadPoolExecutor> metaPool) {
        this.scope = scope;
        this.addThreadPools(batchPool, metaPool);
        this.registry = new MetricRegistry();
        this.registry.register(this.getExecutorPoolName(), new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                int numerator = 0;
                int denominator = 0;
                for (Supplier poolSupplier : MetricsConnection.this.batchPools) {
                    ThreadPoolExecutor pool = (ThreadPoolExecutor)poolSupplier.get();
                    if (pool == null) continue;
                    int activeCount = pool.getActiveCount();
                    int maxPoolSize = pool.getMaximumPoolSize();
                    if (numerator != 0 && numerator * maxPoolSize >= activeCount * denominator) continue;
                    numerator = activeCount;
                    denominator = maxPoolSize;
                }
                return RatioGauge.Ratio.of(numerator, denominator);
            }
        });
        this.registry.register(this.getMetaPoolName(), new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                int numerator = 0;
                int denominator = 0;
                for (Supplier poolSupplier : MetricsConnection.this.metaPools) {
                    ThreadPoolExecutor pool = (ThreadPoolExecutor)poolSupplier.get();
                    if (pool == null) continue;
                    int activeCount = pool.getActiveCount();
                    int maxPoolSize = pool.getMaximumPoolSize();
                    if (numerator != 0 && numerator * maxPoolSize >= activeCount * denominator) continue;
                    numerator = activeCount;
                    denominator = maxPoolSize;
                }
                return RatioGauge.Ratio.of(numerator, denominator);
            }
        });
        this.connectionCount = this.registry.counter(MetricRegistry.name(this.getClass(), "connectionCount", scope));
        this.metaCacheHits = this.registry.counter(MetricRegistry.name(this.getClass(), "metaCacheHits", scope));
        this.metaCacheMisses = this.registry.counter(MetricRegistry.name(this.getClass(), "metaCacheMisses", scope));
        this.metaCacheNumClearServer = this.registry.counter(MetricRegistry.name(this.getClass(), "metaCacheNumClearServer", scope));
        this.metaCacheNumClearRegion = this.registry.counter(MetricRegistry.name(this.getClass(), "metaCacheNumClearRegion", scope));
        this.hedgedReadOps = this.registry.counter(MetricRegistry.name(this.getClass(), "hedgedReadOps", scope));
        this.hedgedReadWin = this.registry.counter(MetricRegistry.name(this.getClass(), "hedgedReadWin", scope));
        this.getTracker = new CallTracker(this.registry, "Get", scope);
        this.scanTracker = new CallTracker(this.registry, "Scan", scope);
        this.appendTracker = new CallTracker(this.registry, "Mutate", "Append", scope);
        this.deleteTracker = new CallTracker(this.registry, "Mutate", "Delete", scope);
        this.incrementTracker = new CallTracker(this.registry, "Mutate", "Increment", scope);
        this.putTracker = new CallTracker(this.registry, "Mutate", "Put", scope);
        this.multiTracker = new CallTracker(this.registry, "Multi", scope);
        this.runnerStats = new RunnerStats(this.registry);
        this.concurrentCallsPerServerHist = this.registry.histogram(MetricRegistry.name(MetricsConnection.class, "concurrentCallsPerServer", scope));
        this.numActionsPerServerHist = this.registry.histogram(MetricRegistry.name(MetricsConnection.class, "numActionsPerServer", scope));
        this.nsLookups = this.registry.counter(MetricRegistry.name(this.getClass(), NS_LOOKUPS, scope));
        this.nsLookupsFailed = this.registry.counter(MetricRegistry.name(this.getClass(), NS_LOOKUPS_FAILED, scope));
        this.overloadedBackoffTimer = this.registry.timer(MetricRegistry.name(this.getClass(), "overloadedBackoffDurationMs", scope));
        this.reporter = JmxReporter.forRegistry(this.registry).build();
        this.reporter.start();
    }

    final String getExecutorPoolName() {
        return MetricRegistry.name(this.getClass(), "executorPoolActiveThreads", this.scope);
    }

    final String getMetaPoolName() {
        return MetricRegistry.name(this.getClass(), "metaPoolActiveThreads", this.scope);
    }

    MetricRegistry getMetricRegistry() {
        return this.registry;
    }

    public String getMetricScope() {
        return this.scope;
    }

    public ConcurrentHashMap<ServerName, ConcurrentMap<byte[], RegionStats>> getServerStats() {
        return this.serverStats;
    }

    public RunnerStats getRunnerStats() {
        return this.runnerStats;
    }

    public Counter getMetaCacheNumClearServer() {
        return this.metaCacheNumClearServer;
    }

    public Counter getMetaCacheNumClearRegion() {
        return this.metaCacheNumClearRegion;
    }

    public Counter getHedgedReadOps() {
        return this.hedgedReadOps;
    }

    public Counter getHedgedReadWin() {
        return this.hedgedReadWin;
    }

    public Histogram getNumActionsPerServerHist() {
        return this.numActionsPerServerHist;
    }

    public ConcurrentMap<String, Counter> getRpcCounters() {
        return this.rpcCounters;
    }

    public CallTracker getGetTracker() {
        return this.getTracker;
    }

    public CallTracker getScanTracker() {
        return this.scanTracker;
    }

    public CallTracker getMultiTracker() {
        return this.multiTracker;
    }

    public CallTracker getAppendTracker() {
        return this.appendTracker;
    }

    public CallTracker getDeleteTracker() {
        return this.deleteTracker;
    }

    public CallTracker getIncrementTracker() {
        return this.incrementTracker;
    }

    public CallTracker getPutTracker() {
        return this.putTracker;
    }

    public static CallStats newCallStats() {
        return new CallStats();
    }

    public void incrMetaCacheHit() {
        this.metaCacheHits.inc();
    }

    public void incrMetaCacheMiss() {
        this.metaCacheMisses.inc();
    }

    public void incrMetaCacheNumClearServer() {
        this.metaCacheNumClearServer.inc();
    }

    public void incrMetaCacheNumClearRegion() {
        this.metaCacheNumClearRegion.inc();
    }

    public void incrMetaCacheNumClearRegion(int count) {
        this.metaCacheNumClearRegion.inc(count);
    }

    public void incrHedgedReadOps() {
        this.hedgedReadOps.inc();
    }

    public void incrHedgedReadWin() {
        this.hedgedReadWin.inc();
    }

    public void incrNormalRunners() {
        this.runnerStats.incrNormalRunners();
    }

    public void incrDelayRunnersAndUpdateDelayInterval(long interval) {
        this.runnerStats.incrDelayRunners();
        this.runnerStats.updateDelayInterval(interval);
    }

    public void incrementServerOverloadedBackoffTime(long time, TimeUnit timeUnit) {
        this.overloadedBackoffTimer.update(time, timeUnit);
    }

    public long getConnectionCount() {
        return this.connectionCount.getCount();
    }

    private void incrConnectionCount() {
        this.connectionCount.inc();
    }

    private void decrConnectionCount() {
        this.connectionCount.dec();
    }

    private void addThreadPools(Supplier<ThreadPoolExecutor> batchPool, Supplier<ThreadPoolExecutor> metaPool) {
        this.batchPools.add(batchPool);
        this.metaPools.add(metaPool);
    }

    private <T> T getMetric(String key, ConcurrentMap<String, T> map, NewMetric<T> factory) {
        return (T)ConcurrentMapUtils.computeIfAbsent(map, key, () -> factory.newMetric(this.getClass(), key, this.scope));
    }

    private void updateRpcGeneric(String methodName, CallStats stats) {
        this.getMetric(DRTN_BASE + methodName, this.rpcTimers, this.timerFactory).update(stats.getCallTimeMs(), TimeUnit.MILLISECONDS);
        this.getMetric(REQ_BASE + methodName, this.rpcHistograms, this.histogramFactory).update(stats.getRequestSizeBytes());
        this.getMetric(RESP_BASE + methodName, this.rpcHistograms, this.histogramFactory).update(stats.getResponseSizeBytes());
    }

    private void shutdown() {
        this.reporter.stop();
    }

    public void updateRpc(Descriptors.MethodDescriptor method, Message param, CallStats stats, boolean failed) {
        int callsPerServer = stats.getConcurrentCallsPerServer();
        if (callsPerServer > 0) {
            this.concurrentCallsPerServerHist.update(callsPerServer);
        }
        String methodName = method.getService().getName() + "_" + method.getName();
        this.getMetric(CNT_BASE + methodName, this.rpcCounters, this.counterFactory).inc();
        if (failed) {
            this.getMetric(FAILURE_CNT_BASE + methodName, this.rpcCounters, this.counterFactory).inc();
        }
        if (method.getService() == ClientProtos.ClientService.getDescriptor()) {
            switch (method.getIndex()) {
                case 0: {
                    assert ("Get".equals(method.getName()));
                    this.getTracker.updateRpc(stats);
                    return;
                }
                case 1: {
                    assert ("Mutate".equals(method.getName()));
                    ClientProtos.MutationProto.MutationType mutationType = ((ClientProtos.MutateRequest)param).getMutation().getMutateType();
                    switch (mutationType) {
                        case APPEND: {
                            this.appendTracker.updateRpc(stats);
                            return;
                        }
                        case DELETE: {
                            this.deleteTracker.updateRpc(stats);
                            return;
                        }
                        case INCREMENT: {
                            this.incrementTracker.updateRpc(stats);
                            return;
                        }
                        case PUT: {
                            this.putTracker.updateRpc(stats);
                            return;
                        }
                    }
                    throw new RuntimeException("Unrecognized mutation type " + mutationType);
                }
                case 2: {
                    assert ("Scan".equals(method.getName()));
                    this.scanTracker.updateRpc(stats);
                    return;
                }
                case 3: {
                    assert ("BulkLoadHFile".equals(method.getName()));
                    break;
                }
                case 4: {
                    assert ("PrepareBulkLoad".equals(method.getName()));
                    break;
                }
                case 5: {
                    assert ("CleanupBulkLoad".equals(method.getName()));
                    break;
                }
                case 6: {
                    assert ("ExecService".equals(method.getName()));
                    break;
                }
                case 7: {
                    assert ("ExecRegionServerService".equals(method.getName()));
                    break;
                }
                case 8: {
                    assert ("Multi".equals(method.getName()));
                    this.numActionsPerServerHist.update(stats.getNumActionsPerServer());
                    this.multiTracker.updateRpc(stats);
                    return;
                }
                default: {
                    throw new RuntimeException("Unrecognized ClientService RPC type " + method.getFullName());
                }
            }
        }
        this.updateRpcGeneric(methodName, stats);
    }

    public void incrCacheDroppingExceptions(Object exception) {
        this.getMetric(CACHE_BASE + (exception == null ? UNKNOWN_EXCEPTION : exception.getClass().getSimpleName()), this.cacheDroppingExceptions, this.counterFactory).inc();
    }

    public void incrNsLookups() {
        this.nsLookups.inc();
    }

    public void incrNsLookupsFailed() {
        this.nsLookupsFailed.inc();
    }

    private static interface NewMetric<T> {
        public T newMetric(Class<?> var1, String var2, String var3);
    }

    protected static class RunnerStats {
        final Counter normalRunners;
        final Counter delayRunners;
        final Histogram delayIntevalHist;

        public RunnerStats(MetricRegistry registry) {
            this.normalRunners = registry.counter(MetricRegistry.name(MetricsConnection.class, "normalRunnersCount"));
            this.delayRunners = registry.counter(MetricRegistry.name(MetricsConnection.class, "delayRunnersCount"));
            this.delayIntevalHist = registry.histogram(MetricRegistry.name(MetricsConnection.class, "delayIntervalHist"));
        }

        public void incrNormalRunners() {
            this.normalRunners.inc();
        }

        public void incrDelayRunners() {
            this.delayRunners.inc();
        }

        public void updateDelayInterval(long interval) {
            this.delayIntevalHist.update(interval);
        }
    }

    protected static class RegionStats {
        final String name;
        final Histogram memstoreLoadHist;
        final Histogram heapOccupancyHist;

        public RegionStats(MetricRegistry registry, String name) {
            this.name = name;
            this.memstoreLoadHist = registry.histogram(MetricRegistry.name(MetricsConnection.class, MetricsConnection.MEMLOAD_BASE + this.name));
            this.heapOccupancyHist = registry.histogram(MetricRegistry.name(MetricsConnection.class, MetricsConnection.HEAP_BASE + this.name));
        }

        public void update(RegionLoadStats regionStatistics) {
            this.memstoreLoadHist.update(regionStatistics.getMemStoreLoad());
            this.heapOccupancyHist.update(regionStatistics.getHeapOccupancy());
        }
    }

    protected static final class CallTracker {
        private final String name;
        final Timer callTimer;
        final Histogram reqHist;
        final Histogram respHist;

        private CallTracker(MetricRegistry registry, String name, String subName, String scope) {
            StringBuilder sb = new StringBuilder(CLIENT_SVC).append("_").append(name);
            if (subName != null) {
                sb.append("(").append(subName).append(")");
            }
            this.name = sb.toString();
            this.callTimer = registry.timer(MetricRegistry.name(MetricsConnection.class, MetricsConnection.DRTN_BASE + this.name, scope));
            this.reqHist = registry.histogram(MetricRegistry.name(MetricsConnection.class, MetricsConnection.REQ_BASE + this.name, scope));
            this.respHist = registry.histogram(MetricRegistry.name(MetricsConnection.class, MetricsConnection.RESP_BASE + this.name, scope));
        }

        private CallTracker(MetricRegistry registry, String name, String scope) {
            this(registry, name, null, scope);
        }

        public void updateRpc(CallStats stats) {
            this.callTimer.update(stats.getCallTimeMs(), TimeUnit.MILLISECONDS);
            this.reqHist.update(stats.getRequestSizeBytes());
            this.respHist.update(stats.getResponseSizeBytes());
        }

        public String toString() {
            return "CallTracker:" + this.name;
        }
    }

    public static class CallStats {
        private long requestSizeBytes = 0L;
        private long responseSizeBytes = 0L;
        private long startTime = 0L;
        private long callTimeMs = 0L;
        private int concurrentCallsPerServer = 0;
        private int numActionsPerServer = 0;

        public long getRequestSizeBytes() {
            return this.requestSizeBytes;
        }

        public void setRequestSizeBytes(long requestSizeBytes) {
            this.requestSizeBytes = requestSizeBytes;
        }

        public long getResponseSizeBytes() {
            return this.responseSizeBytes;
        }

        public void setResponseSizeBytes(long responseSizeBytes) {
            this.responseSizeBytes = responseSizeBytes;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public long getCallTimeMs() {
            return this.callTimeMs;
        }

        public void setCallTimeMs(long callTimeMs) {
            this.callTimeMs = callTimeMs;
        }

        public int getConcurrentCallsPerServer() {
            return this.concurrentCallsPerServer;
        }

        public void setConcurrentCallsPerServer(int callsPerServer) {
            this.concurrentCallsPerServer = callsPerServer;
        }

        public int getNumActionsPerServer() {
            return this.numActionsPerServer;
        }

        public void setNumActionsPerServer(int numActionsPerServer) {
            this.numActionsPerServer = numActionsPerServer;
        }
    }
}

