/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.cleaner.DbFileSummary;
import com.sleepycat.je.cleaner.DbFileSummaryMap;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.utilint.DbLsn;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseUtilizationTracker {
    EnvironmentImpl env;
    Cleaner cleaner;
    private long activeFile;
    private volatile Map<Long, TrackedFileSummary> fileSummaries;

    BaseUtilizationTracker(EnvironmentImpl env) {
        this(env, env.getCleaner());
    }

    BaseUtilizationTracker(EnvironmentImpl env, Cleaner cleaner) {
        assert (cleaner != null);
        this.env = env;
        this.cleaner = cleaner;
        this.fileSummaries = Collections.emptyMap();
        this.activeFile = -1L;
    }

    public EnvironmentImpl getEnvironment() {
        return this.env;
    }

    public Collection<TrackedFileSummary> getTrackedFiles() {
        return this.fileSummaries.values();
    }

    public TrackedFileSummary getTrackedFile(long fileNum) {
        return this.fileSummaries.get(fileNum);
    }

    final void countNew(long lsn, LogEntryType type, int size) {
        assert (type != null);
        long fileNum = DbLsn.getFileNumber(lsn);
        TrackedFileSummary fileSummary = this.getFileSummary(fileNum);
        ++fileSummary.totalCount;
        fileSummary.totalSize += size;
        boolean isLN = BaseUtilizationTracker.isLNType(type);
        if (isLN && fileSummary.maxLNSize < size) {
            fileSummary.maxLNSize = size;
        }
        if (BaseUtilizationTracker.trackObsoleteInfo(type)) {
            if (isLN) {
                ++fileSummary.totalLNCount;
                fileSummary.totalLNSize += size;
            } else {
                ++fileSummary.totalINCount;
                fileSummary.totalINSize += size;
            }
        }
    }

    final void countObsolete(long lsn, LogEntryType type, int size, boolean trackOffset, boolean checkDupOffsets) {
        long offset;
        assert (BaseUtilizationTracker.trackObsoleteInfo(type));
        boolean isLN = BaseUtilizationTracker.isLNType(type);
        long fileNum = DbLsn.getFileNumber(lsn);
        TrackedFileSummary fileSummary = this.getFileSummary(fileNum);
        if (isLN) {
            ++fileSummary.obsoleteLNCount;
            if (size > 0) {
                fileSummary.obsoleteLNSize += size;
                ++fileSummary.obsoleteLNSizeCounted;
            }
        } else {
            ++fileSummary.obsoleteINCount;
            assert (size == 0);
        }
        if (trackOffset && (offset = DbLsn.getFileOffset(lsn)) != 0L) {
            fileSummary.trackObsolete(offset, checkDupOffsets);
        }
    }

    boolean isFileUncounted(Long fileNum, long lsn) {
        return true;
    }

    public void transferToUtilizationTracker(UtilizationTracker tracker) throws DatabaseException {
        for (TrackedFileSummary localSummary : this.getTrackedFiles()) {
            TrackedFileSummary fileSummary = tracker.getFileSummary(localSummary.getFileNumber());
            fileSummary.addTrackedSummary(localSummary);
        }
    }

    public void countObsoleteDb(DbFileSummaryMap dbFileSummaries, long mapLnLsn) {
        for (Map.Entry<Long, DbFileSummary> entry : dbFileSummaries.entrySet()) {
            Long fileNum = entry.getKey();
            if (!this.isFileUncounted(fileNum, mapLnLsn)) continue;
            DbFileSummary dbFileSummary = entry.getValue();
            TrackedFileSummary fileSummary = this.getFileSummary(fileNum);
            int lnObsoleteCount = dbFileSummary.totalLNCount - dbFileSummary.obsoleteLNCount;
            int lnObsoleteSize = dbFileSummary.totalLNSize - dbFileSummary.obsoleteLNSize;
            int inObsoleteCount = dbFileSummary.totalINCount - dbFileSummary.obsoleteINCount;
            fileSummary.obsoleteLNCount += lnObsoleteCount;
            fileSummary.obsoleteLNSize += lnObsoleteSize;
            fileSummary.obsoleteINCount += inObsoleteCount;
            int lnObsoleteSizeCounted = lnObsoleteCount + (dbFileSummary.obsoleteLNCount - dbFileSummary.obsoleteLNSizeCounted);
            fileSummary.obsoleteLNSizeCounted += lnObsoleteSizeCounted;
        }
    }

    boolean isEmpty() {
        return this.fileSummaries.isEmpty();
    }

    TrackedFileSummary getFileSummary(long fileNum) {
        Long fileNumLong;
        TrackedFileSummary file;
        if (this.activeFile < fileNum) {
            this.activeFile = fileNum;
        }
        if ((file = this.fileSummaries.get(fileNumLong = Long.valueOf(fileNum))) == null) {
            file = new TrackedFileSummary(this, fileNum, this.cleaner.trackDetail);
            HashMap<Long, TrackedFileSummary> newFiles = new HashMap<Long, TrackedFileSummary>(this.fileSummaries);
            newFiles.put(fileNumLong, file);
            this.fileSummaries = newFiles;
        }
        return file;
    }

    void resetFile(TrackedFileSummary fileSummary) {
        if (fileSummary.getFileNumber() < this.activeFile && fileSummary.getAllowFlush()) {
            HashMap<Long, TrackedFileSummary> newFiles = new HashMap<Long, TrackedFileSummary>(this.fileSummaries);
            newFiles.remove(fileSummary.getFileNumber());
            this.fileSummaries = newFiles;
        }
    }

    public static boolean trackObsoleteInfo(LogEntryType type) {
        return type == null || type.isNodeType() || type.equals(LogEntryType.LOG_BIN_DELTA) || type.equals(LogEntryType.LOG_OLD_BIN_DELTA);
    }

    public static boolean isLNType(LogEntryType type) {
        return type == null || type.isLNType();
    }

    void close() {
        for (TrackedFileSummary t : this.fileSummaries.values()) {
            t.close();
        }
    }
}

