/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.AbstractTinkerGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerEdge;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerElement;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerHelper;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerIndexHelper;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerTransactionGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerVertexProperty;
import org.apache.tinkerpop.gremlin.util.CollectionUtil;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class TinkerVertex
extends TinkerElement
implements Vertex {
    protected Map<String, List<VertexProperty>> properties;
    protected Map<String, Set<Edge>> outEdges;
    protected Map<String, Set<Edge>> inEdges;
    protected Map<String, Set<Object>> outEdgesId;
    protected Map<String, Set<Object>> inEdgesId;
    private final AbstractTinkerGraph graph;
    private boolean allowNullPropertyValues;
    private final boolean isTxMode;

    protected TinkerVertex(Object id, String label, AbstractTinkerGraph graph) {
        super(id, label);
        this.graph = graph;
        this.isTxMode = graph instanceof TinkerTransactionGraph;
        this.allowNullPropertyValues = graph.features().vertex().supportsNullPropertyValues();
    }

    protected TinkerVertex(Object id, String label, AbstractTinkerGraph graph, long currentVersion) {
        super(id, label, currentVersion);
        this.graph = graph;
        this.isTxMode = graph instanceof TinkerTransactionGraph;
        this.allowNullPropertyValues = graph.features().vertex().supportsNullPropertyValues();
    }

    @Override
    public Object clone() {
        if (!this.isTxMode) {
            TinkerVertex vertex = new TinkerVertex(this.id, this.label, this.graph, this.currentVersion);
            vertex.inEdgesId = this.inEdgesId;
            vertex.outEdgesId = this.outEdgesId;
            vertex.properties = this.properties;
            return vertex;
        }
        TinkerVertex vertex = new TinkerVertex(this.id, this.label, this.graph, this.currentVersion);
        if (this.inEdgesId != null) {
            vertex.inEdgesId = CollectionUtil.clone((ConcurrentHashMap)((ConcurrentHashMap)this.inEdgesId));
        }
        if (this.outEdgesId != null) {
            vertex.outEdgesId = CollectionUtil.clone((ConcurrentHashMap)((ConcurrentHashMap)this.outEdgesId));
        }
        if (this.properties != null) {
            ConcurrentHashMap<String, List<VertexProperty>> result = new ConcurrentHashMap<String, List<VertexProperty>>(this.properties.size());
            for (Map.Entry<String, List<VertexProperty>> entry : this.properties.entrySet()) {
                List clonedValue = entry.getValue().stream().map(vp -> ((TinkerVertexProperty)vp).copy(vertex)).collect(Collectors.toList());
                result.put(entry.getKey(), clonedValue);
            }
            vertex.properties = result;
        }
        return vertex;
    }

    public Graph graph() {
        return this.graph;
    }

    public <V> VertexProperty<V> property(String key) {
        if (this.removed) {
            return VertexProperty.empty();
        }
        if (TinkerHelper.inComputerMode(this.graph)) {
            List<VertexProperty<?>> list = this.graph.graphComputerView.getProperty(this, key);
            if (list.size() == 0) {
                return VertexProperty.empty();
            }
            if (list.size() == 1) {
                return list.get(0);
            }
            throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey((String)key);
        }
        if (this.properties != null && this.properties.containsKey(key)) {
            List<VertexProperty> list = this.properties.get(key);
            if (list.size() > 1) {
                throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey((String)key);
            }
            return list.get(0);
        }
        return VertexProperty.empty();
    }

    public <V> VertexProperty<V> property(VertexProperty.Cardinality cardinality, String key, V value, Object ... keyValues) {
        this.graph.touch(this);
        if (this.removed) {
            throw TinkerVertex.elementAlreadyRemoved(Vertex.class, this.id);
        }
        ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        ElementHelper.validateProperty((String)key, value);
        if (!this.allowNullPropertyValues && null == value) {
            VertexProperty.Cardinality card;
            VertexProperty.Cardinality cardinality2 = card = null == cardinality ? this.graph.features().vertex().getCardinality(key) : cardinality;
            if (VertexProperty.Cardinality.single == card) {
                this.properties(key).forEachRemaining(Property::remove);
            }
            return VertexProperty.empty();
        }
        Optional optionalId = ElementHelper.getIdValue((Object[])keyValues);
        Optional optionalVertexProperty = ElementHelper.stageVertexProperty((Vertex)this, (VertexProperty.Cardinality)cardinality, (String)key, value, (Object[])keyValues);
        if (optionalVertexProperty.isPresent()) {
            return (VertexProperty)optionalVertexProperty.get();
        }
        if (TinkerHelper.inComputerMode(this.graph)) {
            VertexProperty vertexProperty = (VertexProperty)this.graph.graphComputerView.addProperty(this, key, value);
            ElementHelper.attachProperties((Element)vertexProperty, (Object[])keyValues);
            return vertexProperty;
        }
        VertexProperty idValue = optionalId.isPresent() ? this.graph.vertexPropertyIdManager.convert(optionalId.get()) : this.graph.vertexPropertyIdManager.getNextId(this.graph);
        TinkerVertexProperty<V> vertexProperty = new TinkerVertexProperty<V>(idValue, this, key, value, new Object[0]);
        if (null == this.properties) {
            this.properties = new ConcurrentHashMap<String, List<VertexProperty>>();
        }
        List list = this.properties.getOrDefault(key, new ArrayList());
        list.add(vertexProperty);
        this.properties.put(key, list);
        TinkerIndexHelper.autoUpdateIndex(this, key, value, null);
        ElementHelper.attachProperties(vertexProperty, (Object[])keyValues);
        return vertexProperty;
    }

    public Set<String> keys() {
        if (null == this.properties) {
            return Collections.emptySet();
        }
        return TinkerHelper.inComputerMode((AbstractTinkerGraph)this.graph()) ? super.keys() : this.properties.keySet();
    }

    public Edge addEdge(String label, Vertex vertex, Object ... keyValues) {
        if (null == vertex) {
            throw Graph.Exceptions.argumentCanNotBeNull((String)"vertex");
        }
        if (this.removed || ((TinkerVertex)vertex).removed) {
            throw TinkerVertex.elementAlreadyRemoved(Vertex.class, this.id);
        }
        return this.graph.addEdge(this, (TinkerVertex)vertex, label, keyValues);
    }

    public void remove() {
        this.graph.touch(this);
        ArrayList edges = new ArrayList();
        this.edges(Direction.BOTH, new String[0]).forEachRemaining(edge -> edges.add(edge));
        edges.stream().filter(edge -> !((TinkerEdge)edge).removed).forEach(Element::remove);
        TinkerIndexHelper.removeElementIndex(this);
        this.properties = null;
        this.graph.removeVertex(this.id);
        this.removed = true;
    }

    public String toString() {
        return StringFactory.vertexString((Vertex)this);
    }

    public Iterator<Edge> edges(Direction direction, String ... edgeLabels) {
        Iterator<Object> edgeIterator = this.isTxMode ? TinkerHelper.getEdgesTx(this, direction, edgeLabels) : TinkerHelper.getEdges(this, direction, edgeLabels);
        return TinkerHelper.inComputerMode(this.graph) ? IteratorUtils.filter(edgeIterator, edge -> this.graph.graphComputerView.legalEdge(this, (Edge)edge)) : edgeIterator;
    }

    public Iterator<Vertex> vertices(Direction direction, String ... edgeLabels) {
        if (TinkerHelper.inComputerMode(this.graph)) {
            return direction.equals((Object)Direction.BOTH) ? IteratorUtils.concat((Iterator[])new Iterator[]{IteratorUtils.map(this.edges(Direction.OUT, edgeLabels), Edge::inVertex), IteratorUtils.map(this.edges(Direction.IN, edgeLabels), Edge::outVertex)}) : IteratorUtils.map(this.edges(direction, edgeLabels), edge -> (Vertex)edge.vertices(direction.opposite()).next());
        }
        return this.isTxMode ? TinkerHelper.getVerticesTx(this, direction, edgeLabels) : TinkerHelper.getVertices(this, direction, edgeLabels);
    }

    public <V> Iterator<VertexProperty<V>> properties(String ... propertyKeys) {
        if (this.removed) {
            return Collections.emptyIterator();
        }
        if (TinkerHelper.inComputerMode((AbstractTinkerGraph)this.graph())) {
            return ((AbstractTinkerGraph)this.graph()).graphComputerView.getProperties(this).stream().filter(p -> ElementHelper.keyExists((String)p.key(), (String[])propertyKeys)).iterator();
        }
        if (null == this.properties) {
            return Collections.emptyIterator();
        }
        if (propertyKeys.length == 1) {
            if (null == propertyKeys[0]) {
                return Collections.emptyIterator();
            }
            List properties = this.properties.getOrDefault(propertyKeys[0], Collections.emptyList());
            if (properties.size() == 1) {
                return IteratorUtils.of((Object)((VertexProperty)properties.get(0)));
            }
            if (properties.isEmpty()) {
                return Collections.emptyIterator();
            }
            return new ArrayList(properties).iterator();
        }
        return this.properties.entrySet().stream().filter(entry -> ElementHelper.keyExists((String)((String)entry.getKey()), (String[])propertyKeys)).flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toList()).iterator();
    }
}

