/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.step.fetcher;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraphMultiVertexQuery;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.graphdb.query.vertex.BasicVertexCentricQueryUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.step.fetcher.FetchQueryBuildFunction;
import org.janusgraph.graphdb.tinkerpop.optimize.step.fetcher.MultiQueriableStepBatchFetcher;

public class LabelStepBatchFetcher
extends MultiQueriableStepBatchFetcher<String> {
    private final FetchQueryBuildFunction fetchQueryBuildFunction;

    public LabelStepBatchFetcher(FetchQueryBuildFunction fetchQueryBuildFunction, int batchSize) {
        super(batchSize);
        this.fetchQueryBuildFunction = fetchQueryBuildFunction;
    }

    @Override
    protected Map<JanusGraphVertex, String> makeQueryAndExecute(JanusGraphMultiVertexQuery multiQuery) {
        multiQuery = this.fetchQueryBuildFunction.makeQuery(multiQuery);
        Map<JanusGraphVertex, Iterable<JanusGraphVertex>> labelsBatch = multiQuery.vertices();
        HashMap<JanusGraphVertex, String> result = new HashMap<JanusGraphVertex, String>(labelsBatch.size());
        for (Map.Entry<JanusGraphVertex, Iterable<JanusGraphVertex>> labelEntry : labelsBatch.entrySet()) {
            result.put(labelEntry.getKey(), BasicVertexCentricQueryUtil.castToVertexLabel((Vertex)Iterables.getOnlyElement(labelEntry.getValue(), null)).name());
        }
        return result;
    }
}

