/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.condition;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.graphdb.query.condition.Literal;

public class IncidenceCondition<E extends JanusGraphRelation>
extends Literal<E> {
    private final JanusGraphVertex baseVertex;
    private final JanusGraphVertex otherVertex;

    public IncidenceCondition(JanusGraphVertex baseVertex, JanusGraphVertex otherVertex) {
        Preconditions.checkNotNull((Object)baseVertex);
        Preconditions.checkNotNull((Object)otherVertex);
        this.baseVertex = baseVertex;
        this.otherVertex = otherVertex;
    }

    @Override
    public boolean evaluate(E relation) {
        return relation.isEdge() && ((JanusGraphEdge)relation).otherVertex(this.baseVertex).equals(this.otherVertex);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getType(), this.baseVertex, this.otherVertex});
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().isInstance(other)) {
            return false;
        }
        IncidenceCondition oth = (IncidenceCondition)other;
        return this.baseVertex.equals(oth.baseVertex) && this.otherVertex.equals(oth.otherVertex);
    }

    @Override
    public String toString() {
        return "incidence[" + this.baseVertex + "-" + this.otherVertex + "]";
    }
}

