/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.OptionalLong;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerImpl;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.regionserver.CatalogReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.CatalogReplicationSourcePeer;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationGlobalSourceSource;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.replication.regionserver.NoopReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationRuntimeException;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceFactory;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSyncUp;
import org.apache.hadoop.hbase.replication.regionserver.WALEntryBatch;
import org.apache.hadoop.hbase.replication.regionserver.WALFileLengthProvider;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ReplicationSourceManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationSourceManager.class);
    private final ConcurrentMap<String, ReplicationSourceInterface> sources;
    private final List<ReplicationSourceInterface> oldsources;
    private final ReplicationQueueStorage queueStorage;
    private final ReplicationPeers replicationPeers;
    private final UUID clusterId;
    private final Server server;
    private final ConcurrentMap<String, Map<String, NavigableSet<String>>> walsById;
    private final ConcurrentMap<String, Map<String, NavigableSet<String>>> walsByIdRecoveredQueues;
    private final Configuration conf;
    private final FileSystem fs;
    private final Map<String, Path> latestPaths;
    private final Path logDir;
    private final Path oldLogDir;
    private final WALFactory walFactory;
    private final long sleepBeforeFailover;
    private final ThreadPoolExecutor executor;
    private final boolean replicationForBulkLoadDataEnabled;
    private AtomicLong totalBufferUsed = new AtomicLong();
    private final long totalBufferLimit;
    private final MetricsReplicationGlobalSourceSource globalMetrics;
    AtomicReference<ReplicationSourceInterface> catalogReplicationSource = new AtomicReference();

    public ReplicationSourceManager(ReplicationQueueStorage queueStorage, ReplicationPeers replicationPeers, Configuration conf, Server server, FileSystem fs, Path logDir, Path oldLogDir, UUID clusterId, WALFactory walFactory, MetricsReplicationGlobalSourceSource globalMetrics) throws IOException {
        this.sources = new ConcurrentHashMap<String, ReplicationSourceInterface>();
        this.queueStorage = queueStorage;
        this.replicationPeers = replicationPeers;
        this.server = server;
        this.walsById = new ConcurrentHashMap<String, Map<String, NavigableSet<String>>>();
        this.walsByIdRecoveredQueues = new ConcurrentHashMap<String, Map<String, NavigableSet<String>>>();
        this.oldsources = new ArrayList<ReplicationSourceInterface>();
        this.conf = conf;
        this.fs = fs;
        this.logDir = logDir;
        this.oldLogDir = oldLogDir;
        this.sleepBeforeFailover = conf.getLong("replication.sleep.before.failover", 30000L);
        this.clusterId = clusterId;
        this.walFactory = walFactory;
        int nbWorkers = conf.getInt("replication.executor.workers", 1);
        this.executor = new ThreadPoolExecutor(nbWorkers, nbWorkers, 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder();
        tfb.setNameFormat("ReplicationExecutor-%d");
        tfb.setDaemon(true);
        this.executor.setThreadFactory(tfb.build());
        this.latestPaths = new HashMap<String, Path>();
        this.replicationForBulkLoadDataEnabled = conf.getBoolean("hbase.replication.bulkload.enabled", false);
        this.totalBufferLimit = conf.getLong("replication.total.buffer.quota", 0x10000000L);
        this.globalMetrics = globalMetrics;
    }

    void init() throws IOException {
        for (String id : this.replicationPeers.getAllPeerIds()) {
            this.addSource(id);
            if (!this.replicationForBulkLoadDataEnabled) continue;
            this.throwIOExceptionWhenFail(() -> this.queueStorage.addPeerToHFileRefs(id));
        }
    }

    public void addPeer(String peerId) throws IOException {
        boolean added = false;
        try {
            added = this.replicationPeers.addPeer(peerId);
        }
        catch (ReplicationException e) {
            throw new IOException(e);
        }
        if (added) {
            this.addSource(peerId);
            if (this.replicationForBulkLoadDataEnabled) {
                this.throwIOExceptionWhenFail(() -> this.queueStorage.addPeerToHFileRefs(peerId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePeer(String peerId) {
        this.replicationPeers.removePeer(peerId);
        String terminateMessage = "Replication stream was removed by a user";
        ArrayList<ReplicationSourceInterface> oldSourcesToDelete = new ArrayList<ReplicationSourceInterface>();
        List<ReplicationSourceInterface> list = this.oldsources;
        synchronized (list) {
            for (ReplicationSourceInterface src : this.oldsources) {
                if (!peerId.equals(src.getPeerId())) continue;
                oldSourcesToDelete.add(src);
            }
            for (ReplicationSourceInterface src : oldSourcesToDelete) {
                src.terminate(terminateMessage);
                this.removeRecoveredSource(src);
            }
        }
        LOG.info("Number of deleted recovered sources for " + peerId + ": " + oldSourcesToDelete.size());
        ReplicationSourceInterface srcToRemove = (ReplicationSourceInterface)this.sources.get(peerId);
        if (srcToRemove != null) {
            srcToRemove.terminate(terminateMessage);
            this.removeSource(srcToRemove);
        } else {
            this.deleteQueue(peerId);
            this.walsById.remove(peerId);
        }
        this.abortWhenFail(() -> this.queueStorage.removePeerFromHFileRefs(peerId));
    }

    private ReplicationSourceInterface createSource(String queueId, ReplicationPeer replicationPeer) throws IOException {
        ReplicationSourceInterface src = ReplicationSourceFactory.create(this.conf, queueId);
        WALFileLengthProvider walFileLengthProvider = this.walFactory.getWALProvider() != null ? this.walFactory.getWALProvider().getWALFileLengthProvider() : p -> OptionalLong.empty();
        src.init(this.conf, this.fs, this, this.queueStorage, replicationPeer, this.server, queueId, this.clusterId, walFileLengthProvider, new MetricsSource(queueId));
        return src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReplicationSourceInterface addSource(String peerId) throws IOException {
        ReplicationPeerImpl peer = this.replicationPeers.getPeer(peerId);
        ReplicationSourceInterface src = this.createSource(peerId, peer);
        Map<String, Path> map = this.latestPaths;
        synchronized (map) {
            this.sources.put(peerId, src);
            HashMap walsByGroup = new HashMap();
            this.walsById.put(peerId, walsByGroup);
            if (!this.latestPaths.isEmpty()) {
                for (Map.Entry<String, Path> walPrefixAndPath : this.latestPaths.entrySet()) {
                    Path walPath = walPrefixAndPath.getValue();
                    TreeSet<String> wals = new TreeSet<String>();
                    wals.add(walPath.getName());
                    walsByGroup.put(walPrefixAndPath.getKey(), wals);
                    this.abortAndThrowIOExceptionWhenFail(() -> this.queueStorage.addWAL(this.server.getServerName(), peerId, walPath.getName()));
                    src.enqueueLog(walPath);
                    LOG.trace("Enqueued {} to source {} during source creation.", (Object)walPath, (Object)src.getQueueId());
                }
            }
        }
        src.startup();
        return src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshSources(String peerId) throws IOException {
        ReplicationSourceInterface src;
        String terminateMessage = "Peer " + peerId + " state or config changed. Will close the previous replication source and open a new one";
        ReplicationPeerImpl peer = this.replicationPeers.getPeer(peerId);
        Map<String, Path> map = this.latestPaths;
        synchronized (map) {
            ReplicationSourceInterface toRemove = (ReplicationSourceInterface)this.sources.remove(peerId);
            if (toRemove != null) {
                LOG.info("Terminate replication source for " + toRemove.getPeerId());
                toRemove.terminate(terminateMessage, null, true);
            }
            src = this.createSource(peerId, peer);
            this.sources.put(peerId, src);
            for (NavigableSet walsByGroup : ((Map)this.walsById.get(peerId)).values()) {
                walsByGroup.forEach(wal -> src.enqueueLog(new Path(this.logDir, wal)));
            }
        }
        LOG.info("Startup replication source for " + src.getPeerId());
        src.startup();
        ArrayList<ReplicationSourceInterface> toStartup = new ArrayList<ReplicationSourceInterface>();
        List<ReplicationSourceInterface> list = this.oldsources;
        synchronized (list) {
            ArrayList<String> previousQueueIds = new ArrayList<String>();
            Iterator<ReplicationSourceInterface> iter = this.oldsources.iterator();
            while (iter.hasNext()) {
                ReplicationSourceInterface oldSource = iter.next();
                if (!oldSource.getPeerId().equals(peerId)) continue;
                previousQueueIds.add(oldSource.getQueueId());
                oldSource.terminate(terminateMessage);
                iter.remove();
            }
            for (String queueId : previousQueueIds) {
                ReplicationSourceInterface recoveredReplicationSource = this.createSource(queueId, peer);
                this.oldsources.add(recoveredReplicationSource);
                for (SortedSet walsByGroup : ((Map)this.walsByIdRecoveredQueues.get(queueId)).values()) {
                    walsByGroup.forEach(wal -> recoveredReplicationSource.enqueueLog(new Path(wal)));
                }
                toStartup.add(recoveredReplicationSource);
            }
        }
        for (ReplicationSourceInterface replicationSource : toStartup) {
            replicationSource.startup();
        }
    }

    void removeRecoveredSource(ReplicationSourceInterface src) {
        LOG.info("Done with the recovered queue " + src.getQueueId());
        this.oldsources.remove(src);
        this.deleteQueue(src.getQueueId());
        this.walsByIdRecoveredQueues.remove(src.getQueueId());
    }

    void removeSource(ReplicationSourceInterface src) {
        LOG.info("Done with the queue " + src.getQueueId());
        this.sources.remove(src.getPeerId());
        this.deleteQueue(src.getQueueId());
        this.walsById.remove(src.getQueueId());
    }

    private void deleteQueue(String queueId) {
        this.abortWhenFail(() -> this.queueStorage.removeQueue(this.server.getServerName(), queueId));
    }

    private void interruptOrAbortWhenFail(ReplicationQueueOperation op) {
        try {
            op.exec();
        }
        catch (ReplicationException e) {
            if (e.getCause() != null && e.getCause() instanceof KeeperException.SystemErrorException && e.getCause().getCause() != null && e.getCause().getCause() instanceof InterruptedException) {
                throw new ReplicationRuntimeException("Thread is interrupted, the replication source may be terminated", e.getCause().getCause());
            }
            this.server.abort("Failed to operate on replication queue", e);
        }
    }

    private void abortWhenFail(ReplicationQueueOperation op) {
        try {
            op.exec();
        }
        catch (ReplicationException e) {
            this.server.abort("Failed to operate on replication queue", e);
        }
    }

    private void throwIOExceptionWhenFail(ReplicationQueueOperation op) throws IOException {
        try {
            op.exec();
        }
        catch (ReplicationException e) {
            throw new IOException(e);
        }
    }

    private void abortAndThrowIOExceptionWhenFail(ReplicationQueueOperation op) throws IOException {
        try {
            op.exec();
        }
        catch (ReplicationException e) {
            this.server.abort("Failed to operate on replication queue", e);
            throw new IOException(e);
        }
    }

    public void logPositionAndCleanOldLogs(ReplicationSourceInterface source, WALEntryBatch entryBatch) {
        String fileName = entryBatch.getLastWalPath().getName();
        String queueId = source.getQueueId();
        this.interruptOrAbortWhenFail(() -> this.queueStorage.setWALPosition(this.server.getServerName(), queueId, fileName, entryBatch.getLastWalPosition(), entryBatch.getLastSeqIds()));
        this.cleanOldLogs(fileName, entryBatch.isEndOfFile(), queueId, source.isRecovered());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanOldLogs(String log, boolean inclusive, String queueId, boolean queueRecovered) {
        String logPrefix = AbstractFSWALProvider.getWALPrefixFromWALName(log);
        if (queueRecovered) {
            NavigableSet wals = (NavigableSet)((Map)this.walsByIdRecoveredQueues.get(queueId)).get(logPrefix);
            if (wals != null) {
                this.cleanOldLogs(wals, log, inclusive, queueId);
            }
        } else {
            ConcurrentMap<String, Map<String, NavigableSet<String>>> concurrentMap = this.walsById;
            synchronized (concurrentMap) {
                NavigableSet wals = (NavigableSet)((Map)this.walsById.get(queueId)).get(logPrefix);
                if (wals != null) {
                    this.cleanOldLogs(wals, log, inclusive, queueId);
                }
            }
        }
    }

    private void cleanOldLogs(NavigableSet<String> wals, String key, boolean inclusive, String id) {
        NavigableSet<String> walSet = wals.headSet(key, inclusive);
        if (walSet.isEmpty()) {
            return;
        }
        LOG.debug("Removing {} logs in the list: {}", (Object)walSet.size(), walSet);
        for (String wal : walSet) {
            this.interruptOrAbortWhenFail(() -> this.queueStorage.removeWAL(this.server.getServerName(), id, wal));
        }
        walSet.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preLogRoll(Path newLog) throws IOException {
        String logName = newLog.getName();
        String logPrefix = AbstractFSWALProvider.getWALPrefixFromWALName(logName);
        Map<String, Path> map = this.latestPaths;
        synchronized (map) {
            for (ReplicationSourceInterface source : this.sources.values()) {
                this.abortAndThrowIOExceptionWhenFail(() -> this.queueStorage.addWAL(this.server.getServerName(), source.getQueueId(), logName));
            }
            ConcurrentMap<String, Map<String, NavigableSet<String>>> concurrentMap = this.walsById;
            synchronized (concurrentMap) {
                for (Map.Entry entry : this.walsById.entrySet()) {
                    String peerId = (String)entry.getKey();
                    Map walsByPrefix = (Map)entry.getValue();
                    boolean existingPrefix = false;
                    for (Map.Entry walsEntry : walsByPrefix.entrySet()) {
                        SortedSet wals = (SortedSet)walsEntry.getValue();
                        if (this.sources.isEmpty()) {
                            wals.clear();
                        }
                        if (!logPrefix.equals(walsEntry.getKey())) continue;
                        wals.add(logName);
                        existingPrefix = true;
                    }
                    if (existingPrefix) continue;
                    LOG.debug("Start tracking logs for wal group {} for peer {}", (Object)logPrefix, (Object)peerId);
                    TreeSet<String> wals = new TreeSet<String>();
                    wals.add(logName);
                    walsByPrefix.put(logPrefix, wals);
                }
            }
            this.latestPaths.put(logPrefix, newLog);
        }
    }

    public void postLogRoll(Path newLog) throws IOException {
        for (ReplicationSourceInterface source : this.sources.values()) {
            source.enqueueLog(newLog);
            LOG.trace("Enqueued {} to source {} while performing postLogRoll operation.", (Object)newLog, (Object)source.getQueueId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void claimQueue(ServerName deadRS, String queue) {
        ReplicationSourceInterface src;
        Pair<String, SortedSet<String>> claimedQueue;
        try {
            Thread.sleep(this.sleepBeforeFailover + (long)(ThreadLocalRandom.current().nextFloat() * (float)this.sleepBeforeFailover));
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting before transferring a queue.");
            Thread.currentThread().interrupt();
        }
        if (this.server.isStopped()) {
            LOG.info("Not transferring queue since we are shutting down");
            return;
        }
        String peerId = new ReplicationQueueInfo(queue).getPeerId();
        ReplicationPeerImpl oldPeer = this.replicationPeers.getPeer(peerId);
        if (oldPeer == null) {
            LOG.info("Not transferring queue since the replication peer {} for queue {} does not exist", (Object)peerId, (Object)queue);
            return;
        }
        try {
            claimedQueue = this.queueStorage.claimQueue(deadRS, queue, this.server.getServerName());
        }
        catch (ReplicationException e) {
            LOG.error("ReplicationException: cannot claim dead region ({})'s replication queue. Znode : ({}) Possible solution: check if znode size exceeds jute.maxBuffer value.  If so, increase it for both client and server side.", new Object[]{deadRS, this.queueStorage.getRsNode(deadRS), e});
            this.server.abort("Failed to claim queue from dead regionserver.", e);
            return;
        }
        if (claimedQueue.getSecond().isEmpty()) {
            return;
        }
        String queueId = claimedQueue.getFirst();
        Set walsSet = claimedQueue.getSecond();
        ReplicationPeerImpl peer = this.replicationPeers.getPeer(peerId);
        if (peer == null || peer != oldPeer) {
            LOG.warn("Skipping failover for peer {} of node {}, peer is null", (Object)peerId, (Object)deadRS);
            this.abortWhenFail(() -> this.queueStorage.removeQueue(this.server.getServerName(), queueId));
            return;
        }
        if (this.server instanceof ReplicationSyncUp.DummyServer && peer.getPeerState().equals((Object)ReplicationPeer.PeerState.DISABLED)) {
            LOG.warn("Peer {} is disabled. ReplicationSyncUp tool will skip replicating data to this peer.", (Object)peerId);
            return;
        }
        try {
            src = this.createSource(queueId, peer);
        }
        catch (IOException e) {
            LOG.error("Can not create replication source for peer {} and queue {}", new Object[]{peerId, queueId, e});
            this.server.abort("Failed to create replication source after claiming queue.", e);
            return;
        }
        List<ReplicationSourceInterface> list = this.oldsources;
        synchronized (list) {
            peer = this.replicationPeers.getPeer(src.getPeerId());
            if (peer == null || peer != oldPeer) {
                src.terminate("Recovered queue doesn't belong to any current peer");
                this.deleteQueue(queueId);
                return;
            }
            HashMap<String, TreeSet<String>> walsByGroup = new HashMap<String, TreeSet<String>>();
            this.walsByIdRecoveredQueues.put(queueId, walsByGroup);
            for (String wal : walsSet) {
                String walPrefix = AbstractFSWALProvider.getWALPrefixFromWALName(wal);
                TreeSet<String> wals = (TreeSet<String>)walsByGroup.get(walPrefix);
                if (wals == null) {
                    wals = new TreeSet<String>();
                    walsByGroup.put(walPrefix, wals);
                }
                wals.add(wal);
            }
            this.oldsources.add(src);
            LOG.info("Added source for recovered queue {}", (Object)src.getQueueId());
            for (String wal : walsSet) {
                LOG.trace("Enqueueing log from recovered queue for source: " + src.getQueueId());
                src.enqueueLog(new Path(this.oldLogDir, wal));
            }
            src.startup();
        }
    }

    public void join() {
        this.executor.shutdown();
        for (ReplicationSourceInterface source : this.sources.values()) {
            source.terminate("Region server is closing");
        }
        for (ReplicationSourceInterface source : this.oldsources) {
            source.terminate("Region server is closing");
        }
    }

    public Map<String, Map<String, NavigableSet<String>>> getWALs() {
        return Collections.unmodifiableMap(this.walsById);
    }

    Map<String, Map<String, NavigableSet<String>>> getWalsByIdRecoveredQueues() {
        return Collections.unmodifiableMap(this.walsByIdRecoveredQueues);
    }

    public List<ReplicationSourceInterface> getSources() {
        return new ArrayList<ReplicationSourceInterface>(this.sources.values());
    }

    public List<ReplicationSourceInterface> getOldSources() {
        return this.oldsources;
    }

    public ReplicationSourceInterface getSource(String peerId) {
        return (ReplicationSourceInterface)this.sources.get(peerId);
    }

    List<String> getAllQueues() throws IOException {
        List<String> allQueues = Collections.emptyList();
        try {
            allQueues = this.queueStorage.getAllQueues(this.server.getServerName());
        }
        catch (ReplicationException e) {
            throw new IOException(e);
        }
        return allQueues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getSizeOfLatestPath() {
        Map<String, Path> map = this.latestPaths;
        synchronized (map) {
            return this.latestPaths.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Path> getLastestPath() {
        Map<String, Path> map = this.latestPaths;
        synchronized (map) {
            return Sets.newHashSet(this.latestPaths.values());
        }
    }

    public AtomicLong getTotalBufferUsed() {
        return this.totalBufferUsed;
    }

    public long getTotalBufferLimit() {
        return this.totalBufferLimit;
    }

    public Path getOldLogDir() {
        return this.oldLogDir;
    }

    public Path getLogDir() {
        return this.logDir;
    }

    public FileSystem getFs() {
        return this.fs;
    }

    public ReplicationPeers getReplicationPeers() {
        return this.replicationPeers;
    }

    public String getStats() {
        StringBuilder stats = new StringBuilder();
        stats.append("Global stats: ");
        stats.append("WAL Edits Buffer Used=").append(this.getTotalBufferUsed().get()).append("B, Limit=").append(this.getTotalBufferLimit()).append("B\n");
        for (ReplicationSourceInterface source : this.sources.values()) {
            stats.append("Normal source for cluster " + source.getPeerId() + ": ");
            stats.append(source.getStats() + "\n");
        }
        for (ReplicationSourceInterface oldSource : this.oldsources) {
            stats.append("Recovered source for cluster/machine(s) " + oldSource.getPeerId() + ": ");
            stats.append(oldSource.getStats() + "\n");
        }
        return stats.toString();
    }

    public void addHFileRefs(TableName tableName, byte[] family, List<Pair<Path, Path>> pairs) throws IOException {
        for (ReplicationSourceInterface source : this.sources.values()) {
            this.throwIOExceptionWhenFail(() -> source.addHFileRefs(tableName, family, pairs));
        }
    }

    public void cleanUpHFileRefs(String peerId, List<String> files) {
        this.interruptOrAbortWhenFail(() -> this.queueStorage.removeHFileRefs(peerId, files));
    }

    int activeFailoverTaskCount() {
        return this.executor.getActiveCount();
    }

    MetricsReplicationGlobalSourceSource getGlobalMetrics() {
        return this.globalMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationSourceInterface addCatalogReplicationSource(RegionInfo regionInfo) throws IOException {
        AtomicReference<ReplicationSourceInterface> atomicReference = this.catalogReplicationSource;
        synchronized (atomicReference) {
            ReplicationSourceInterface rs = this.catalogReplicationSource.get();
            return rs != null ? rs : this.catalogReplicationSource.getAndSet(this.createCatalogReplicationSource(regionInfo));
        }
    }

    public void removeCatalogReplicationSource(RegionInfo regionInfo) {
    }

    private ReplicationSourceInterface createCatalogReplicationSource(RegionInfo regionInfo) throws IOException {
        boolean instantiate;
        WALProvider walProvider = this.walFactory.getMetaWALProvider();
        boolean bl = instantiate = walProvider == null;
        if (instantiate) {
            walProvider = this.walFactory.getMetaProvider();
        }
        CatalogReplicationSourcePeer peer = new CatalogReplicationSourcePeer(this.conf, this.clusterId.toString());
        final CatalogReplicationSource crs = new CatalogReplicationSource();
        crs.init(this.conf, this.fs, this, new NoopReplicationQueueStorage(), peer, this.server, peer.getId(), this.clusterId, walProvider.getWALFileLengthProvider(), new MetricsSource(peer.getId()));
        WALActionsListener listener = new WALActionsListener(){

            @Override
            public void postLogRoll(Path oldPath, Path newPath) throws IOException {
                crs.enqueueLog(newPath);
            }
        };
        walProvider.addWALActionsListener(listener);
        if (!instantiate) {
            WAL wal = walProvider.getWAL(regionInfo);
            wal.registerWALActionsListener(listener);
            crs.enqueueLog(((AbstractFSWAL)wal).getCurrentFileName());
        }
        return crs.startup();
    }

    ReplicationQueueStorage getQueueStorage() {
        return this.queueStorage;
    }

    @FunctionalInterface
    private static interface ReplicationQueueOperation {
        public void exec() throws ReplicationException;
    }
}

