/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import com.jcabi.log.Logger;
import com.jcabi.log.Supplier;

final class SupplierLogger {
    SupplierLogger() {
    }

    public static void trace(Object source, String msg, Supplier<?> ... args) {
        if (Logger.isTraceEnabled(source)) {
            Logger.traceForced(source, msg, SupplierLogger.supplied(args));
        }
    }

    public static void debug(Object source, String msg, Supplier<?> ... args) {
        if (Logger.isDebugEnabled(source)) {
            Logger.debugForced(source, msg, SupplierLogger.supplied(args));
        }
    }

    public static void info(Object source, String msg, Supplier<?> ... args) {
        if (Logger.isInfoEnabled(source)) {
            Logger.infoForced(source, msg, SupplierLogger.supplied(args));
        }
    }

    public static void warn(Object source, String msg, Supplier<?> ... args) {
        if (Logger.isWarnEnabled(source)) {
            Logger.warnForced(source, msg, SupplierLogger.supplied(args));
        }
    }

    private static Object[] supplied(Supplier<?> ... args) {
        Object[] supplied = new Object[args.length];
        for (int idx = 0; idx < supplied.length; ++idx) {
            supplied[idx] = args[idx].get();
        }
        return supplied;
    }
}

