/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.idhandling;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.janusgraph.diskstorage.ReadBuffer;
import org.janusgraph.diskstorage.WriteBuffer;

public class VariableString {
    public static void checkAsciiPrintableString(String value) {
        if (StringUtils.isEmpty((String)value) || !StringUtils.isAsciiPrintable((String)value)) {
            throw new IllegalArgumentException("Value must be non-empty printable ASCII string!");
        }
    }

    public static void write(WriteBuffer out, String value) {
        VariableString.checkAsciiPrintableString(value);
        out.putByte((byte)-128);
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            assert (c <= '\u007f');
            byte b = (byte)c;
            if (i + 1 == value.length()) {
                b = (byte)(b | 0xFFFFFF80);
            }
            out.putByte(b);
        }
    }

    public static void writeBackward(WriteBuffer out, String value) {
        VariableString.checkAsciiPrintableString(value);
        for (int i = value.length() - 1; i >= 0; --i) {
            char c = value.charAt(i);
            assert (c <= '\u007f');
            byte b = (byte)c;
            if (i == value.length() - 1) {
                b = (byte)(b | 0xFFFFFF80);
            }
            out.putByte(b);
        }
        out.putByte((byte)-128);
    }

    public static String read(ReadBuffer in) {
        int c;
        Preconditions.checkArgument((in.getByte() == -128 ? 1 : 0) != 0);
        StringBuilder sb = new StringBuilder();
        do {
            c = 0xFF & in.getByte();
            sb.append((char)(c & 0x7F));
        } while ((c & 0x80) <= 0);
        return sb.toString();
    }

    public static String readBackward(ReadBuffer in) {
        int c;
        int position = in.getPosition();
        Preconditions.checkArgument((in.getByte(--position) == -128 ? 1 : 0) != 0);
        StringBuilder sb = new StringBuilder();
        do {
            c = 0xFF & in.getByte(--position);
            sb.append((char)(c & 0x7F));
        } while ((c & 0x80) <= 0);
        in.movePositionTo(position);
        return sb.toString();
    }
}

