/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsAggregator;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.IOStatisticsSupport;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestCommitterSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.AbstractJobOrTaskStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;
import org.apache.hadoop.util.functional.TaskPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadManifestsStage
extends AbstractJobOrTaskStage<Boolean, Result> {
    private static final Logger LOG = LoggerFactory.getLogger(LoadManifestsStage.class);
    private final SummaryInfo summaryInfo = new SummaryInfo();
    private boolean pruneManifests;
    private final List<TaskManifest> manifests = new ArrayList<TaskManifest>();

    public LoadManifestsStage(StageConfig stageConfig) {
        super(false, stageConfig, "job_stage_load_manifests", true);
    }

    @Override
    protected Result executeStage(Boolean prune) throws IOException {
        Path manifestDir = this.getTaskManifestDir();
        LOG.info("{}: Executing Manifest Job Commit with manifests in {}", (Object)this.getName(), (Object)manifestDir);
        this.pruneManifests = prune;
        this.msync(manifestDir);
        RemoteIterator<FileStatus> manifestFiles = this.listManifests();
        List<TaskManifest> manifestList = this.loadAllManifests(manifestFiles);
        LOG.info("{}: Summary of {} manifests loaded in {}: {}", new Object[]{this.getName(), manifestList.size(), manifestDir, this.summaryInfo});
        ManifestCommitterSupport.maybeAddIOStatistics((IOStatisticsAggregator)this.getIOStatistics(), manifestFiles);
        return new Result(this.summaryInfo, manifestList);
    }

    private List<TaskManifest> loadAllManifests(RemoteIterator<FileStatus> manifestFiles) throws IOException {
        IOStatisticsBinding.trackDurationOfInvocation((DurationTrackerFactory)this.getIOStatistics(), (String)"op_load_all_manifests", () -> TaskPool.foreach((RemoteIterator)manifestFiles).executeWith(this.getIOProcessors()).stopOnFailure().run(this::processOneManifest));
        return this.manifests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOneManifest(FileStatus status) throws IOException {
        this.updateAuditContext("op_load_all_manifests");
        TaskManifest m = this.fetchTaskManifest(status);
        this.progress();
        List<TaskManifest> list = this.manifests;
        synchronized (list) {
            this.manifests.add(m);
            this.summaryInfo.add(m);
        }
        if (this.pruneManifests) {
            m.setIOStatistics(null);
            m.getExtraData().clear();
        }
    }

    private TaskManifest fetchTaskManifest(FileStatus status) throws IOException {
        if (status.getLen() == 0L || !status.isFile()) {
            throw new PathIOException(status.getPath().toString(), "Not a valid manifest file; file status = " + status);
        }
        TaskManifest manifest = this.loadManifest(status);
        String id = manifest.getTaskAttemptID();
        int filecount = manifest.getFilesToCommit().size();
        long size = manifest.getTotalFileSize();
        LOG.info("{}: Task Attempt {} file {}: File count: {}; data size={}", new Object[]{this.getName(), id, status.getPath(), filecount, size});
        this.getIOStatistics().addMeanStatisticSample("committer_task_manifest_file_size", status.getLen());
        return manifest;
    }

    public static final class SummaryInfo
    implements IOStatisticsSource {
        private IOStatisticsSnapshot iostatistics = IOStatisticsSupport.snapshotIOStatistics();
        private long manifestCount;
        private long fileCount;
        private long directoryCount;
        private long totalFileSize;

        public IOStatisticsSnapshot getIOStatistics() {
            return this.iostatistics;
        }

        public long getFileCount() {
            return this.fileCount;
        }

        public long getDirectoryCount() {
            return this.directoryCount;
        }

        public long getTotalFileSize() {
            return this.totalFileSize;
        }

        public long getManifestCount() {
            return this.manifestCount;
        }

        public void add(TaskManifest manifest) {
            ++this.manifestCount;
            this.iostatistics.aggregate((IOStatistics)manifest.getIOStatistics());
            this.fileCount += (long)manifest.getFilesToCommit().size();
            this.directoryCount += (long)manifest.getDestDirectories().size();
            this.totalFileSize += manifest.getTotalFileSize();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("SummaryInfo{");
            sb.append("manifestCount=").append(this.manifestCount);
            sb.append(", fileCount=").append(this.fileCount);
            sb.append(", directoryCount=").append(this.directoryCount);
            sb.append(", totalFileSize=").append(FileUtils.byteCountToDisplaySize((long)this.totalFileSize));
            sb.append('}');
            return sb.toString();
        }
    }

    public static final class Result {
        private final SummaryInfo summary;
        private final List<TaskManifest> manifests;

        public Result(SummaryInfo summary, List<TaskManifest> manifests) {
            this.summary = summary;
            this.manifests = manifests;
        }

        public SummaryInfo getSummary() {
            return this.summary;
        }

        public List<TaskManifest> getManifests() {
            return this.manifests;
        }
    }
}

