/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.util.List;
import org.apache.commons.collections.IteratorUtils;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertexProperty;

public class VertexPropertySerializer
extends SimpleTypeSerializer<VertexProperty> {
    public VertexPropertySerializer() {
        super(DataType.VERTEXPROPERTY);
    }

    @Override
    protected VertexProperty readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        DetachedVertexProperty.Builder builder = DetachedVertexProperty.build().setId(context.read(buffer)).setLabel(context.readValue(buffer, String.class, false)).setValue(context.read(buffer));
        context.read(buffer);
        List properties = (List)context.read(buffer);
        if (properties != null && !properties.isEmpty()) {
            for (Property p : properties) {
                builder.addProperty(p);
            }
        }
        return builder.create();
    }

    @Override
    protected void writeValue(VertexProperty value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        context.write(value.id(), buffer);
        context.writeValue(value.label(), buffer, false);
        context.write(value.value(), buffer);
        context.write(null, buffer);
        List asList = IteratorUtils.toList(value.properties(new String[0]));
        context.write(asList, buffer);
    }
}

