/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature;

import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.PublicKeyVerify;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.crypto.tink.subtle.Bytes;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

class PublicKeyVerifyWrapper
implements PrimitiveWrapper<PublicKeyVerify, PublicKeyVerify> {
    private static final Logger logger = Logger.getLogger(PublicKeyVerifyWrapper.class.getName());

    PublicKeyVerifyWrapper() {
    }

    @Override
    public PublicKeyVerify wrap(PrimitiveSet<PublicKeyVerify> primitives) {
        return new WrappedPublicKeyVerify(primitives);
    }

    @Override
    public Class<PublicKeyVerify> getPrimitiveClass() {
        return PublicKeyVerify.class;
    }

    @Override
    public Class<PublicKeyVerify> getInputPrimitiveClass() {
        return PublicKeyVerify.class;
    }

    public static void register() throws GeneralSecurityException {
        Registry.registerPrimitiveWrapper(new PublicKeyVerifyWrapper());
    }

    private static class WrappedPublicKeyVerify
    implements PublicKeyVerify {
        private final PrimitiveSet<PublicKeyVerify> primitives;

        public WrappedPublicKeyVerify(PrimitiveSet<PublicKeyVerify> primitives) {
            this.primitives = primitives;
        }

        @Override
        public void verify(byte[] signature, byte[] data) throws GeneralSecurityException {
            if (signature.length <= 5) {
                throw new GeneralSecurityException("signature too short");
            }
            byte[] prefix = Arrays.copyOf(signature, 5);
            byte[] sigNoPrefix = Arrays.copyOfRange(signature, 5, signature.length);
            List<PrimitiveSet.Entry<PublicKeyVerify>> entries = this.primitives.getPrimitive(prefix);
            for (PrimitiveSet.Entry<PublicKeyVerify> entry : entries) {
                try {
                    if (entry.getOutputPrefixType().equals((Object)OutputPrefixType.LEGACY)) {
                        byte[] formatVersion = new byte[]{0};
                        byte[] dataWithFormatVersion = Bytes.concat(data, formatVersion);
                        entry.getPrimitive().verify(sigNoPrefix, dataWithFormatVersion);
                    } else {
                        entry.getPrimitive().verify(sigNoPrefix, data);
                    }
                    return;
                }
                catch (GeneralSecurityException e) {
                    logger.info("signature prefix matches a key, but cannot verify: " + e.toString());
                }
            }
            entries = this.primitives.getRawPrimitives();
            for (PrimitiveSet.Entry<PublicKeyVerify> entry : entries) {
                try {
                    entry.getPrimitive().verify(signature, data);
                    return;
                }
                catch (GeneralSecurityException generalSecurityException) {
                }
            }
            throw new GeneralSecurityException("invalid signature");
        }
    }
}

