/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.BlockingService;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.AlignmentContext;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.ProtocolInfo;
import org.apache.hadoop.ipc.ProtocolMetaInfoPB;
import org.apache.hadoop.ipc.ProtocolMetaInfoServerSideTranslatorPB;
import org.apache.hadoop.ipc.ProtocolProxy;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RpcEngine;
import org.apache.hadoop.ipc.RpcInvocationHandler;
import org.apache.hadoop.ipc.RpcServerException;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.ipc.WritableRpcEngine;
import org.apache.hadoop.ipc.protobuf.ProtocolInfoProtos;
import org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Common", "HDFS", "MapReduce", "Yarn"})
@InterfaceStability.Evolving
public class RPC {
    static final int RPC_SERVICE_CLASS_DEFAULT = 0;
    static final Logger LOG = LoggerFactory.getLogger(RPC.class);
    private static final Map<Class<?>, RpcEngine> PROTOCOL_ENGINES = new HashMap();
    private static final String ENGINE_PROP = "rpc.engine";

    static Class<?>[] getSuperInterfaces(Class<?>[] childInterfaces) {
        ArrayList allInterfaces = new ArrayList();
        for (Class<?> childInterface : childInterfaces) {
            if (VersionedProtocol.class.isAssignableFrom(childInterface)) {
                allInterfaces.add(childInterface);
                allInterfaces.addAll(Arrays.asList(RPC.getSuperInterfaces(childInterface.getInterfaces())));
                continue;
            }
            LOG.warn("Interface " + childInterface + " ignored because it does not extend VersionedProtocol");
        }
        return allInterfaces.toArray(new Class[allInterfaces.size()]);
    }

    static Class<?>[] getProtocolInterfaces(Class<?> protocol) {
        Class<?>[] interfaces = protocol.getInterfaces();
        return RPC.getSuperInterfaces(interfaces);
    }

    public static String getProtocolName(Class<?> protocol) {
        if (protocol == null) {
            return null;
        }
        ProtocolInfo anno = protocol.getAnnotation(ProtocolInfo.class);
        return anno == null ? protocol.getName() : anno.protocolName();
    }

    public static long getProtocolVersion(Class<?> protocol) {
        long version;
        if (protocol == null) {
            throw new IllegalArgumentException("Null protocol");
        }
        ProtocolInfo anno = protocol.getAnnotation(ProtocolInfo.class);
        if (anno != null && (version = anno.protocolVersion()) != -1L) {
            return version;
        }
        try {
            Field versionField = protocol.getField("versionID");
            versionField.setAccessible(true);
            return versionField.getLong(protocol);
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    private RPC() {
    }

    public static void setProtocolEngine(Configuration conf, Class<?> protocol, Class<?> engine) {
        if (conf.get("rpc.engine." + protocol.getName()) == null) {
            conf.setClass("rpc.engine." + protocol.getName(), engine, RpcEngine.class);
        }
    }

    static synchronized RpcEngine getProtocolEngine(Class<?> protocol, Configuration conf) {
        RpcEngine engine = PROTOCOL_ENGINES.get(protocol);
        if (engine == null) {
            Class<?> impl = conf.getClass("rpc.engine." + protocol.getName(), WritableRpcEngine.class);
            engine = (RpcEngine)ReflectionUtils.newInstance(impl, conf);
            PROTOCOL_ENGINES.put(protocol, engine);
        }
        return engine;
    }

    public static <T> T waitForProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        return RPC.waitForProtocolProxy(protocol, clientVersion, addr, conf).getProxy();
    }

    public static <T> ProtocolProxy<T> waitForProtocolProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        return RPC.waitForProtocolProxy(protocol, clientVersion, addr, conf, Long.MAX_VALUE);
    }

    public static <T> T waitForProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, Configuration conf, long connTimeout) throws IOException {
        return RPC.waitForProtocolProxy(protocol, clientVersion, addr, conf, connTimeout).getProxy();
    }

    public static <T> ProtocolProxy<T> waitForProtocolProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, Configuration conf, long connTimeout) throws IOException {
        return RPC.waitForProtocolProxy(protocol, clientVersion, addr, conf, RPC.getRpcTimeout(conf), null, connTimeout);
    }

    public static <T> T waitForProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, Configuration conf, int rpcTimeout, long timeout) throws IOException {
        return RPC.waitForProtocolProxy(protocol, clientVersion, addr, conf, rpcTimeout, null, timeout).getProxy();
    }

    public static <T> ProtocolProxy<T> waitForProtocolProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, Configuration conf, int rpcTimeout, RetryPolicy connectionRetryPolicy, long timeout) throws IOException {
        long startTime = Time.now();
        while (true) {
            IOException ioe;
            try {
                return RPC.getProtocolProxy(protocol, clientVersion, addr, UserGroupInformation.getCurrentUser(), conf, NetUtils.getDefaultSocketFactory(conf), rpcTimeout, connectionRetryPolicy);
            }
            catch (ConnectException se) {
                LOG.info("Server at " + addr + " not available yet, Zzzzz...");
                ioe = se;
            }
            catch (SocketTimeoutException te) {
                LOG.info("Problem connecting to server: " + addr);
                ioe = te;
            }
            catch (NoRouteToHostException nrthe) {
                LOG.info("No route to host for server: " + addr);
                ioe = nrthe;
            }
            if (Time.now() - timeout >= startTime) {
                throw ioe;
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException("Interrupted waiting for the proxy");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw (IOException)new InterruptedIOException("Interrupted waiting for the proxy").initCause(ioe);
            }
        }
    }

    public static <T> T getProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, Configuration conf, SocketFactory factory) throws IOException {
        return RPC.getProtocolProxy(protocol, clientVersion, addr, conf, factory).getProxy();
    }

    public static <T> ProtocolProxy<T> getProtocolProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, Configuration conf, SocketFactory factory) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        return RPC.getProtocolProxy(protocol, clientVersion, addr, ugi, conf, factory);
    }

    public static <T> T getProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory) throws IOException {
        return RPC.getProtocolProxy(protocol, clientVersion, addr, ticket, conf, factory).getProxy();
    }

    public static <T> ProtocolProxy<T> getProtocolProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory) throws IOException {
        return RPC.getProtocolProxy(protocol, clientVersion, addr, ticket, conf, factory, RPC.getRpcTimeout(conf), null);
    }

    public static <T> T getProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout) throws IOException {
        return RPC.getProtocolProxy(protocol, clientVersion, addr, ticket, conf, factory, rpcTimeout, null).getProxy();
    }

    public static <T> ProtocolProxy<T> getProtocolProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout, RetryPolicy connectionRetryPolicy) throws IOException {
        return RPC.getProtocolProxy(protocol, clientVersion, addr, ticket, conf, factory, rpcTimeout, connectionRetryPolicy, null);
    }

    public static <T> ProtocolProxy<T> getProtocolProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout, RetryPolicy connectionRetryPolicy, AtomicBoolean fallbackToSimpleAuth) throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            SaslRpcServer.init(conf);
        }
        return RPC.getProtocolEngine(protocol, conf).getProxy(protocol, clientVersion, addr, ticket, conf, factory, rpcTimeout, connectionRetryPolicy, fallbackToSimpleAuth, null);
    }

    public static <T> ProtocolProxy<T> getProtocolProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout, RetryPolicy connectionRetryPolicy, AtomicBoolean fallbackToSimpleAuth, AlignmentContext alignmentContext) throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            SaslRpcServer.init(conf);
        }
        return RPC.getProtocolEngine(protocol, conf).getProxy(protocol, clientVersion, addr, ticket, conf, factory, rpcTimeout, connectionRetryPolicy, fallbackToSimpleAuth, alignmentContext);
    }

    public static <T> T getProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        return RPC.getProtocolProxy(protocol, clientVersion, addr, conf).getProxy();
    }

    public static InetSocketAddress getServerAddress(Object proxy) {
        return RPC.getConnectionIdForProxy(proxy).getAddress();
    }

    public static Client.ConnectionId getConnectionIdForProxy(Object proxy) {
        if (proxy instanceof ProtocolTranslator) {
            proxy = ((ProtocolTranslator)proxy).getUnderlyingProxyObject();
        }
        RpcInvocationHandler inv = (RpcInvocationHandler)Proxy.getInvocationHandler(proxy);
        return inv.getConnectionId();
    }

    public static <T> ProtocolProxy<T> getProtocolProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        return RPC.getProtocolProxy(protocol, clientVersion, addr, conf, NetUtils.getDefaultSocketFactory(conf));
    }

    public static void stopProxy(Object proxy) {
        if (proxy == null) {
            throw new HadoopIllegalArgumentException("Cannot close proxy since it is null");
        }
        try {
            if (proxy instanceof Closeable) {
                ((Closeable)proxy).close();
                return;
            }
            InvocationHandler handler = Proxy.getInvocationHandler(proxy);
            if (handler instanceof Closeable) {
                ((Closeable)((Object)handler)).close();
                return;
            }
        }
        catch (IOException e) {
            LOG.error("Closing proxy or invocation handler caused exception", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.error("RPC.stopProxy called on non proxy: class=" + proxy.getClass().getName(), (Throwable)e);
        }
        throw new HadoopIllegalArgumentException("Cannot close proxy - is not Closeable or does not provide closeable invocation handler " + proxy.getClass());
    }

    public static int getRpcTimeout(Configuration conf) {
        return conf.getInt("ipc.client.rpc-timeout.ms", 0);
    }

    public static abstract class Server
    extends org.apache.hadoop.ipc.Server {
        boolean verbose;
        private static final Pattern COMPLEX_SERVER_NAME_PATTERN = Pattern.compile("(?:[^\\$]*\\$)*([A-Za-z][^\\$]+)(?:\\$\\d+)?");
        ArrayList<Map<ProtoNameVer, ProtoClassProtoImpl>> protocolImplMapArray = new ArrayList(RpcKind.MAX_INDEX);

        static String serverNameFromClass(Class<?> clazz) {
            Matcher matcher;
            String name = clazz.getName();
            String[] names = clazz.getName().split("\\.", -1);
            if (names != null && names.length > 0) {
                name = names[names.length - 1];
            }
            if ((matcher = COMPLEX_SERVER_NAME_PATTERN.matcher(name)).find()) {
                return matcher.group(1);
            }
            return name;
        }

        Map<ProtoNameVer, ProtoClassProtoImpl> getProtocolImplMap(RpcKind rpcKind) {
            if (this.protocolImplMapArray.size() == 0) {
                for (int i = 0; i <= RpcKind.MAX_INDEX; ++i) {
                    this.protocolImplMapArray.add(new HashMap(10));
                }
            }
            return this.protocolImplMapArray.get(rpcKind.ordinal());
        }

        void registerProtocolAndImpl(RpcKind rpcKind, Class<?> protocolClass, Object protocolImpl) {
            String client;
            long version;
            String protocolName = RPC.getProtocolName(protocolClass);
            try {
                version = RPC.getProtocolVersion(protocolClass);
            }
            catch (Exception ex) {
                LOG.warn("Protocol " + protocolClass + " NOT registered as cannot get protocol version ");
                return;
            }
            this.getProtocolImplMap(rpcKind).put(new ProtoNameVer(protocolName, version), new ProtoClassProtoImpl(protocolClass, protocolImpl));
            if (LOG.isDebugEnabled()) {
                LOG.debug("RpcKind = " + (Object)((Object)rpcKind) + " Protocol Name = " + protocolName + " version=" + version + " ProtocolImpl=" + protocolImpl.getClass().getName() + " protocolClass=" + protocolClass.getName());
            }
            if ((client = SecurityUtil.getClientPrincipal(protocolClass, this.getConf())) != null) {
                try {
                    this.setPriorityLevel(UserGroupInformation.createRemoteUser(client), -1);
                }
                catch (Exception ex) {
                    LOG.warn("Failed to set scheduling priority for " + client, (Throwable)ex);
                }
            }
        }

        VerProtocolImpl[] getSupportedProtocolVersions(RpcKind rpcKind, String protocolName) {
            VerProtocolImpl[] resultk = new VerProtocolImpl[this.getProtocolImplMap(rpcKind).size()];
            int i = 0;
            for (Map.Entry<ProtoNameVer, ProtoClassProtoImpl> pv : this.getProtocolImplMap(rpcKind).entrySet()) {
                if (!pv.getKey().protocol.equals(protocolName)) continue;
                resultk[i++] = new VerProtocolImpl(pv.getKey().version, pv.getValue());
            }
            if (i == 0) {
                return null;
            }
            VerProtocolImpl[] result = new VerProtocolImpl[i];
            System.arraycopy(resultk, 0, result, 0, i);
            return result;
        }

        VerProtocolImpl getHighestSupportedProtocol(RpcKind rpcKind, String protocolName) {
            Long highestVersion = 0L;
            ProtoClassProtoImpl highest = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Size of protoMap for " + (Object)((Object)rpcKind) + " =" + this.getProtocolImplMap(rpcKind).size());
            }
            for (Map.Entry<ProtoNameVer, ProtoClassProtoImpl> pv : this.getProtocolImplMap(rpcKind).entrySet()) {
                if (!pv.getKey().protocol.equals(protocolName) || highest != null && pv.getKey().version <= highestVersion) continue;
                highest = pv.getValue();
                highestVersion = pv.getKey().version;
            }
            if (highest == null) {
                return null;
            }
            return new VerProtocolImpl(highestVersion, highest);
        }

        protected Server(String bindAddress, int port, Class<? extends Writable> paramClass, int handlerCount, int numReaders, int queueSizePerHandler, Configuration conf, String serverName, SecretManager<? extends TokenIdentifier> secretManager, String portRangeConfig) throws IOException {
            super(bindAddress, port, paramClass, handlerCount, numReaders, queueSizePerHandler, conf, serverName, secretManager, portRangeConfig);
            this.initProtocolMetaInfo(conf);
        }

        private void initProtocolMetaInfo(Configuration conf) {
            RPC.setProtocolEngine(conf, ProtocolMetaInfoPB.class, ProtobufRpcEngine.class);
            ProtocolMetaInfoServerSideTranslatorPB xlator = new ProtocolMetaInfoServerSideTranslatorPB(this);
            BlockingService protocolInfoBlockingService = ProtocolInfoProtos.ProtocolInfoService.newReflectiveBlockingService(xlator);
            this.addProtocol(RpcKind.RPC_PROTOCOL_BUFFER, ProtocolMetaInfoPB.class, protocolInfoBlockingService);
        }

        public Server addProtocol(RpcKind rpcKind, Class<?> protocolClass, Object protocolImpl) {
            this.registerProtocolAndImpl(rpcKind, protocolClass, protocolImpl);
            return this;
        }

        @Override
        public Writable call(RpcKind rpcKind, String protocol, Writable rpcRequest, long receiveTime) throws Exception {
            return Server.getRpcInvoker(rpcKind).call(this, protocol, rpcRequest, receiveTime);
        }

        static class VerProtocolImpl {
            final long version;
            final ProtoClassProtoImpl protocolTarget;

            VerProtocolImpl(long ver, ProtoClassProtoImpl protocolTarget) {
                this.version = ver;
                this.protocolTarget = protocolTarget;
            }
        }

        static class ProtoClassProtoImpl {
            final Class<?> protocolClass;
            final Object protocolImpl;

            ProtoClassProtoImpl(Class<?> protocolClass, Object protocolImpl) {
                this.protocolClass = protocolClass;
                this.protocolImpl = protocolImpl;
            }
        }

        static class ProtoNameVer {
            final String protocol;
            final long version;

            ProtoNameVer(String protocol, long ver) {
                this.protocol = protocol;
                this.version = ver;
            }

            public boolean equals(Object o) {
                if (o == null) {
                    return false;
                }
                if (this == o) {
                    return true;
                }
                if (!(o instanceof ProtoNameVer)) {
                    return false;
                }
                ProtoNameVer pv = (ProtoNameVer)o;
                return pv.protocol.equals(this.protocol) && pv.version == this.version;
            }

            public int hashCode() {
                return this.protocol.hashCode() * 37 + (int)this.version;
            }
        }
    }

    public static class Builder {
        private Class<?> protocol = null;
        private Object instance = null;
        private String bindAddress = "0.0.0.0";
        private int port = 0;
        private int numHandlers = 1;
        private int numReaders = -1;
        private int queueSizePerHandler = -1;
        private boolean verbose = false;
        private final Configuration conf;
        private SecretManager<? extends TokenIdentifier> secretManager = null;
        private String portRangeConfig = null;
        private AlignmentContext alignmentContext = null;

        public Builder(Configuration conf) {
            this.conf = conf;
        }

        public Builder setProtocol(Class<?> protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder setInstance(Object instance) {
            this.instance = instance;
            return this;
        }

        public Builder setBindAddress(String bindAddress) {
            this.bindAddress = bindAddress;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setNumHandlers(int numHandlers) {
            this.numHandlers = numHandlers;
            return this;
        }

        public Builder setnumReaders(int numReaders) {
            this.numReaders = numReaders;
            return this;
        }

        public Builder setQueueSizePerHandler(int queueSizePerHandler) {
            this.queueSizePerHandler = queueSizePerHandler;
            return this;
        }

        public Builder setVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder setSecretManager(SecretManager<? extends TokenIdentifier> secretManager) {
            this.secretManager = secretManager;
            return this;
        }

        public Builder setPortRangeConfig(String portRangeConfig) {
            this.portRangeConfig = portRangeConfig;
            return this;
        }

        public Builder setAlignmentContext(AlignmentContext alignmentContext) {
            this.alignmentContext = alignmentContext;
            return this;
        }

        public Server build() throws IOException, HadoopIllegalArgumentException {
            if (this.conf == null) {
                throw new HadoopIllegalArgumentException("conf is not set");
            }
            if (this.protocol == null) {
                throw new HadoopIllegalArgumentException("protocol is not set");
            }
            if (this.instance == null) {
                throw new HadoopIllegalArgumentException("instance is not set");
            }
            return RPC.getProtocolEngine(this.protocol, this.conf).getServer(this.protocol, this.instance, this.bindAddress, this.port, this.numHandlers, this.numReaders, this.queueSizePerHandler, this.verbose, this.conf, this.secretManager, this.portRangeConfig, this.alignmentContext);
        }
    }

    public static class VersionMismatch
    extends RpcServerException {
        private static final long serialVersionUID = 0L;
        private String interfaceName;
        private long clientVersion;
        private long serverVersion;

        public VersionMismatch(String interfaceName, long clientVersion, long serverVersion) {
            super("Protocol " + interfaceName + " version mismatch. (client = " + clientVersion + ", server = " + serverVersion + ")");
            this.interfaceName = interfaceName;
            this.clientVersion = clientVersion;
            this.serverVersion = serverVersion;
        }

        public String getInterfaceName() {
            return this.interfaceName;
        }

        public long getClientVersion() {
            return this.clientVersion;
        }

        public long getServerVersion() {
            return this.serverVersion;
        }

        @Override
        public RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto getRpcStatusProto() {
            return RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto.ERROR;
        }

        @Override
        public RpcHeaderProtos.RpcResponseHeaderProto.RpcErrorCodeProto getRpcErrorCodeProto() {
            return RpcHeaderProtos.RpcResponseHeaderProto.RpcErrorCodeProto.ERROR_RPC_VERSION_MISMATCH;
        }
    }

    static interface RpcInvoker {
        public Writable call(Server var1, String var2, Writable var3, long var4) throws Exception;
    }

    public static enum RpcKind {
        RPC_BUILTIN(1),
        RPC_WRITABLE(2),
        RPC_PROTOCOL_BUFFER(3);

        static final short MAX_INDEX;
        private final short value;

        private RpcKind(short val) {
            this.value = val;
        }

        static {
            MAX_INDEX = RpcKind.RPC_PROTOCOL_BUFFER.value;
        }
    }
}

