/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.xbill.DNS;

import java.util.Date;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.DNSOutput;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.Message;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.Name;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.Options;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.TSIGRecord;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.TextParseException;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.utils.HMAC;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.utils.base64;

public class TSIG {
    private static final String HMAC_MD5_STR = "HMAC-MD5.SIG-ALG.REG.INT.";
    private static final String HMAC_SHA1_STR = "hmac-sha1.";
    private static final String HMAC_SHA224_STR = "hmac-sha224.";
    private static final String HMAC_SHA256_STR = "hmac-sha256.";
    private static final String HMAC_SHA384_STR = "hmac-sha384.";
    private static final String HMAC_SHA512_STR = "hmac-sha512.";
    public static final Name HMAC_MD5;
    public static final Name HMAC;
    public static final Name HMAC_SHA1;
    public static final Name HMAC_SHA224;
    public static final Name HMAC_SHA256;
    public static final Name HMAC_SHA384;
    public static final Name HMAC_SHA512;
    public static final short FUDGE = 300;
    private Name name;
    private Name alg;
    private String digest;
    private int digestBlockLength;
    private byte[] key;

    private void getDigest() {
        if (this.alg.equals(HMAC_MD5)) {
            this.digest = "md5";
            this.digestBlockLength = 64;
        } else if (this.alg.equals(HMAC_SHA1)) {
            this.digest = "sha-1";
            this.digestBlockLength = 64;
        } else if (this.alg.equals(HMAC_SHA224)) {
            this.digest = "sha-224";
            this.digestBlockLength = 64;
        } else if (this.alg.equals(HMAC_SHA256)) {
            this.digest = "sha-256";
            this.digestBlockLength = 64;
        } else if (this.alg.equals(HMAC_SHA512)) {
            this.digest = "sha-512";
            this.digestBlockLength = 128;
        } else if (this.alg.equals(HMAC_SHA384)) {
            this.digest = "sha-384";
            this.digestBlockLength = 128;
        } else {
            throw new IllegalArgumentException("Invalid algorithm");
        }
    }

    public TSIG(Name algorithm, Name name, byte[] key) {
        this.name = name;
        this.alg = algorithm;
        this.key = key;
        this.getDigest();
    }

    public TSIG(Name name, byte[] key) {
        this(HMAC_MD5, name, key);
    }

    public TSIG(Name algorithm, String name, String key) {
        this.key = base64.fromString(key);
        if (this.key == null) {
            throw new IllegalArgumentException("Invalid TSIG key string");
        }
        try {
            this.name = Name.fromString(name, Name.root);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException("Invalid TSIG key name");
        }
        this.alg = algorithm;
        this.getDigest();
    }

    public TSIG(String algorithm, String name, String key) {
        this(HMAC_MD5, name, key);
        if (algorithm.equalsIgnoreCase("hmac-md5")) {
            this.alg = HMAC_MD5;
        } else if (algorithm.equalsIgnoreCase("hmac-sha1")) {
            this.alg = HMAC_SHA1;
        } else if (algorithm.equalsIgnoreCase("hmac-sha224")) {
            this.alg = HMAC_SHA224;
        } else if (algorithm.equalsIgnoreCase("hmac-sha256")) {
            this.alg = HMAC_SHA256;
        } else if (algorithm.equalsIgnoreCase("hmac-sha384")) {
            this.alg = HMAC_SHA384;
        } else if (algorithm.equalsIgnoreCase("hmac-sha512")) {
            this.alg = HMAC_SHA512;
        } else {
            throw new IllegalArgumentException("Invalid TSIG algorithm");
        }
        this.getDigest();
    }

    public TSIG(String name, String key) {
        this(HMAC_MD5, name, key);
    }

    public static TSIG fromString(String str) {
        String[] parts = str.split("[:/]", 3);
        if (parts.length < 2) {
            throw new IllegalArgumentException("Invalid TSIG key specification");
        }
        if (parts.length == 3) {
            try {
                return new TSIG(parts[0], parts[1], parts[2]);
            }
            catch (IllegalArgumentException e) {
                parts = str.split("[:/]", 2);
            }
        }
        return new TSIG(HMAC_MD5, parts[0], parts[1]);
    }

    public TSIGRecord generate(Message m3, byte[] b, int error, TSIGRecord old) {
        DNSOutput out;
        int fudge;
        Date timeSigned = error != 18 ? new Date() : old.getTimeSigned();
        HMAC hmac = null;
        if (error == 0 || error == 18) {
            hmac = new HMAC(this.digest, this.digestBlockLength, this.key);
        }
        if ((fudge = Options.intValue("tsigfudge")) < 0 || fudge > Short.MAX_VALUE) {
            fudge = 300;
        }
        if (old != null) {
            out = new DNSOutput();
            out.writeU16(old.getSignature().length);
            if (hmac != null) {
                hmac.update(out.toByteArray());
                hmac.update(old.getSignature());
            }
        }
        if (hmac != null) {
            hmac.update(b);
        }
        out = new DNSOutput();
        this.name.toWireCanonical(out);
        out.writeU16(255);
        out.writeU32(0L);
        this.alg.toWireCanonical(out);
        long time = timeSigned.getTime() / 1000L;
        int timeHigh = (int)(time >> 32);
        long timeLow = time & 0xFFFFFFFFL;
        out.writeU16(timeHigh);
        out.writeU32(timeLow);
        out.writeU16(fudge);
        out.writeU16(error);
        out.writeU16(0);
        if (hmac != null) {
            hmac.update(out.toByteArray());
        }
        byte[] signature = hmac != null ? hmac.sign() : new byte[]{};
        byte[] other = null;
        if (error == 18) {
            out = new DNSOutput();
            time = new Date().getTime() / 1000L;
            timeHigh = (int)(time >> 32);
            timeLow = time & 0xFFFFFFFFL;
            out.writeU16(timeHigh);
            out.writeU32(timeLow);
            other = out.toByteArray();
        }
        return new TSIGRecord(this.name, 255, 0L, this.alg, timeSigned, fudge, signature, m3.getHeader().getID(), error, other);
    }

    public void apply(Message m3, int error, TSIGRecord old) {
        TSIGRecord r = this.generate(m3, m3.toWire(), error, old);
        m3.addRecord(r, 3);
        m3.tsigState = 3;
    }

    public void apply(Message m3, TSIGRecord old) {
        this.apply(m3, 0, old);
    }

    public void applyStream(Message m3, TSIGRecord old, boolean first) {
        if (first) {
            this.apply(m3, old);
            return;
        }
        Date timeSigned = new Date();
        HMAC hmac = new HMAC(this.digest, this.digestBlockLength, this.key);
        int fudge = Options.intValue("tsigfudge");
        if (fudge < 0 || fudge > Short.MAX_VALUE) {
            fudge = 300;
        }
        DNSOutput out = new DNSOutput();
        out.writeU16(old.getSignature().length);
        hmac.update(out.toByteArray());
        hmac.update(old.getSignature());
        hmac.update(m3.toWire());
        out = new DNSOutput();
        long time = timeSigned.getTime() / 1000L;
        int timeHigh = (int)(time >> 32);
        long timeLow = time & 0xFFFFFFFFL;
        out.writeU16(timeHigh);
        out.writeU32(timeLow);
        out.writeU16(fudge);
        hmac.update(out.toByteArray());
        byte[] signature = hmac.sign();
        byte[] other = null;
        TSIGRecord r = new TSIGRecord(this.name, 255, 0L, this.alg, timeSigned, fudge, signature, m3.getHeader().getID(), 0, other);
        m3.addRecord(r, 3);
        m3.tsigState = 3;
    }

    public byte verify(Message m3, byte[] b, int length, TSIGRecord old) {
        int minDigestLength;
        m3.tsigState = 4;
        TSIGRecord tsig = m3.getTSIG();
        HMAC hmac = new HMAC(this.digest, this.digestBlockLength, this.key);
        if (tsig == null) {
            return 1;
        }
        if (!tsig.getName().equals(this.name) || !tsig.getAlgorithm().equals(this.alg)) {
            if (Options.check("verbose")) {
                System.err.println("BADKEY failure");
            }
            return 17;
        }
        long now = System.currentTimeMillis();
        long then = tsig.getTimeSigned().getTime();
        long fudge = tsig.getFudge();
        if (Math.abs(now - then) > fudge * 1000L) {
            if (Options.check("verbose")) {
                System.err.println("BADTIME failure");
            }
            return 18;
        }
        if (old != null && tsig.getError() != 17 && tsig.getError() != 16) {
            DNSOutput out = new DNSOutput();
            out.writeU16(old.getSignature().length);
            hmac.update(out.toByteArray());
            hmac.update(old.getSignature());
        }
        m3.getHeader().decCount(3);
        byte[] header = m3.getHeader().toWire();
        m3.getHeader().incCount(3);
        hmac.update(header);
        int len = m3.tsigstart - header.length;
        hmac.update(b, header.length, len);
        DNSOutput out = new DNSOutput();
        tsig.getName().toWireCanonical(out);
        out.writeU16(tsig.dclass);
        out.writeU32(tsig.ttl);
        tsig.getAlgorithm().toWireCanonical(out);
        long time = tsig.getTimeSigned().getTime() / 1000L;
        int timeHigh = (int)(time >> 32);
        long timeLow = time & 0xFFFFFFFFL;
        out.writeU16(timeHigh);
        out.writeU32(timeLow);
        out.writeU16(tsig.getFudge());
        out.writeU16(tsig.getError());
        if (tsig.getOther() != null) {
            out.writeU16(tsig.getOther().length);
            out.writeByteArray(tsig.getOther());
        } else {
            out.writeU16(0);
        }
        hmac.update(out.toByteArray());
        byte[] signature = tsig.getSignature();
        int digestLength = hmac.digestLength();
        int n = minDigestLength = this.digest.equals("md5") ? 10 : digestLength / 2;
        if (signature.length > digestLength) {
            if (Options.check("verbose")) {
                System.err.println("BADSIG: signature too long");
            }
            return 16;
        }
        if (signature.length < minDigestLength) {
            if (Options.check("verbose")) {
                System.err.println("BADSIG: signature too short");
            }
            return 16;
        }
        if (!hmac.verify(signature, true)) {
            if (Options.check("verbose")) {
                System.err.println("BADSIG: signature verification");
            }
            return 16;
        }
        m3.tsigState = 1;
        return 0;
    }

    public int verify(Message m3, byte[] b, TSIGRecord old) {
        return this.verify(m3, b, b.length, old);
    }

    public int recordLength() {
        return this.name.length() + 10 + this.alg.length() + 8 + 18 + 4 + 8;
    }

    static {
        HMAC = HMAC_MD5 = Name.fromConstantString(HMAC_MD5_STR);
        HMAC_SHA1 = Name.fromConstantString(HMAC_SHA1_STR);
        HMAC_SHA224 = Name.fromConstantString(HMAC_SHA224_STR);
        HMAC_SHA256 = Name.fromConstantString(HMAC_SHA256_STR);
        HMAC_SHA384 = Name.fromConstantString(HMAC_SHA384_STR);
        HMAC_SHA512 = Name.fromConstantString(HMAC_SHA512_STR);
    }

    public static class StreamVerifier {
        private TSIG key;
        private HMAC verifier;
        private int nresponses;
        private int lastsigned;
        private TSIGRecord lastTSIG;

        public StreamVerifier(TSIG tsig, TSIGRecord old) {
            this.key = tsig;
            this.verifier = new HMAC(this.key.digest, this.key.digestBlockLength, this.key.key);
            this.nresponses = 0;
            this.lastTSIG = old;
        }

        public int verify(Message m3, byte[] b) {
            TSIGRecord tsig = m3.getTSIG();
            ++this.nresponses;
            if (this.nresponses == 1) {
                int result = this.key.verify(m3, b, this.lastTSIG);
                if (result == 0) {
                    byte[] signature = tsig.getSignature();
                    DNSOutput out = new DNSOutput();
                    out.writeU16(signature.length);
                    this.verifier.update(out.toByteArray());
                    this.verifier.update(signature);
                }
                this.lastTSIG = tsig;
                return result;
            }
            if (tsig != null) {
                m3.getHeader().decCount(3);
            }
            byte[] header = m3.getHeader().toWire();
            if (tsig != null) {
                m3.getHeader().incCount(3);
            }
            this.verifier.update(header);
            int len = tsig == null ? b.length - header.length : m3.tsigstart - header.length;
            this.verifier.update(b, header.length, len);
            if (tsig == null) {
                boolean required;
                boolean bl = required = this.nresponses - this.lastsigned >= 100;
                if (required) {
                    m3.tsigState = 4;
                    return 1;
                }
                m3.tsigState = 2;
                return 0;
            }
            this.lastsigned = this.nresponses;
            this.lastTSIG = tsig;
            if (!tsig.getName().equals(this.key.name) || !tsig.getAlgorithm().equals(this.key.alg)) {
                if (Options.check("verbose")) {
                    System.err.println("BADKEY failure");
                }
                m3.tsigState = 4;
                return 17;
            }
            DNSOutput out = new DNSOutput();
            long time = tsig.getTimeSigned().getTime() / 1000L;
            int timeHigh = (int)(time >> 32);
            long timeLow = time & 0xFFFFFFFFL;
            out.writeU16(timeHigh);
            out.writeU32(timeLow);
            out.writeU16(tsig.getFudge());
            this.verifier.update(out.toByteArray());
            if (!this.verifier.verify(tsig.getSignature())) {
                if (Options.check("verbose")) {
                    System.err.println("BADSIG failure");
                }
                m3.tsigState = 4;
                return 16;
            }
            this.verifier.clear();
            out = new DNSOutput();
            out.writeU16(tsig.getSignature().length);
            this.verifier.update(out.toByteArray());
            this.verifier.update(tsig.getSignature());
            m3.tsigState = 1;
            return 0;
        }
    }
}

