/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.nio;

import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.shaded.com.google.errorprone.annotations.RestrictedApi;
import org.apache.hbase.thirdparty.io.netty.util.AbstractReferenceCounted;
import org.apache.hbase.thirdparty.io.netty.util.ReferenceCounted;
import org.apache.hbase.thirdparty.io.netty.util.ResourceLeakDetector;
import org.apache.hbase.thirdparty.io.netty.util.ResourceLeakDetectorFactory;
import org.apache.hbase.thirdparty.io.netty.util.ResourceLeakTracker;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RefCnt
extends AbstractReferenceCounted {
    private static final ResourceLeakDetector<RefCnt> detector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(RefCnt.class);
    private final ByteBuffAllocator.Recycler recycler;
    private final ResourceLeakTracker<RefCnt> leak;

    public static RefCnt create() {
        return new RefCnt(ByteBuffAllocator.NONE);
    }

    public static RefCnt create(ByteBuffAllocator.Recycler recycler) {
        return new RefCnt(recycler);
    }

    public RefCnt(ByteBuffAllocator.Recycler recycler) {
        this.recycler = recycler;
        this.leak = recycler == ByteBuffAllocator.NONE ? null : detector.track(this);
    }

    @Override
    public ReferenceCounted retain() {
        this.maybeRecord();
        return super.retain();
    }

    @Override
    public ReferenceCounted retain(int increment) {
        this.maybeRecord();
        return super.retain(increment);
    }

    @Override
    public boolean release() {
        this.maybeRecord();
        return super.release();
    }

    @Override
    public boolean release(int decrement) {
        this.maybeRecord();
        return super.release(decrement);
    }

    @Override
    protected final void deallocate() {
        this.recycler.free();
        if (this.leak != null) {
            this.leak.close(this);
        }
    }

    @Override
    public RefCnt touch() {
        this.maybeRecord();
        return this;
    }

    @Override
    public final ReferenceCounted touch(Object hint) {
        this.maybeRecord(hint);
        return this;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    public ByteBuffAllocator.Recycler getRecycler() {
        return this.recycler;
    }

    private void maybeRecord() {
        this.maybeRecord(null);
    }

    private void maybeRecord(Object hint) {
        if (this.leak != null) {
            this.leak.record(hint);
        }
    }
}

