/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.RawCell;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class IndividualBytesFieldCell
implements ExtendedCell,
Cloneable {
    private static final long FIXED_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 9 + 8 + 5 * ClassSize.REFERENCE);
    private final byte[] row;
    private final int rOffset;
    private final int rLength;
    private final byte[] family;
    private final int fOffset;
    private final int fLength;
    private final byte[] qualifier;
    private final int qOffset;
    private final int qLength;
    private final byte[] value;
    private final int vOffset;
    private final int vLength;
    private final byte[] tags;
    private final int tagsOffset;
    private final int tagsLength;
    private long timestamp;
    private final byte type;
    private long seqId;

    public IndividualBytesFieldCell(byte[] row, byte[] family, byte[] qualifier, long timestamp, KeyValue.Type type, byte[] value) {
        this(row, family, qualifier, timestamp, type, 0L, value, null);
    }

    public IndividualBytesFieldCell(byte[] row, byte[] family, byte[] qualifier, long timestamp, KeyValue.Type type, long seqId, byte[] value, byte[] tags) {
        this(row, 0, ArrayUtils.getLength(row), family, 0, ArrayUtils.getLength(family), qualifier, 0, ArrayUtils.getLength(qualifier), timestamp, type, seqId, value, 0, ArrayUtils.getLength(value), tags, 0, ArrayUtils.getLength(tags));
    }

    public IndividualBytesFieldCell(byte[] row, int rOffset, int rLength, byte[] family, int fOffset, int fLength, byte[] qualifier, int qOffset, int qLength, long timestamp, KeyValue.Type type, long seqId, byte[] value, int vOffset, int vLength, byte[] tags, int tagsOffset, int tagsLength) {
        KeyValue.checkParameters(row, rLength, family, fLength, qLength, vLength);
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + timestamp);
        }
        RawCell.checkForTagsLength(tagsLength);
        this.checkArrayBounds(row, rOffset, rLength);
        this.checkArrayBounds(family, fOffset, fLength);
        this.checkArrayBounds(qualifier, qOffset, qLength);
        this.checkArrayBounds(value, vOffset, vLength);
        this.checkArrayBounds(tags, tagsOffset, tagsLength);
        this.row = row;
        this.rOffset = rOffset;
        this.rLength = rLength;
        this.family = family;
        this.fOffset = fOffset;
        this.fLength = fLength;
        this.qualifier = qualifier;
        this.qOffset = qOffset;
        this.qLength = qLength;
        this.value = value;
        this.vOffset = vOffset;
        this.vLength = vLength;
        this.tags = tags;
        this.tagsOffset = tagsOffset;
        this.tagsLength = tagsLength;
        this.timestamp = timestamp;
        this.type = type.getCode();
        this.seqId = seqId;
    }

    private void checkArrayBounds(byte[] bytes, int offset, int length) {
        if (offset < 0 || length < 0) {
            throw new IllegalArgumentException("Negative number! offset=" + offset + "and length=" + length);
        }
        if (bytes == null && (offset != 0 || length != 0)) {
            throw new IllegalArgumentException("Null bytes array but offset=" + offset + "and length=" + length);
        }
        if (bytes != null && bytes.length < offset + length) {
            throw new IllegalArgumentException("Out of bounds! bytes.length=" + bytes.length + ", offset=" + offset + ", length=" + length);
        }
    }

    private long heapOverhead() {
        return FIXED_OVERHEAD + (long)ClassSize.ARRAY + (long)(this.family == null ? 0 : ClassSize.ARRAY) + (long)(this.qualifier == null ? 0 : ClassSize.ARRAY) + (long)(this.value == null ? 0 : ClassSize.ARRAY) + (long)(this.tags == null ? 0 : ClassSize.ARRAY);
    }

    @Override
    public byte[] getRowArray() {
        return this.row;
    }

    @Override
    public int getRowOffset() {
        return this.rOffset;
    }

    @Override
    public short getRowLength() {
        return (short)this.rLength;
    }

    @Override
    public byte[] getFamilyArray() {
        return this.family == null ? HConstants.EMPTY_BYTE_ARRAY : this.family;
    }

    @Override
    public int getFamilyOffset() {
        return this.fOffset;
    }

    @Override
    public byte getFamilyLength() {
        return (byte)this.fLength;
    }

    @Override
    public byte[] getQualifierArray() {
        return this.qualifier == null ? HConstants.EMPTY_BYTE_ARRAY : this.qualifier;
    }

    @Override
    public int getQualifierOffset() {
        return this.qOffset;
    }

    @Override
    public int getQualifierLength() {
        return this.qLength;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public byte getTypeByte() {
        return this.type;
    }

    @Override
    public long getSequenceId() {
        return this.seqId;
    }

    @Override
    public byte[] getValueArray() {
        return this.value == null ? HConstants.EMPTY_BYTE_ARRAY : this.value;
    }

    @Override
    public int getValueOffset() {
        return this.vOffset;
    }

    @Override
    public int getValueLength() {
        return this.vLength;
    }

    @Override
    public byte[] getTagsArray() {
        return this.tags == null ? HConstants.EMPTY_BYTE_ARRAY : this.tags;
    }

    @Override
    public int getTagsOffset() {
        return this.tagsOffset;
    }

    @Override
    public int getTagsLength() {
        return this.tagsLength;
    }

    @Override
    public long heapSize() {
        return this.heapOverhead() + (long)ClassSize.align(this.getRowLength()) + (long)ClassSize.align(this.getFamilyLength()) + (long)ClassSize.align(this.getQualifierLength()) + (long)ClassSize.align(this.getValueLength()) + (long)ClassSize.align(this.getTagsLength());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void setSequenceId(long seqId) {
        if (seqId < 0L) {
            throw new IllegalArgumentException("Sequence Id cannot be negative. ts=" + seqId);
        }
        this.seqId = seqId;
    }

    @Override
    public void setTimestamp(long ts) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        this.timestamp = ts;
    }

    @Override
    public void setTimestamp(byte[] ts) {
        this.setTimestamp(Bytes.toLong(ts, 0));
    }

    public String toString() {
        return CellUtil.toString(this, false);
    }
}

