/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.ChecksumException;
import com.sleepycat.je.utilint.Adler32;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;
import java.util.zip.Checksum;

public class ChecksumValidator {
    private static final boolean DEBUG = false;
    private final EnvironmentImpl envImpl;
    private Checksum cksum;

    public ChecksumValidator(EnvironmentImpl envImpl) {
        this.envImpl = envImpl;
        this.cksum = Adler32.makeChecksum();
    }

    public void reset() {
        this.cksum.reset();
    }

    public void update(ByteBuffer buf, int length) throws ChecksumException {
        if (buf == null) {
            throw new ChecksumException("null buffer given to checksum validation, probably  result of 0's in log file, len=" + length);
        }
        int bufStart = buf.position();
        this.update(buf.array(), bufStart + buf.arrayOffset(), length);
    }

    public void update(byte[] buf, int offset, int length) {
        this.cksum.update(buf, offset, length);
    }

    void validate(long expectedChecksum, long lsn) throws ChecksumException {
        if (expectedChecksum != this.cksum.getValue()) {
            if (this.envImpl.getDataEraser().isEntryErased(lsn)) {
                return;
            }
            throw new ChecksumException("Location " + DbLsn.getNoFormatString(lsn) + " expected " + expectedChecksum + " got " + this.cksum.getValue());
        }
    }

    public void validate(long expectedChecksum, long fileNum, long fileOffset) throws ChecksumException {
        this.validate(expectedChecksum, DbLsn.makeLsn(fileNum, fileOffset));
    }
}

