/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Durability;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.utilint.PropUtil;
import java.util.concurrent.TimeUnit;

public class TransactionConfig
implements Cloneable {
    public static final TransactionConfig DEFAULT = new TransactionConfig();
    private boolean sync = false;
    private boolean noSync = false;
    private boolean writeNoSync = false;
    private Durability durability = null;
    private ReplicaConsistencyPolicy consistencyPolicy;
    private boolean noWait = false;
    private boolean readUncommitted = false;
    private boolean readCommitted = false;
    private boolean serializableIsolation = false;
    private boolean readOnly = false;
    private boolean localWrite = false;
    private int txnTimeout = -1;

    public Durability getDurabilityFromSync(EnvironmentImpl envImpl) {
        if (this.sync) {
            return Durability.COMMIT_SYNC;
        }
        if (this.writeNoSync) {
            return Durability.COMMIT_WRITE_NO_SYNC;
        }
        if (this.noSync) {
            return Durability.COMMIT_NO_SYNC;
        }
        if (envImpl.isReplicated()) {
            return Durability.COMMIT_NO_SYNC;
        }
        return Durability.COMMIT_SYNC;
    }

    public TransactionConfig setSync(boolean sync) {
        this.setSyncVoid(sync);
        return this;
    }

    public void setSyncVoid(boolean sync) {
        TransactionConfig.checkMixedMode(sync, this.noSync, this.writeNoSync, this.durability);
        this.sync = sync;
    }

    public boolean getSync() {
        return this.sync;
    }

    public TransactionConfig setNoSync(boolean noSync) {
        this.setNoSyncVoid(noSync);
        return this;
    }

    public void setNoSyncVoid(boolean noSync) {
        TransactionConfig.checkMixedMode(this.sync, noSync, this.writeNoSync, this.durability);
        this.noSync = noSync;
    }

    public boolean getNoSync() {
        return this.noSync;
    }

    public TransactionConfig setWriteNoSync(boolean writeNoSync) {
        this.setWriteNoSyncVoid(writeNoSync);
        return this;
    }

    public void setWriteNoSyncVoid(boolean writeNoSync) {
        TransactionConfig.checkMixedMode(this.sync, this.noSync, writeNoSync, this.durability);
        this.writeNoSync = writeNoSync;
    }

    public boolean getWriteNoSync() {
        return this.writeNoSync;
    }

    public TransactionConfig setDurability(Durability durability) {
        this.setDurabilityVoid(durability);
        return this;
    }

    public void setDurabilityVoid(Durability durability) {
        TransactionConfig.checkMixedMode(this.sync, this.noSync, this.writeNoSync, durability);
        this.durability = durability;
    }

    public Durability getDurability() {
        return this.durability;
    }

    void overrideDurability(Durability durability) {
        this.sync = false;
        this.noSync = false;
        this.writeNoSync = false;
        this.durability = durability;
    }

    public TransactionConfig setConsistencyPolicy(ReplicaConsistencyPolicy consistencyPolicy) {
        this.setConsistencyPolicyVoid(consistencyPolicy);
        return this;
    }

    public void setConsistencyPolicyVoid(ReplicaConsistencyPolicy consistencyPolicy) {
        this.consistencyPolicy = consistencyPolicy;
    }

    public ReplicaConsistencyPolicy getConsistencyPolicy() {
        return this.consistencyPolicy;
    }

    public TransactionConfig setNoWait(boolean noWait) {
        this.setNoWaitVoid(noWait);
        return this;
    }

    public void setNoWaitVoid(boolean noWait) {
        this.noWait = noWait;
    }

    public boolean getNoWait() {
        return this.noWait;
    }

    public TransactionConfig setReadUncommitted(boolean readUncommitted) {
        this.setReadUncommittedVoid(readUncommitted);
        return this;
    }

    public void setReadUncommittedVoid(boolean readUncommitted) {
        this.readUncommitted = readUncommitted;
    }

    public boolean getReadUncommitted() {
        return this.readUncommitted;
    }

    public TransactionConfig setReadCommitted(boolean readCommitted) {
        this.setReadCommittedVoid(readCommitted);
        return this;
    }

    public void setReadCommittedVoid(boolean readCommitted) {
        this.readCommitted = readCommitted;
    }

    public boolean getReadCommitted() {
        return this.readCommitted;
    }

    public TransactionConfig setSerializableIsolation(boolean serializableIsolation) {
        this.setSerializableIsolationVoid(serializableIsolation);
        return this;
    }

    public void setSerializableIsolationVoid(boolean serializableIsolation) {
        this.serializableIsolation = serializableIsolation;
    }

    public boolean getSerializableIsolation() {
        return this.serializableIsolation;
    }

    public TransactionConfig setReadOnly(boolean readOnly) {
        this.setReadOnlyVoid(readOnly);
        return this;
    }

    public void setReadOnlyVoid(boolean readOnly) {
        if (this.localWrite && readOnly) {
            throw new IllegalArgumentException("localWrite and readOnly may not both be true");
        }
        this.readOnly = readOnly;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public TransactionConfig setLocalWrite(boolean localWrite) {
        this.setLocalWriteVoid(localWrite);
        return this;
    }

    public void setLocalWriteVoid(boolean localWrite) {
        if (localWrite && this.readOnly) {
            throw new IllegalArgumentException("localWrite and readOnly may not both be true");
        }
        this.localWrite = localWrite;
    }

    public boolean getLocalWrite() {
        return this.localWrite;
    }

    public TransactionConfig setTxnTimeout(long timeOut, TimeUnit unit) {
        this.setTxnTimeoutVoid(timeOut, unit);
        return this;
    }

    public void setTxnTimeoutVoid(long timeOut, TimeUnit unit) {
        this.txnTimeout = PropUtil.durationToMillis(timeOut, unit);
    }

    public long getTxnTimeout(TimeUnit unit) {
        if (unit != null && this.txnTimeout == -1) {
            return -1L;
        }
        return PropUtil.millisToDuration(this.txnTimeout, unit);
    }

    public TransactionConfig clone() {
        try {
            return (TransactionConfig)super.clone();
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    static void checkMixedMode(boolean sync, boolean noSync, boolean writeNoSync, Durability durability) throws IllegalArgumentException {
        if ((sync || noSync || writeNoSync) && durability != null) {
            throw new IllegalArgumentException("Mixed use of deprecated and current durability APIs is not supported");
        }
        if (sync && noSync || sync && writeNoSync || noSync && writeNoSync) {
            throw new IllegalArgumentException("Only one of TxnSync, TxnNoSync, and TxnWriteNoSync can be set.");
        }
    }

    public String toString() {
        return "sync=" + this.sync + "\nnoSync=" + this.noSync + "\nwriteNoSync=" + this.writeNoSync + "\ndurability=" + this.durability + "\nconsistencyPolicy=" + this.consistencyPolicy + "\nnoWait=" + this.noWait + "\nreadUncommitted=" + this.readUncommitted + "\nreadCommitted=" + this.readCommitted + "\nSerializableIsolation=" + this.serializableIsolation + "\n";
    }
}

