/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.tinkergraph.process.traversal.strategy.optimization.TinkerGraphCountStrategy;
import org.apache.tinkerpop.gremlin.tinkergraph.process.traversal.strategy.optimization.TinkerGraphStepStrategy;
import org.apache.tinkerpop.gremlin.tinkergraph.services.TinkerServiceRegistry;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.AbstractTinkerGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerEdge;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraphIterator;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerHelper;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerIndex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

@Graph.OptIns(value={@Graph.OptIn(value="org.apache.tinkerpop.gremlin.structure.StructureStandardSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.structure.StructureIntegrateSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessStandardSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessComputerSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessLimitedStandardSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessLimitedComputerSuite")})
public final class TinkerGraph
extends AbstractTinkerGraph {
    private static final Configuration EMPTY_CONFIGURATION;
    private final TinkerGraphFeatures features = new TinkerGraphFeatures();
    protected Map<Object, Vertex> vertices = new ConcurrentHashMap<Object, Vertex>();
    protected Map<Object, Edge> edges = new ConcurrentHashMap<Object, Edge>();

    private TinkerGraph(Configuration configuration) {
        this.configuration = configuration;
        this.vertexIdManager = TinkerGraph.selectIdManager(configuration, "gremlin.tinkergraph.vertexIdManager", Vertex.class);
        this.edgeIdManager = TinkerGraph.selectIdManager(configuration, "gremlin.tinkergraph.edgeIdManager", Edge.class);
        this.vertexPropertyIdManager = TinkerGraph.selectIdManager(configuration, "gremlin.tinkergraph.vertexPropertyIdManager", VertexProperty.class);
        this.defaultVertexPropertyCardinality = VertexProperty.Cardinality.valueOf((String)configuration.getString("gremlin.tinkergraph.defaultVertexPropertyCardinality", VertexProperty.Cardinality.single.name()));
        this.allowNullPropertyValues = configuration.getBoolean("gremlin.tinkergraph.allowNullPropertyValues", false);
        this.graphLocation = configuration.getString("gremlin.tinkergraph.graphLocation", null);
        this.graphFormat = configuration.getString("gremlin.tinkergraph.graphFormat", null);
        if (this.graphLocation != null && null == this.graphFormat || null == this.graphLocation && this.graphFormat != null) {
            throw new IllegalStateException(String.format("The %s and %s must both be specified if either is present", "gremlin.tinkergraph.graphLocation", "gremlin.tinkergraph.graphFormat"));
        }
        if (this.graphLocation != null) {
            this.loadGraph();
        }
        this.serviceRegistry = new TinkerServiceRegistry(this);
        configuration.getList(String.class, "gremlin.tinkergraph.service", Collections.emptyList()).forEach(serviceClass -> this.serviceRegistry.registerService(this.instantiate((String)serviceClass)));
    }

    public static TinkerGraph open() {
        return TinkerGraph.open(EMPTY_CONFIGURATION);
    }

    public static TinkerGraph open(Configuration configuration) {
        return new TinkerGraph(configuration);
    }

    @Override
    public Vertex addVertex(Object ... keyValues) {
        ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        Object idValue = this.vertexIdManager.convert(ElementHelper.getIdValue((Object[])keyValues).orElse(null));
        String label = ElementHelper.getLabelValue((Object[])keyValues).orElse("vertex");
        if (null != idValue) {
            if (this.vertices.containsKey(idValue)) {
                throw Graph.Exceptions.vertexWithIdAlreadyExists(idValue);
            }
        } else {
            idValue = this.vertexIdManager.getNextId(this);
        }
        TinkerVertex vertex = new TinkerVertex(idValue, label, this);
        ElementHelper.attachProperties((Vertex)vertex, (VertexProperty.Cardinality)VertexProperty.Cardinality.list, (Object[])keyValues);
        this.vertices.put(vertex.id(), vertex);
        return vertex;
    }

    @Override
    public void removeVertex(Object vertexId) {
        this.vertices.remove(vertexId);
    }

    @Override
    public Edge addEdge(TinkerVertex outVertex, TinkerVertex inVertex, String label, Object ... keyValues) {
        ElementHelper.validateLabel((String)label);
        ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        Object idValue = this.edgeIdManager.convert(ElementHelper.getIdValue((Object[])keyValues).orElse(null));
        if (null != idValue) {
            if (this.edges.containsKey(idValue)) {
                throw Graph.Exceptions.edgeWithIdAlreadyExists(idValue);
            }
        } else {
            idValue = this.edgeIdManager.getNextId(this);
        }
        TinkerEdge edge = new TinkerEdge(idValue, outVertex, label, inVertex);
        ElementHelper.attachProperties((Element)edge, (Object[])keyValues);
        this.edges.put(edge.id(), edge);
        this.addOutEdge(outVertex, label, edge);
        this.addInEdge(inVertex, label, edge);
        return edge;
    }

    @Override
    public void removeEdge(Object edgeId) {
        Set<Edge> edges;
        Edge edge = this.edges.get(edgeId);
        if (null == edge) {
            return;
        }
        TinkerVertex outVertex = (TinkerVertex)edge.outVertex();
        TinkerVertex inVertex = (TinkerVertex)edge.inVertex();
        if (null != outVertex && null != outVertex.outEdges && null != (edges = outVertex.outEdges.get(edge.label()))) {
            edges.removeIf(e -> e.id() == edgeId);
        }
        if (null != inVertex && null != inVertex.inEdges && null != (edges = inVertex.inEdges.get(edge.label()))) {
            edges.removeIf(e -> e.id() == edgeId);
        }
        this.edges.remove(edgeId);
    }

    @Override
    public void clear() {
        super.clear();
        this.vertices.clear();
        this.edges.clear();
    }

    @Override
    public Transaction tx() {
        throw Graph.Exceptions.transactionsNotSupported();
    }

    @Override
    public int getVerticesCount() {
        return this.vertices.size();
    }

    @Override
    public boolean hasVertex(Object id) {
        return this.vertices.containsKey(id);
    }

    @Override
    public int getEdgesCount() {
        return this.edges.size();
    }

    @Override
    public boolean hasEdge(Object id) {
        return this.edges.containsKey(id);
    }

    public TinkerServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public Vertex vertex(Object vertexId) {
        return this.vertices.get(this.vertexIdManager.convert(vertexId));
    }

    @Override
    public Iterator<Vertex> vertices(Object ... vertexIds) {
        return this.createElementIterator(Vertex.class, this.vertices, this.vertexIdManager, vertexIds);
    }

    @Override
    public Iterator<Edge> edges(Object ... edgeIds) {
        return this.createElementIterator(Edge.class, this.edges, this.edgeIdManager, edgeIds);
    }

    @Override
    public Edge edge(Object edgeId) {
        return this.edges.get(this.edgeIdManager.convert(edgeId));
    }

    private <T extends Element> Iterator<T> createElementIterator(Class<T> clazz, Map<Object, T> elements, AbstractTinkerGraph.IdManager idManager, Object ... ids) {
        if (0 != ids.length) {
            List<Object> idList = Arrays.asList(ids);
            return new TinkerGraphIterator(IteratorUtils.filter(IteratorUtils.map(idList, id -> {
                if (null == id) {
                    return null;
                }
                Object iid = clazz.isAssignableFrom(id.getClass()) ? ((Element)clazz.cast(id)).id() : idManager.convert(id);
                return (Element)elements.get(idManager.convert(iid));
            }).iterator(), Objects::nonNull));
        }
        TinkerGraphIterator<T> iterator = new TinkerGraphIterator<T>(elements.values().iterator());
        return TinkerHelper.inComputerMode(this) ? (clazz.equals(Vertex.class) ? IteratorUtils.filter(iterator, t -> this.graphComputerView.legalVertex((Vertex)t)) : IteratorUtils.filter(iterator, t -> this.graphComputerView.legalEdge(t.outVertex(), (Edge)t))) : iterator;
    }

    @Override
    protected void addOutEdge(TinkerVertex vertex, String label, Edge edge) {
        Set<Edge> edges;
        if (null == vertex.outEdges) {
            vertex.outEdges = new HashMap<String, Set<Edge>>();
        }
        if (null == (edges = vertex.outEdges.get(label))) {
            edges = new HashSet<Edge>();
            vertex.outEdges.put(label, edges);
        }
        edges.add(edge);
    }

    @Override
    protected void addInEdge(TinkerVertex vertex, String label, Edge edge) {
        Set<Edge> edges;
        if (null == vertex.inEdges) {
            vertex.inEdges = new HashMap<String, Set<Edge>>();
        }
        if (null == (edges = vertex.inEdges.get(label))) {
            edges = new HashSet<Edge>();
            vertex.inEdges.put(label, edges);
        }
        edges.add(edge);
    }

    public Graph.Features features() {
        return this.features;
    }

    public <E extends Element> void createIndex(String key, Class<E> elementClass) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            if (null == this.vertexIndex) {
                this.vertexIndex = new TinkerIndex<TinkerVertex>(this, TinkerVertex.class);
            }
            this.vertexIndex.createKeyIndex(key);
        } else if (Edge.class.isAssignableFrom(elementClass)) {
            if (null == this.edgeIndex) {
                this.edgeIndex = new TinkerIndex<TinkerEdge>(this, TinkerEdge.class);
            }
            this.edgeIndex.createKeyIndex(key);
        } else {
            throw new IllegalArgumentException("Class is not indexable: " + elementClass);
        }
    }

    public <E extends Element> void dropIndex(String key, Class<E> elementClass) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            if (null != this.vertexIndex) {
                this.vertexIndex.dropKeyIndex(key);
            }
        } else if (Edge.class.isAssignableFrom(elementClass)) {
            if (null != this.edgeIndex) {
                this.edgeIndex.dropKeyIndex(key);
            }
        } else {
            throw new IllegalArgumentException("Class is not indexable: " + elementClass);
        }
    }

    static {
        TraversalStrategies.GlobalCache.registerStrategies(TinkerGraph.class, (TraversalStrategies)TraversalStrategies.GlobalCache.getStrategies(Graph.class).clone().addStrategies(new TraversalStrategy[]{TinkerGraphStepStrategy.instance(), TinkerGraphCountStrategy.instance()}));
        EMPTY_CONFIGURATION = new BaseConfiguration(){
            {
                this.setProperty("gremlin.graph", TinkerGraph.class.getName());
            }
        };
    }

    public class TinkerGraphGraphFeatures
    implements Graph.Features.GraphFeatures {
        private TinkerGraphGraphFeatures() {
        }

        public boolean supportsConcurrentAccess() {
            return false;
        }

        public boolean supportsTransactions() {
            return false;
        }

        public boolean supportsThreadedTransactions() {
            return false;
        }

        public boolean supportsServiceCall() {
            return true;
        }
    }

    public class TinkerGraphFeatures
    implements Graph.Features {
        private final TinkerGraphGraphFeatures graphFeatures;
        private final AbstractTinkerGraph.TinkerGraphEdgeFeatures edgeFeatures;
        private final AbstractTinkerGraph.TinkerGraphVertexFeatures vertexFeatures;

        private TinkerGraphFeatures() {
            this.graphFeatures = new TinkerGraphGraphFeatures();
            this.edgeFeatures = new AbstractTinkerGraph.TinkerGraphEdgeFeatures();
            this.vertexFeatures = new AbstractTinkerGraph.TinkerGraphVertexFeatures();
        }

        public Graph.Features.GraphFeatures graph() {
            return this.graphFeatures;
        }

        public Graph.Features.EdgeFeatures edge() {
            return this.edgeFeatures;
        }

        public Graph.Features.VertexFeatures vertex() {
            return this.vertexFeatures;
        }

        public String toString() {
            return StringFactory.featureString((Graph.Features)this);
        }
    }
}

