/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.util.List;
import org.apache.commons.collections.IteratorUtils;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;

public class EdgeSerializer
extends SimpleTypeSerializer<Edge> {
    public EdgeSerializer() {
        super(DataType.EDGE);
    }

    @Override
    protected Edge readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        Object id = context.read(buffer);
        String label = context.readValue(buffer, String.class, false);
        Object inVId = context.read(buffer);
        String inVLabel = context.readValue(buffer, String.class, false);
        Object outVId = context.read(buffer);
        String outVLabel = context.readValue(buffer, String.class, false);
        context.read(buffer);
        List properties = (List)context.read(buffer);
        return new DetachedEdge(id, label, properties, outVId, outVLabel, inVId, inVLabel);
    }

    @Override
    protected void writeValue(Edge value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        context.write(value.id(), buffer);
        context.writeValue(value.label(), buffer, false);
        context.write(value.inVertex().id(), buffer);
        context.writeValue(value.inVertex().label(), buffer, false);
        context.write(value.outVertex().id(), buffer);
        context.writeValue(value.outVertex().label(), buffer, false);
        context.write(null, buffer);
        if (value.properties(new String[0]) == null) {
            context.write(null, buffer);
        } else {
            List asList = IteratorUtils.toList(value.properties(new String[0]));
            context.write(asList, buffer);
        }
    }
}

