/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum ElasticMajorVersion {
    SIX(6),
    SEVEN(7),
    EIGHT(8);

    static final Pattern PATTERN;
    final int value;

    private ElasticMajorVersion(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ElasticMajorVersion parse(String value) {
        Matcher m = value != null ? PATTERN.matcher(value) : null;
        switch (m != null && m.find() ? Integer.parseInt(m.group(1)) : -1) {
            case 6: {
                return SIX;
            }
            case 7: {
                return SEVEN;
            }
            case 8: {
                return EIGHT;
            }
        }
        throw new IllegalArgumentException("Unsupported Elasticsearch server major version: " + value);
    }

    static {
        PATTERN = Pattern.compile("(\\d+)\\.\\d+\\.\\d+.*");
    }
}

