/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.olap.job;

import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.olap.AbstractScanJob;
import org.janusgraph.graphdb.query.vertex.VertexCentricQueryBuilder;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.transaction.StandardTransactionBuilder;
import org.janusgraph.graphdb.vertices.CacheVertex;

public class GhostVertexRemover
extends AbstractScanJob {
    private static final int RELATION_COUNT_LIMIT = 10000;
    private static final SliceQuery EVERYTHING_QUERY = new SliceQuery(BufferUtil.zeroBuffer(1), BufferUtil.oneBuffer(4));
    public static final String REMOVED_RELATION_COUNT = "removed-relations";
    public static final String REMOVED_VERTEX_COUNT = "removed-vertices";
    public static final String SKIPPED_GHOST_LIMIT_COUNT = "skipped-ghosts";
    private final SliceQuery everythingQueryLimit = EVERYTHING_QUERY.updateLimit(10000);
    private Instant jobStartTime;

    public GhostVertexRemover(JanusGraph graph) {
        super(graph);
    }

    public GhostVertexRemover() {
        this((JanusGraph)null);
    }

    protected GhostVertexRemover(GhostVertexRemover copy) {
        super(copy);
    }

    @Override
    public GhostVertexRemover clone() {
        return new GhostVertexRemover(this);
    }

    @Override
    public void workerIterationStart(Configuration jobConfig, Configuration graphConfig, ScanMetrics metrics) {
        Preconditions.checkArgument((boolean)jobConfig.has(GraphDatabaseConfiguration.JOB_START_TIME, new String[0]), (Object)"Invalid configuration for this job. Start time is required.");
        this.jobStartTime = Instant.ofEpochMilli(jobConfig.get(GraphDatabaseConfiguration.JOB_START_TIME, new String[0]));
        this.open(graphConfig);
    }

    @Override
    protected StandardJanusGraphTx startTransaction(StandardJanusGraph graph) {
        assert (this.jobStartTime != null);
        StandardTransactionBuilder txb = graph.buildTransaction();
        txb.commitTime(this.jobStartTime);
        txb.checkExternalVertexExistence(false);
        txb.checkInternalVertexExistence(false);
        return (StandardJanusGraphTx)txb.start();
    }

    @Override
    public void process(StaticBuffer key, Map<SliceQuery, EntryList> entries, ScanMetrics metrics) {
        Object vertexId = this.getVertexId(key);
        assert (entries.size() == 1);
        assert (entries.get(this.everythingQueryLimit) != null);
        EntryList everything = entries.get(this.everythingQueryLimit);
        if (!this.isGhostVertex(vertexId, everything)) {
            return;
        }
        if (everything.size() >= 10000) {
            metrics.incrementCustom(SKIPPED_GHOST_LIMIT_COUNT);
            return;
        }
        InternalVertex vertex = this.tx.getInternalVertex(vertexId);
        Preconditions.checkArgument((boolean)(vertex instanceof CacheVertex), (Object)"The bounding transaction is not configured correctly");
        CacheVertex v = (CacheVertex)vertex;
        v.loadRelations(EVERYTHING_QUERY, input -> everything);
        int removedRelations = 0;
        Iterator<JanusGraphRelation> iterator = ((VertexCentricQueryBuilder)v.query().noPartitionRestriction()).relations().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
            ++removedRelations;
        }
        v.remove();
        metrics.incrementCustom(REMOVED_VERTEX_COUNT);
        metrics.incrementCustom(REMOVED_RELATION_COUNT, removedRelations);
    }

    @Override
    public void workerIterationEnd(ScanMetrics metrics) {
        this.tx.commit();
        this.close();
    }

    @Override
    public List<SliceQuery> getQueries() {
        return Collections.singletonList(this.everythingQueryLimit);
    }
}

