/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.JanusGraphManagerUtility;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.configuration.backend.CommonsConfiguration;
import org.janusgraph.graphdb.configuration.builder.GraphDatabaseConfigurationBuilder;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.janusgraph.graphdb.management.ConfigurationManagementGraph;
import org.janusgraph.graphdb.management.JanusGraphManager;
import org.janusgraph.graphdb.management.utils.ConfigurationManagementGraphNotEnabledException;
import org.janusgraph.util.system.ConfigurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfiguredGraphFactory {
    private static final Logger log = LoggerFactory.getLogger(ConfiguredGraphFactory.class);

    public static synchronized JanusGraph create(String graphName) {
        ConfigurationManagementGraph configManagementGraph = ConfiguredGraphFactory.getConfigGraphManagementInstance();
        Map<String, Object> graphConfigMap = configManagementGraph.getConfiguration(graphName);
        Preconditions.checkState((null == graphConfigMap ? 1 : 0) != 0, (Object)String.format("Configuration for graph %s already exists.", graphName));
        Map<String, Object> templateConfigMap = configManagementGraph.getTemplateConfiguration();
        Preconditions.checkNotNull(templateConfigMap, (Object)"Please create a template Configuration using the ConfigurationManagementGraph#createTemplateConfiguration API.");
        templateConfigMap.put(ConfigurationManagementGraph.PROPERTY_GRAPH_NAME, graphName);
        templateConfigMap.put("Created_Using_Template", true);
        JanusGraphManager jgm = JanusGraphManagerUtility.getInstance();
        Preconditions.checkNotNull((Object)jgm, (Object)"Gremlin Server must be configured to use the JanusGraphManager.");
        CommonsConfiguration config = new CommonsConfiguration((Configuration)ConfigurationUtil.loadMapConfiguration(templateConfigMap));
        JanusGraph g = (JanusGraph)jgm.openGraph(graphName, gName -> new StandardJanusGraph(new GraphDatabaseConfigurationBuilder().build(config)));
        configManagementGraph.createConfiguration((Configuration)new MapConfiguration(templateConfigMap));
        return g;
    }

    public static JanusGraph open(String graphName) {
        ConfigurationManagementGraph configManagementGraph = ConfiguredGraphFactory.getConfigGraphManagementInstance();
        Map<String, Object> graphConfigMap = configManagementGraph.getConfiguration(graphName);
        Preconditions.checkNotNull(graphConfigMap, (Object)"Please create configuration for this graph using the ConfigurationManagementGraph#createConfiguration API.");
        JanusGraphManager jgm = JanusGraphManagerUtility.getInstance();
        Preconditions.checkNotNull((Object)jgm, (Object)"Gremlin Server must be configured to use the JanusGraphManager.");
        CommonsConfiguration config = new CommonsConfiguration((Configuration)ConfigurationUtil.loadMapConfiguration(graphConfigMap));
        return (JanusGraph)jgm.openGraph(graphName, gName -> new StandardJanusGraph(new GraphDatabaseConfigurationBuilder().build(config)));
    }

    public static Set<String> getGraphNames() {
        ConfigurationManagementGraph configManagementGraph = ConfiguredGraphFactory.getConfigGraphManagementInstance();
        return configManagementGraph.getGraphNames();
    }

    public static JanusGraph close(String graphName) throws Exception {
        JanusGraphManager jgm = JanusGraphManagerUtility.getInstance();
        Preconditions.checkNotNull((Object)jgm, (Object)"Gremlin Server must be configured to use the JanusGraphManager.");
        Graph graph = jgm.removeGraph(graphName);
        jgm.removeTraversalSource(ConfiguredGraphFactory.toTraversalSourceName(graphName));
        if (null != graph) {
            graph.close();
        }
        return (JanusGraph)graph;
    }

    public static void drop(String graphName) {
        JanusGraphManager jgm = JanusGraphManagerUtility.getInstance();
        Preconditions.checkNotNull((Object)jgm, (Object)"Gremlin Server must be configured to use the JanusGraphManager.");
        StandardJanusGraph graph = (StandardJanusGraph)jgm.getGraph(graphName);
        if (graph != null) {
            DropGraphOnEvictionTrigger dropTrigger = new DropGraphOnEvictionTrigger(graphName, graph, ConfiguredGraphFactory.getConfigGraphManagementInstance());
            ConfiguredGraphFactory.removeGraphFromCache(graph, dropTrigger);
            dropTrigger.waitUntilDropFinish();
        } else {
            log.error(String.format("Failed to open graph %s. Thus, it and its traversal will not be bound on this server.", graphName));
        }
    }

    private static ConfigurationManagementGraph getConfigGraphManagementInstance() {
        ConfigurationManagementGraph configManagementGraph;
        try {
            configManagementGraph = ConfigurationManagementGraph.getInstance();
        }
        catch (ConfigurationManagementGraphNotEnabledException e) {
            throw new RuntimeException(e);
        }
        return configManagementGraph;
    }

    public static void createConfiguration(Configuration config) {
        ConfigurationManagementGraph configManagementGraph = ConfiguredGraphFactory.getConfigGraphManagementInstance();
        configManagementGraph.createConfiguration(config);
    }

    public static void createTemplateConfiguration(Configuration config) {
        ConfigurationManagementGraph configManagementGraph = ConfiguredGraphFactory.getConfigGraphManagementInstance();
        configManagementGraph.createTemplateConfiguration(config);
    }

    public static void updateConfiguration(String graphName, Configuration config) {
        ConfigurationManagementGraph configManagementGraph = ConfiguredGraphFactory.getConfigGraphManagementInstance();
        ConfiguredGraphFactory.removeGraphFromCache(graphName);
        configManagementGraph.updateConfiguration(graphName, config);
    }

    public static void updateTemplateConfiguration(Configuration config) {
        ConfigurationManagementGraph configManagementGraph = ConfiguredGraphFactory.getConfigGraphManagementInstance();
        configManagementGraph.updateTemplateConfiguration(config);
    }

    public static void removeConfiguration(String graphName) {
        ConfigurationManagementGraph configManagementGraph = ConfiguredGraphFactory.getConfigGraphManagementInstance();
        ConfiguredGraphFactory.removeGraphFromCache(graphName);
        configManagementGraph.removeConfiguration(graphName);
    }

    private static void removeGraphFromCache(String graphName) {
        try {
            JanusGraph graph = ConfiguredGraphFactory.open(graphName);
            ConfiguredGraphFactory.removeGraphFromCache(graph, null);
        }
        catch (Exception e) {
            log.error(String.format("Failed to open graph %s with the following error:\n %s.\nThus, it and its traversal will not be bound on this server.", graphName, e));
        }
    }

    private static void removeGraphFromCache(JanusGraph graph, Callable<Boolean> evictionTrigger) {
        JanusGraphManager jgm = JanusGraphManagerUtility.getInstance();
        Preconditions.checkNotNull((Object)jgm, (Object)"Gremlin Server must be configured to use the JanusGraphManager.");
        String graphName = ((StandardJanusGraph)graph).getGraphName();
        jgm.removeGraph(graphName);
        jgm.removeTraversalSource(ConfiguredGraphFactory.toTraversalSourceName(graphName));
        ManagementSystem mgmt = (ManagementSystem)graph.openManagement();
        mgmt.evictGraphFromCache(evictionTrigger);
        mgmt.commit();
    }

    public static void removeTemplateConfiguration() {
        ConfigurationManagementGraph configManagementGraph = ConfiguredGraphFactory.getConfigGraphManagementInstance();
        configManagementGraph.removeTemplateConfiguration();
    }

    public static Map<String, Object> getConfiguration(String configName) {
        ConfigurationManagementGraph configManagementGraph = ConfiguredGraphFactory.getConfigGraphManagementInstance();
        return configManagementGraph.getConfiguration(configName);
    }

    public static List<Map<String, Object>> getConfigurations() {
        ConfigurationManagementGraph configManagementGraph = ConfiguredGraphFactory.getConfigGraphManagementInstance();
        return configManagementGraph.getConfigurations();
    }

    public static Map<String, Object> getTemplateConfiguration() {
        ConfigurationManagementGraph configManagementGraph = ConfiguredGraphFactory.getConfigGraphManagementInstance();
        return configManagementGraph.getTemplateConfiguration();
    }

    public static String toTraversalSourceName(String graphName) {
        return graphName + "_traversal";
    }

    private static class DropGraphOnEvictionTrigger
    implements Callable<Boolean> {
        private static final Logger log = LoggerFactory.getLogger(DropGraphOnEvictionTrigger.class);
        private final String graphName;
        private final JanusGraph graph;
        private final ConfigurationManagementGraph configManagementGraph;
        private final CountDownLatch latch;

        private DropGraphOnEvictionTrigger(String graphName, JanusGraph graph, ConfigurationManagementGraph configManagementGraph) {
            this.graphName = graphName;
            this.graph = graph;
            this.configManagementGraph = configManagementGraph;
            this.latch = new CountDownLatch(1);
        }

        @Override
        public Boolean call() throws BackendException {
            try {
                log.info("Graph {} has been removed from the graph cache on every JanusGraph node in the cluster.", (Object)this.graphName);
                log.warn("Attempting to drop the graph {}.", (Object)this.graphName);
                this.configManagementGraph.removeConfiguration(this.graphName);
                JanusGraphFactory.drop(this.graph);
                log.warn("Graph {} has been dropped.", (Object)this.graphName);
                Boolean bl = true;
                return bl;
            }
            finally {
                this.latch.countDown();
            }
        }

        public void waitUntilDropFinish() {
            log.debug("Waiting for graph {} to be evicted from the cache in all JanusGraph nodes...", (Object)this.graphName);
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("Thread interrupted while waiting for graph to be dropped.", (Throwable)e);
            }
        }
    }
}

