/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.io.binary.geoshape;

import java.util.List;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.graphdb.tinkerpop.io.binary.geoshape.GeoshapeTypeSerializer;
import org.janusgraph.graphdb.tinkerpop.io.binary.geoshape.PointCollectionSerializer;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeFactory;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class MultiLineSerializer
extends GeoshapeTypeSerializer {
    private static final PointCollectionSerializer pointCollectionSerializer = new PointCollectionSerializer();

    public MultiLineSerializer() {
        super(6);
    }

    @Override
    public Geoshape readNonNullableGeoshapeValue(Buffer buffer, GraphBinaryReader context) {
        int nrLines = buffer.readInt();
        ShapeFactory.MultiLineStringBuilder multiLineStringBuilder = Geoshape.getShapeFactory().multiLineString();
        for (int i = 0; i < nrLines; ++i) {
            List<double[]> linePoints = pointCollectionSerializer.readPoints(buffer);
            ShapeFactory.LineStringBuilder line = Geoshape.getShapeFactory().lineString();
            for (double[] point : linePoints) {
                line.pointXY(point[0], point[1]);
            }
            multiLineStringBuilder.add(line);
        }
        return Geoshape.geoshape(multiLineStringBuilder.build());
    }

    @Override
    public void writeNonNullableGeoshapeValue(Geoshape geoshape, Buffer buffer, GraphBinaryWriter context) {
        Shape shape = geoshape.getShape();
        Geometry geom = ((JtsGeometry)shape).getGeom();
        int nrLines = geom.getNumGeometries();
        buffer.writeInt(nrLines);
        for (int i = 0; i < nrLines; ++i) {
            Geometry line = geom.getGeometryN(i);
            pointCollectionSerializer.writePoints(line.getCoordinates(), buffer);
        }
    }
}

