/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.relations;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.janusgraph.util.encoding.LongEncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RelationIdentifier
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelationIdentifier.class);
    public static final String JANUSGRAPH_RELATION_DELIMITER = "JANUSGRAPH_RELATION_DELIMITER";
    public static final String TOSTRING_DELIMITER;
    private final Object outVertexId;
    private final long typeId;
    private final long relationId;
    private final Object inVertexId;

    private RelationIdentifier() {
        this.outVertexId = null;
        this.typeId = 0L;
        this.relationId = 0L;
        this.inVertexId = null;
    }

    public RelationIdentifier(Object outVertexId, long typeId, long relationId, Object inVertexId) {
        this.outVertexId = outVertexId;
        this.typeId = typeId;
        this.relationId = relationId;
        this.inVertexId = inVertexId;
    }

    public long getRelationId() {
        return this.relationId;
    }

    public long getTypeId() {
        return this.typeId;
    }

    public Object getOutVertexId() {
        return this.outVertexId;
    }

    public Object getInVertexId() {
        return this.inVertexId;
    }

    public static RelationIdentifier get(Object[] ids) {
        if (ids.length != 3 && ids.length != 4) {
            throw new IllegalArgumentException("Not a valid relation identifier: " + Arrays.toString(ids));
        }
        for (int i = 0; i < 3; ++i) {
            if (!(ids[i] instanceof Number) || ((Number)ids[i]).longValue() >= 0L) continue;
            throw new IllegalArgumentException("Not a valid relation identifier: " + Arrays.toString(ids));
        }
        return new RelationIdentifier(ids[1], ((Number)ids[2]).longValue(), ((Number)ids[0]).longValue(), ids.length == 4 ? ids[3] : Integer.valueOf(0));
    }

    public static RelationIdentifier get(int[] ids) {
        if (ids.length != 3 && ids.length != 4) {
            throw new IllegalArgumentException("Not a valid relation identifier: " + Arrays.toString(ids));
        }
        for (int i = 0; i < 3; ++i) {
            if (ids[i] >= 0) continue;
            throw new IllegalArgumentException("Not a valid relation identifier: " + Arrays.toString(ids));
        }
        return new RelationIdentifier(ids[1], ids[2], ids[0], ids.length == 4 ? ids[3] : 0);
    }

    public int hashCode() {
        return Long.hashCode(this.relationId);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        RelationIdentifier oth = (RelationIdentifier)other;
        return this.relationId == oth.relationId && this.typeId == oth.typeId;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(LongEncoding.encode(this.relationId)).append(TOSTRING_DELIMITER);
        if (this.outVertexId instanceof Number) {
            s.append(LongEncoding.encode(((Number)this.outVertexId).longValue()));
        } else {
            assert (this.outVertexId instanceof String);
            s.append('S').append(this.outVertexId);
        }
        s.append(TOSTRING_DELIMITER).append(LongEncoding.encode(this.typeId));
        if (this.inVertexId != null) {
            if (this.inVertexId instanceof Number) {
                assert (((Number)this.inVertexId).longValue() > 0L);
                s.append(TOSTRING_DELIMITER).append(LongEncoding.encode(((Number)this.inVertexId).longValue()));
            } else {
                assert (this.inVertexId instanceof String);
                s.append(TOSTRING_DELIMITER).append('S').append(this.inVertexId);
            }
        }
        return s.toString();
    }

    public static RelationIdentifier parse(String id) {
        String[] elements = id.split(TOSTRING_DELIMITER);
        if (elements.length != 3 && elements.length != 4) {
            throw new IllegalArgumentException("Not a valid relation identifier: " + id);
        }
        try {
            Object outVertexId = elements[1].charAt(0) == 'S' ? elements[1].substring(1) : Long.valueOf(LongEncoding.decode(elements[1]));
            long typeId = LongEncoding.decode(elements[2]);
            long relationId = LongEncoding.decode(elements[0]);
            Object inVertexId = null;
            if (elements.length == 4) {
                inVertexId = elements[3].charAt(0) == 'S' ? elements[3].substring(1) : Long.valueOf(LongEncoding.decode(elements[3]));
            }
            return new RelationIdentifier(outVertexId, typeId, relationId, inVertexId);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid id - each token expected to be a number", e);
        }
    }

    static {
        String reservedKeyword = System.getProperty(JANUSGRAPH_RELATION_DELIMITER);
        if (StringUtils.isEmpty((CharSequence)reservedKeyword)) {
            reservedKeyword = System.getenv(JANUSGRAPH_RELATION_DELIMITER);
        }
        if (StringUtils.isNotEmpty((CharSequence)reservedKeyword)) {
            if (!StringUtils.isAsciiPrintable((CharSequence)reservedKeyword)) {
                throw new IllegalStateException("JanusGraph relation delimiter must be ASCII printable: " + reservedKeyword);
            }
            if (reservedKeyword.length() > 1) {
                throw new IllegalStateException("JanusGraph relation delimiter must be single character: " + reservedKeyword);
            }
            TOSTRING_DELIMITER = reservedKeyword;
            LOGGER.info("Loaded {} from system property, relation delimiter is: {}", (Object)JANUSGRAPH_RELATION_DELIMITER, (Object)TOSTRING_DELIMITER);
        } else {
            TOSTRING_DELIMITER = "-";
            LOGGER.info("Use default relation delimiter: {}", (Object)TOSTRING_DELIMITER);
        }
    }
}

