/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.formats.cql;

import java.io.IOException;
import java.util.List;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.cql3.CqlConfigHelper;
import org.apache.cassandra.hadoop.cql3.CqlInputFormat;
import org.apache.cassandra.hadoop.cql3.CqlRecordReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.hadoop.config.JanusGraphHadoopConfiguration;
import org.janusgraph.hadoop.formats.cql.CqlBinaryRecordReader;
import org.janusgraph.hadoop.formats.util.AbstractBinaryInputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqlBinaryInputFormat
extends AbstractBinaryInputFormat {
    private static final Logger log = LoggerFactory.getLogger(CqlBinaryInputFormat.class);
    private static final String INPUT_WIDEROWS_CONFIG = "cassandra.input.widerows";
    private static final String RANGE_BATCH_SIZE_CONFIG = "cassandra.range.batch.size";
    private final CqlInputFormat cqlInputFormat = new CqlInputFormat();

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException {
        return this.cqlInputFormat.getSplits(jobContext);
    }

    public RecordReader<StaticBuffer, Iterable<Entry>> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        CqlRecordReader recordReader = (CqlRecordReader)this.cqlInputFormat.createRecordReader(inputSplit, taskAttemptContext);
        return new CqlBinaryRecordReader(recordReader);
    }

    public void setConf(Configuration config) {
        super.setConf(config);
        ConfigHelper.setInputInitialAddress((Configuration)config, (String)String.join((CharSequence)",", (CharSequence[])this.janusgraphConf.get(GraphDatabaseConfiguration.STORAGE_HOSTS, new String[0])));
        if (this.janusgraphConf.has(GraphDatabaseConfiguration.STORAGE_PORT, new String[0])) {
            CqlConfigHelper.setInputNativePort((Configuration)config, (String)String.valueOf(this.janusgraphConf.get(GraphDatabaseConfiguration.STORAGE_PORT, new String[0])));
        }
        if (this.janusgraphConf.has(GraphDatabaseConfiguration.AUTH_USERNAME, new String[0]) && this.janusgraphConf.has(GraphDatabaseConfiguration.AUTH_PASSWORD, new String[0])) {
            CqlConfigHelper.setUserNameAndPassword((Configuration)config, (String)((String)this.janusgraphConf.get(GraphDatabaseConfiguration.AUTH_USERNAME, new String[0])), (String)((String)this.janusgraphConf.get(GraphDatabaseConfiguration.AUTH_PASSWORD, new String[0])));
        }
        boolean wideRows = config.getBoolean(INPUT_WIDEROWS_CONFIG, false);
        ConfigHelper.setInputColumnFamily((Configuration)config, (String)((String)this.janusgraphConf.get(CQLConfigOptions.KEYSPACE, new String[0])), (String)((String)this.mrConf.get(JanusGraphHadoopConfiguration.COLUMN_FAMILY_NAME, new String[0])), (boolean)wideRows);
        log.debug("Set keyspace: {}", this.janusgraphConf.get(CQLConfigOptions.KEYSPACE, new String[0]));
    }
}

