/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.structure.io.gryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.configuration2.Configuration;
import org.apache.spark.serializer.KryoRegistrator;
import org.apache.spark.util.collection.CompactBuffer;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopEdge;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopProperty;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopVertex;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopVertexProperty;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.ObjectWritable;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.process.computer.util.ComputerGraph;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ImmutablePath;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.MutablePath;
import org.apache.tinkerpop.gremlin.spark.process.computer.payload.MessagePayload;
import org.apache.tinkerpop.gremlin.spark.process.computer.payload.ViewIncomingPayload;
import org.apache.tinkerpop.gremlin.spark.process.computer.payload.ViewOutgoingPayload;
import org.apache.tinkerpop.gremlin.spark.process.computer.payload.ViewPayload;
import org.apache.tinkerpop.gremlin.spark.structure.io.gryo.ObjectWritableSerializer;
import org.apache.tinkerpop.gremlin.spark.structure.io.gryo.VertexWritableSerializer;
import org.apache.tinkerpop.gremlin.spark.structure.io.gryo.kryoshim.unshaded.UnshadedSerializerAdapter;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoMapper;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoSerializersV1;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoVersion;
import org.apache.tinkerpop.gremlin.structure.io.gryo.TypeRegistration;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.SerializerShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.shaded.ShadedSerializerAdapter;
import org.apache.tinkerpop.gremlin.structure.io.util.IoRegistryHelper;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraph;
import org.apache.tinkerpop.gremlin.util.SystemUtil;
import org.apache.tinkerpop.shaded.kryo.serializers.JavaSerializer;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.mutable.WrappedArray;

public class GryoRegistrator
implements KryoRegistrator {
    private static final Logger log = LoggerFactory.getLogger(GryoRegistrator.class);

    public void registerClasses(Kryo kryo) {
        this.registerClasses(kryo, Collections.emptyMap(), Collections.emptySet());
    }

    public void registerClasses(Kryo kryo, Map<Class<?>, Serializer<?>> serializerOverrides, Set<Class<?>> blacklist) {
        for (Map.Entry<Class<?>, Serializer<?>> ent : this.getExtraRegistrations().entrySet()) {
            Class<?> targetClass = ent.getKey();
            Serializer<?> ser = ent.getValue();
            if (blacklist.contains(targetClass)) {
                log.debug("Not registering serializer for {} (blacklisted)", targetClass);
                continue;
            }
            if (this.checkForAndApplySerializerOverride(serializerOverrides, kryo, targetClass)) continue;
            if (null == ser) {
                log.debug("Registering {} with default serializer", targetClass);
                kryo.register(targetClass);
                continue;
            }
            log.debug("Registering {} with serializer {}", targetClass, ser);
            kryo.register(targetClass, ser);
        }
        HashSet<Class> shimmedClassesFromGryoMapper = new HashSet<Class>();
        for (TypeRegistration tr : GryoMapper.build().version(GryoVersion.V1_0).create().getTypeRegistrations()) {
            if (blacklist.contains(tr.getTargetClass())) {
                log.debug("Not registering serializer for {} (blacklisted)", (Object)tr.getTargetClass());
                continue;
            }
            org.apache.tinkerpop.shaded.kryo.Serializer shadedSerializer = tr.getShadedSerializer();
            SerializerShim serializerShim = tr.getSerializerShim();
            Function functionOfShadedKryo = tr.getFunctionOfShadedKryo();
            if (this.checkForAndApplySerializerOverride(serializerOverrides, kryo, tr.getTargetClass())) continue;
            if (null != shadedSerializer) {
                if (shadedSerializer.getClass().equals(JavaSerializer.class)) {
                    log.debug("Registering {} with JavaSerializer", (Object)tr.getTargetClass());
                    kryo.register(tr.getTargetClass(), (Serializer)new com.esotericsoftware.kryo.serializers.JavaSerializer());
                    continue;
                }
                log.error("GryoMapper's default serialization registration for {} is a {}. This is probably a bug in TinkerPop (this is not a valid default registration). I am configuring Spark to use Kryo's default serializer for this class, but this may cause serialization failures at runtime.", (Object)tr.getTargetClass(), (Object)org.apache.tinkerpop.shaded.kryo.Serializer.class.getCanonicalName());
                kryo.register(tr.getTargetClass());
                continue;
            }
            if (null != serializerShim) {
                log.debug("Registering {} to serializer shim {} (serializer shim {})", new Object[]{tr.getTargetClass(), serializerShim, serializerShim.getClass()});
                kryo.register(tr.getTargetClass(), new UnshadedSerializerAdapter(serializerShim));
                shimmedClassesFromGryoMapper.add(tr.getTargetClass());
                continue;
            }
            if (null != functionOfShadedKryo) {
                log.error("GryoMapper's default serialization registration for {} is a Function<{},{}>.  This is probably a bug in TinkerPop (this is not a valid default registration). I am configuring Spark to use Kryo's default serializer instead of this function, but this may cause serialization failures at runtime.", new Object[]{tr.getTargetClass(), org.apache.tinkerpop.shaded.kryo.Kryo.class.getCanonicalName(), org.apache.tinkerpop.shaded.kryo.Serializer.class.getCanonicalName()});
                kryo.register(tr.getTargetClass());
                continue;
            }
            log.debug("Registering {} with default serializer", (Object)tr.getTargetClass());
            kryo.register(tr.getTargetClass());
        }
        if (!shimmedClassesFromGryoMapper.contains(StarGraph.class)) {
            log.warn("No SerializerShim found for StarGraph");
        }
        for (IoRegistry registry : IoRegistryHelper.createRegistries((Configuration)SystemUtil.getSystemPropertiesConfiguration((String)"tinkerpop", (boolean)true))) {
            for (Pair pair : registry.find(GryoIo.class)) {
                if (pair.getValue1() instanceof SerializerShim) {
                    kryo.register((Class)pair.getValue0(), new UnshadedSerializerAdapter((SerializerShim)pair.getValue1()));
                    continue;
                }
                if (pair.getValue1() instanceof ShadedSerializerAdapter) {
                    kryo.register((Class)pair.getValue0(), new UnshadedSerializerAdapter(((ShadedSerializerAdapter)pair.getValue1()).getSerializerShim()));
                    continue;
                }
                kryo.register((Class)pair.getValue0(), kryo.getDefaultSerializer((Class)pair.getValue0()));
            }
        }
    }

    private LinkedHashMap<Class<?>, Serializer<?>> getExtraRegistrations() {
        LinkedHashMap m = new LinkedHashMap();
        try {
            m.put(Class.forName("scala.reflect.ManifestFactory$AnyManifest"), (Serializer<?>)new com.esotericsoftware.kryo.serializers.JavaSerializer());
            m.put(Class.forName("scala.reflect.ClassTag$GenericClassTag"), (Serializer<?>)new com.esotericsoftware.kryo.serializers.JavaSerializer());
            m.put(Class.forName("org.apache.spark.internal.io.FileCommitProtocol$TaskCommitMessage"), (Serializer<?>)new com.esotericsoftware.kryo.serializers.JavaSerializer());
            m.put(Class.forName("org.apache.spark.internal.io.FileCommitProtocol$EmptyTaskCommitMessage$"), (Serializer<?>)new com.esotericsoftware.kryo.serializers.JavaSerializer());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        m.put(WrappedArray.ofRef.class, null);
        m.put(MessagePayload.class, null);
        m.put(ViewIncomingPayload.class, null);
        m.put(ViewOutgoingPayload.class, null);
        m.put(ViewPayload.class, null);
        m.put(VertexWritable.class, new UnshadedSerializerAdapter<VertexWritable>(new VertexWritableSerializer()));
        m.put(ObjectWritable.class, new UnshadedSerializerAdapter(new ObjectWritableSerializer()));
        m.put(HadoopVertex.class, new UnshadedSerializerAdapter(new GryoSerializersV1.VertexSerializer()));
        m.put(HadoopVertexProperty.class, new UnshadedSerializerAdapter(new GryoSerializersV1.VertexPropertySerializer()));
        m.put(HadoopProperty.class, new UnshadedSerializerAdapter(new GryoSerializersV1.PropertySerializer()));
        m.put(HadoopEdge.class, new UnshadedSerializerAdapter(new GryoSerializersV1.EdgeSerializer()));
        m.put(ComputerGraph.ComputerVertex.class, new UnshadedSerializerAdapter(new GryoSerializersV1.VertexSerializer()));
        m.put(ComputerGraph.ComputerVertexProperty.class, new UnshadedSerializerAdapter(new GryoSerializersV1.VertexPropertySerializer()));
        m.put(ComputerGraph.ComputerProperty.class, new UnshadedSerializerAdapter(new GryoSerializersV1.PropertySerializer()));
        m.put(ComputerGraph.ComputerEdge.class, new UnshadedSerializerAdapter(new GryoSerializersV1.EdgeSerializer()));
        m.put(StarGraph.StarEdge.class, new UnshadedSerializerAdapter(new GryoSerializersV1.EdgeSerializer()));
        m.put(StarGraph.StarVertex.class, new UnshadedSerializerAdapter(new GryoSerializersV1.VertexSerializer()));
        m.put(StarGraph.StarProperty.class, new UnshadedSerializerAdapter(new GryoSerializersV1.PropertySerializer()));
        m.put(StarGraph.StarVertexProperty.class, new UnshadedSerializerAdapter(new GryoSerializersV1.VertexPropertySerializer()));
        m.put(MutablePath.class, new UnshadedSerializerAdapter(new GryoSerializersV1.PathSerializer()));
        m.put(ImmutablePath.class, new UnshadedSerializerAdapter(new GryoSerializersV1.PathSerializer()));
        m.put(CompactBuffer[].class, null);
        return m;
    }

    private boolean checkForAndApplySerializerOverride(Map<Class<?>, Serializer<?>> serializerOverrides, Kryo kryo, Class<?> targetClass) {
        if (serializerOverrides.containsKey(targetClass)) {
            Serializer<?> ser = serializerOverrides.get(targetClass);
            if (null == ser) {
                log.debug("Registering {} with default serializer per overrides", targetClass);
                kryo.register(targetClass);
            } else {
                log.debug("Registering {} with serializer {} per overrides", targetClass, ser);
                kryo.register(targetClass, ser);
            }
            return true;
        }
        return false;
    }
}

